/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.network;

import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class ClientHandshakeRequest
extends Request {
    private String nonce = "";
    private PublicKey publicKey = new PublicKey();
    private byte[] signature = new byte[0];

    public ClientHandshakeRequest(String nonce, byte[] signature) {
        super(MessageType.MSG_TYPE_HAND_SHAKE);
        this.nonce = nonce;
        this.signature = signature;
    }

    public ClientHandshakeRequest() {
        super(MessageType.MSG_TYPE_HAND_SHAKE);
    }

    public String getNonce() {
        return this.nonce;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public byte[] toRlp() {
        byte[] nonceBytes = Rlp.encodeString(this.nonce);
        byte[] publicKeyBytes = Rlp.encodeElement(this.publicKey.getValue());
        byte[] signatureBytes = Rlp.encodeElement(this.signature);
        return Rlp.encodeList(nonceBytes, publicKeyBytes, signatureBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.nonce = ByteUtils.byteArrayToString(((RlpElement)list.get(0)).getRlpData());
        this.publicKey = new PublicKey(((RlpElement)list.get(1)).getRlpData());
        this.signature = ((RlpElement)list.get(2)).getRlpData();
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

