/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryTransactionRequest
extends Request {
    private Hash txHash;

    public QueryTransactionRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION);
    }

    public QueryTransactionRequest(Hash txHash) {
        super(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION);
        this.txHash = txHash;
    }

    public QueryTransactionRequest(Hash txHash, BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        super(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION);
        this.txHash = txHash;
        this.setGroupId(groupId);
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(Hash txHash) {
        this.txHash = txHash;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.txHash != null && !this.txHash.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue());
    }

    @Override
    public byte[] toRlp() {
        byte[] txHashBytes = Rlp.encodeElement(this.txHash.getValue());
        return Rlp.encodeList(super.toRlp(), txHashBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.txHash = new Hash(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.txHash.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.txHash = new Hash(jsonObject.getString("hash"));
    }
}

