/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.contract;

import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.utils.VMUtils;
import org.apache.commons.lang3.ArrayUtils;

public class UpdateContractRequest
extends AbstractTransactionRequest {
    private Identity contractId;
    private byte[] code;
    private VMTypeEnum vmTypeEnum;

    public UpdateContractRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_CONTRACT_UPDATE);
    }

    public UpdateContractRequest(Identity contractId, byte[] code, VMTypeEnum vmTypeEnum) {
        super(MessageType.MSG_TYPE_TX_REQ_CONTRACT_UPDATE);
        this.contractId = contractId;
        this.code = code;
        this.vmTypeEnum = vmTypeEnum;
    }

    public Identity getContractId() {
        return this.contractId;
    }

    public byte[] getCode() {
        return this.code;
    }

    public VMTypeEnum getVmTypeEnum() {
        return this.vmTypeEnum;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.contractId != null && !this.contractId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && ArrayUtils.isNotEmpty((byte[])this.code) && (this.vmTypeEnum == VMTypeEnum.NATIVE || this.vmTypeEnum == VMTypeEnum.EVM || this.vmTypeEnum == VMTypeEnum.WASM || this.vmTypeEnum == VMTypeEnum.NATIVE_PRECOMPILE);
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.UPDATE_CONTRACT);
        transaction.setFrom(this.contractId);
        transaction.setTo(this.contractId);
        transaction.setData(VMUtils.encodeVMType(this.vmTypeEnum, this.code));
        super.complete();
    }
}

