/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi;

import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.vm.abi.MyTypeEncoder;
import com.alipay.mychain.sdk.vm.abi.datatype.StaticArray;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import java.math.BigInteger;
import java.util.List;

public class MyFunctionEncoder {
    private MyFunctionEncoder() {
    }

    public static String encodeConstructor(List<Type> parameters) {
        return MyFunctionEncoder.encodeParameters(parameters, new StringBuilder());
    }

    public static String encodeParameters(List<Type> parameters, StringBuilder result) {
        int dynamicDataOffset = MyFunctionEncoder.getLength(parameters) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = MyTypeEncoder.encode(parameter);
            if (MyTypeEncoder.isDynamic(parameter)) {
                String encodedDataOffset = MyTypeEncoder.encodeNumeric(new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result.append(encodedValue);
        }
        result.append((CharSequence)dynamicData);
        return result.toString();
    }

    public static String buildMethodId(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = HashFactory.getHash(HashTypeEnum.Keccak).hash(input);
        return Numeric.toHexString(hash).substring(0, 10);
    }

    private static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticArray) {
                count += ((StaticArray)type).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }
}

