/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.cryptoservice;

import com.alipay.mychain.zoro.crypto.AlgorithmService;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.cryptoservice.AbstractCryptoService;
import com.alipay.mychain.zoro.crypto.ecdsa.AbstractKeyPair;
import com.alipay.mychain.zoro.crypto.ecdsa.ECDSASignature;
import com.alipay.mychain.zoro.crypto.ecdsa.ECKeyPair;
import com.alipay.mychain.zoro.crypto.ecdsa.ECSignUtils;
import com.alipay.mychain.zoro.crypto.keymanagement.KeyManagement;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class CryptoServiceDefault
extends AbstractCryptoService {
    private static CryptoServiceDefault instance = new CryptoServiceDefault();
    private static final Logger logger = Logger.getLogger(CryptoServiceDefault.class.getName());
    private static final String ALGO_RSA = "RSA/ECB/PKCS1Padding";
    private static final ThreadLocal<Cipher> RSA = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(CryptoServiceDefault.ALGO_RSA);
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.SEVERE, "RSA2048 encryption algorithm NOT Found.", e);
            }
            catch (NoSuchPaddingException e) {
                logger.log(Level.SEVERE, "RSA/ECB/PKCS1Padding Padding NOT Found.", e);
            }
            return null;
        }
    };

    private CryptoServiceDefault() {
    }

    public static CryptoServiceDefault getInstance() {
        return instance;
    }

    @Override
    public byte[] rsa2048Decrypt(byte[] keyname, byte[] password, byte[] ciphertext) throws CryptoException {
        RSAPrivateKey privateKey;
        if (keyname == null) {
            throw new CryptoException("rsa2048Decrypt exception: keyname is null.");
        }
        if (password == null) {
            throw new CryptoException("rsa2048Decrypt exception: password is null.");
        }
        try {
            privateKey = KeyManagement.getRsaPrivateKey(keyname, password);
        }
        catch (Exception e) {
            throw new CryptoException("RSA 2048 Decrypt Load Key Fail.", e);
        }
        try {
            Cipher rsa = RSA.get();
            rsa.init(2, privateKey);
            byte[] byArray = rsa.doFinal(ciphertext);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException("RSA 2048 Decrypt fail.", e);
        }
        finally {
            RSA.remove();
        }
    }

    @Override
    public byte[] ecdsaSign(byte[] keyname, byte[] password, byte[] message) throws CryptoException {
        ECPrivateKey privateKey;
        if (keyname == null) {
            throw new CryptoException("ecdsaSign exception: keyname is null.");
        }
        if (password == null) {
            throw new CryptoException("ecdsaSign exception: password is null.");
        }
        try {
            privateKey = KeyManagement.getEcdsaPrivateKey(keyname, password);
        }
        catch (Exception e) {
            throw new CryptoException("ECDSA Sign Load Key Fail.", e);
        }
        try {
            ECKeyPair keyPair = new ECKeyPair(privateKey.getS());
            PublicKey jceEcPubkey = ECSignUtils.publicKeyFromPrivateKey(((AbstractKeyPair)keyPair).getPrivateKey());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(jceEcPubkey.getEncoded());
            byte[] hashMessage = AlgorithmService.sha256(message);
            byte[] bytePubkey = x509EncodedKeySpec.getEncoded();
            byte[] byteDerSign = ((ECDSASignature)((AbstractKeyPair)keyPair).sign(hashMessage)).encodeToDER();
            byte[] concatPubkeyDerSign = new byte[bytePubkey.length + byteDerSign.length];
            System.arraycopy(bytePubkey, 0, concatPubkeyDerSign, 0, bytePubkey.length);
            System.arraycopy(byteDerSign, 0, concatPubkeyDerSign, bytePubkey.length, byteDerSign.length);
            return concatPubkeyDerSign;
        }
        catch (Exception e) {
            throw new CryptoException("ECDSA sign fail.", e);
        }
    }
}

