/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.keymanagement;

import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoContext;
import com.alipay.mychain.zoro.crypto.keymanagement.KeyManagement;
import com.alipay.mychain.zoro.crypto.keymanagement.KeyManagementSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;

public class KeyManagementRaw {
    private static final int BYTE_BIT_LEN = 8;
    private static final int MAX_RSA_LEN = 256;
    private KeyManagementSpi keyManagementSpi;

    KeyManagementRaw(KeyManagementSpi keyManagementSpi) {
        this.keyManagementSpi = keyManagementSpi;
    }

    public static final KeyManagementRaw getInstance() {
        KeyManagementSpi sp = CryptoContext.getKeyManagementSpi();
        return new KeyManagementRaw(sp);
    }

    public RSAPrivateKey getRsaPrivateKey(byte[] keyname, byte[] password) throws CryptoException {
        if (this.keyManagementSpi == null) {
            throw new CryptoException("Key Management Spi is null.");
        }
        RSAPrivateKey rsaPrivateKey = this.keyManagementSpi.getRsaPrivateKey(keyname, password);
        if (!(rsaPrivateKey instanceof RSAPrivateKey)) {
            throw new CryptoException("RSA 2048 Decrypt Invalid Key Type.");
        }
        if (256 != (rsaPrivateKey.getModulus().bitLength() + 8 - 1) / 8) {
            throw new CryptoException("RSA 2048 Decrypt Invalid Key Length.");
        }
        return rsaPrivateKey;
    }

    public ECPrivateKey getEcdsaPrivateKey(byte[] keyname, byte[] password) throws CryptoException {
        ECParameterSpec ecParameterSpec2;
        ECParameterSpec ecParameterSpec1;
        if (this.keyManagementSpi == null) {
            throw new CryptoException("Key Management Spi is null.");
        }
        ECPrivateKey ecPrivateKey = this.keyManagementSpi.getEcdsaPrivateKey(keyname, password);
        if (!(ecPrivateKey instanceof ECPrivateKey)) {
            throw new CryptoException("ECDSA Sign Invalid Key Type.");
        }
        try {
            ecParameterSpec1 = KeyManagement.getECParameter();
            ecParameterSpec2 = ecPrivateKey.getParams();
        }
        catch (Exception e) {
            throw new CryptoException("ECDSA Sign Check Key Fail. GetParams fail.", e);
        }
        if (ecParameterSpec2 == null || ecParameterSpec1 == null) {
            throw new CryptoException("ECDSA Sign Check Key Fail. ECParameterSpec is null.");
        }
        if (!ecParameterSpec1.getCurve().equals(ecParameterSpec2.getCurve())) {
            throw new CryptoException("ECDSA Sign Check Key Fail. Elliptic curve is not secp256r1. the curve parammeter is different.");
        }
        if (ecParameterSpec1.getCofactor() != ecParameterSpec2.getCofactor()) {
            throw new CryptoException("ECDSA Sign Check Key Fail. Elliptic curve is not secp256r1. The confactor is different.");
        }
        if (!ecParameterSpec1.getOrder().equals(ecParameterSpec2.getOrder())) {
            throw new CryptoException("ECDSA Sign Check Key Fail. Elliptic curve is not secp256r1. The order is different.");
        }
        if (!ecParameterSpec1.getGenerator().equals(ecParameterSpec2.getGenerator())) {
            throw new CryptoException("ECDSA Sign Check Key Fail. Elliptic curve is not secp256r1. The generator is different.");
        }
        return ecPrivateKey;
    }
}

