/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.utils;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class ConfidentialUtil {
    public static byte[] decrypt(String userKey, byte[] oldOutput, String txHash) {
        try {
            byte[] secretKey = ConfidentialUtil.keyGenerate(userKey, ByteUtils.hexStringToBytes(txHash));
            AesGcmCipherV1 aesGcmCipherV1 = new AesGcmCipherV1(secretKey);
            byte[] algoId = AlgoIdEnum.CIPHER_AES_GCM_LOCAL_V1.toBytes();
            byte[] ciphertext = new byte[oldOutput.length + 2];
            System.arraycopy(algoId, 0, ciphertext, 0, 2);
            System.arraycopy(oldOutput, oldOutput.length - 28, ciphertext, 2, 28);
            System.arraycopy(oldOutput, 0, ciphertext, 30, oldOutput.length - 28);
            return aesGcmCipherV1.decrypt(ciphertext);
        }
        catch (Throwable e) {
            throw new MychainSdkException(ErrorCode.SDK_DECODE_ERROR, "aes decrypt error" + e.getMessage());
        }
    }

    public static byte[] keyGenerate(String userKey, byte[] txHash) {
        if (userKey == null || userKey.isEmpty() || ArrayUtils.isEmpty((byte[])txHash)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "password and hashBytes should not empty.");
        }
        byte[] input_data = userKey.startsWith("0x") ? ByteUtils.hexStringToBytes(userKey) : ByteUtils.stringToByteArray(userKey);
        byte[] connectBytes = new byte[input_data.length + txHash.length];
        System.arraycopy(input_data, 0, connectBytes, 0, input_data.length);
        System.arraycopy(txHash, 0, connectBytes, input_data.length, txHash.length);
        byte[] hashArray = HashFactory.getHash().hash(connectBytes);
        return Arrays.copyOfRange(hashArray, 0, 16);
    }
}

