/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.codec;

import com.alipay.mychain.sdk.codec.ICodec;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageFactory;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.network.ClientHandshakeResponse;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class RlpCodec
implements ICodec {
    @Override
    public byte[] encode(Message msg) {
        if (MessageType.MSG_TYPE_HAND_SHAKE == msg.getMessageType()) {
            return msg.toRlp();
        }
        return Rlp.encodeList(Rlp.encodeInt(msg.getMessageType().getValue()), msg.toRlp());
    }

    @Override
    public Message decode(byte[] data) {
        try {
            RlpList list = (RlpList)Rlp.decode2(data).get(0);
            if (list.size() == 2 && list.get(0) instanceof RlpList) {
                ClientHandshakeResponse handshakeResponse = new ClientHandshakeResponse();
                handshakeResponse.fromRlp(list);
                return handshakeResponse;
            }
            MessageType type = MessageType.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(0)).getRlpData()));
            Message msg = (Message)MessageFactory.createMessage(type);
            if (msg == null) {
                return null;
            }
            msg.fromRlp((RlpList)list.get(1));
            return msg;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

