/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.pkeycipher;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.security.rsa.RSAPublicKeyImpl;

public class RSAPkeyCipherV0
implements PkeyCipherBase {
    private byte[] privateKey;
    private byte[] publicKey;

    public RSAPkeyCipherV0(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = ArrayUtils.clone((byte[])pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V0;
    }

    @Override
    public boolean isEncryptor() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey) || !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isDecryptor() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public byte[] encrypt(byte[] plainText) {
        if (ArrayUtils.isEmpty((byte[])plainText)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "plainText is empty");
        }
        if (plainText.length > 190) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "plainText size more than 190!");
        }
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA", "BC");
            X509EncodedKeySpec rsaPubkeySpec1 = new X509EncodedKeySpec(this.publicKey);
            RSAPublicKey rsaCipherPubkey = (RSAPublicKey)rsaKeyFactory.generatePublic(rsaPubkeySpec1);
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", "BC");
            rsaCipher.init(1, rsaCipherPubkey);
            return rsaCipher.doFinal(plainText);
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (BadPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeySpecException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IllegalBlockSizeException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] decrypt(byte[] cipherText) {
        if (ArrayUtils.isEmpty((byte[])cipherText) || cipherText.length != 256) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need cipherText size 256 but " + (ArrayUtils.isEmpty((byte[])cipherText) ? 0 : cipherText.length));
        }
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA", "BC");
            PKCS8EncodedKeySpec rsaPrivkeySpec = new PKCS8EncodedKeySpec(this.privateKey);
            RSAPrivateKey rsaCipherPrivkey = (RSAPrivateKey)rsaKeyFactory.generatePrivate(rsaPrivkeySpec);
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", "BC");
            rsaCipher.init(2, rsaCipherPrivkey);
            return rsaCipher.doFinal(cipherText);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (BadPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeySpecException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IllegalBlockSizeException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private byte[] getPubKeyByPrivkey(byte[] privKey) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateCrtKey privateK = (RSAPrivateCrtKey)keyFactory.generatePrivate(pkcs8KeySpec);
            RSAPublicKeyImpl rsaPublicKey = new RSAPublicKeyImpl(privateK.getModulus(), privateK.getPublicExponent());
            return rsaPublicKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeySpecException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "priKey is invalid :: " + e.getMessage());
        }
    }
}

