/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class AuthMap
implements Serializable {
    private static final long serialVersionUID = -3309297039357729846L;
    private Map<PublicKey, Integer> authMap = new LinkedHashMap<PublicKey, Integer>(1);

    public Map<PublicKey, Integer> getAuthMap() {
        return this.authMap;
    }

    public void setAuthMap(Map<PublicKey, Integer> authMap) {
        this.authMap = authMap;
    }

    public AuthMap updateAuth(PublicKey authKey, Integer authWeight) {
        if (null == authKey || null == authWeight) {
            return this;
        }
        this.authMap.put(authKey, authWeight);
        return this;
    }

    public AuthMap deleteAuth(PublicKey authKey) {
        if (null == authKey || !this.authMap.containsKey(authKey)) {
            return this;
        }
        this.authMap.remove(authKey);
        return this;
    }

    public boolean isValid() {
        if (this.authMap == null) {
            return false;
        }
        Integer totalWeight = 0;
        for (Map.Entry<PublicKey, Integer> entry : this.authMap.entrySet()) {
            totalWeight = totalWeight + entry.getValue();
        }
        return totalWeight >= 100;
    }

    public byte[] toRlp() {
        ArrayList<byte[]> listData = new ArrayList<byte[]>();
        for (Map.Entry<PublicKey, Integer> entry : this.authMap.entrySet()) {
            listData.add(Rlp.encodeElement(entry.getKey().getValue()));
            listData.add(Rlp.encodeInt(entry.getValue()));
        }
        return Rlp.encodeList(listData);
    }

    public void fromRlp(RlpList list) {
        int length = list.size() / 2;
        for (int i = 0; i < length; ++i) {
            this.authMap.put(new PublicKey(((RlpElement)list.get(i * 2)).getRlpData()), ByteUtils.byteArrayToInt(((RlpElement)list.get(i * 2 + 1)).getRlpData()));
        }
    }

    public void toJson(JSONArray jsonArray) {
        for (Map.Entry<PublicKey, Integer> entry : this.authMap.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", (Object)ByteUtils.toHexString(entry.getKey().getValue()));
            jsonObject.put("value", (Object)entry.getValue());
            jsonArray.add((Object)jsonObject);
        }
    }

    public void fromJson(JSONArray jsonArray) {
        if (jsonArray != null) {
            for (JSONObject jsonObject : jsonArray) {
                this.authMap.put(new PublicKey(jsonObject.getString("key")), jsonObject.getInteger("value"));
            }
        }
    }
}

