/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.block;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BlockBody
extends MychainObject {
    private List<Transaction> transactionList;
    private List<TransactionReceipt> receiptList;
    private byte[] consensusProof;

    public BlockBody(List<Transaction> transactionList, List<TransactionReceipt> receiptList, byte[] consensusProof) {
        this.transactionList = transactionList;
        this.receiptList = receiptList;
        this.consensusProof = consensusProof;
    }

    public BlockBody() {
    }

    public List<Transaction> getTransactionList() {
        return this.transactionList;
    }

    public void setTransactionList(List<Transaction> transactionList) {
        this.transactionList = transactionList;
    }

    public List<TransactionReceipt> getReceiptList() {
        return this.receiptList;
    }

    public void setReceiptList(List<TransactionReceipt> receiptList) {
        this.receiptList = receiptList;
    }

    public byte[] getConsensusProof() {
        return this.consensusProof;
    }

    public void setConsensusProof(byte[] consensusProof) {
        this.consensusProof = consensusProof;
    }

    public Transaction getTransactionByHash(Hash hash) {
        if (null != this.transactionList) {
            for (Transaction transaction : this.transactionList) {
                if (!transaction.getHash().equals(hash)) continue;
                return transaction;
            }
        }
        return null;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> txData = new ArrayList<byte[]>();
        for (Transaction item : this.transactionList) {
            txData.add(item.toRlp());
        }
        ArrayList<byte[]> receiptData = new ArrayList<byte[]>();
        for (TransactionReceipt item : this.receiptList) {
            receiptData.add(item.toRlp());
        }
        return Rlp.encodeList(Rlp.encodeList(txData), Rlp.encodeList(receiptData), Rlp.encodeElement(this.consensusProof));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.transactionList = new ArrayList<Transaction>();
        RlpList txList = (RlpList)list.get(0);
        for (RlpElement element : txList) {
            Transaction item = new Transaction();
            item.fromRlp((RlpList)element);
            this.transactionList.add(item);
        }
        this.receiptList = new ArrayList<TransactionReceipt>();
        RlpList receiptList = (RlpList)list.get(1);
        for (RlpElement element : receiptList) {
            TransactionReceipt item = new TransactionReceipt();
            item.fromRlp((RlpList)element);
            this.receiptList.add(item);
        }
        this.consensusProof = ((RlpElement)list.get(2)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        JSONArray txArray = new JSONArray();
        if (this.transactionList != null) {
            for (Transaction item : this.transactionList) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                txArray.add((Object)object);
            }
        }
        JSONArray receiptArray = new JSONArray();
        if (this.receiptList != null) {
            for (TransactionReceipt item : this.receiptList) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                receiptArray.add((Object)object);
            }
        }
        jsonObject.put("transaction_list", (Object)txArray);
        jsonObject.put("receipt_list", (Object)receiptArray);
        jsonObject.put("consensus_proof", (Object)ByteUtils.toHexString(this.consensusProof));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.transactionList = new ArrayList<Transaction>();
        JSONArray txArray = jsonObject.getJSONArray("transaction_list");
        if (txArray != null) {
            Iterator txIterator = txArray.iterator();
            while (txIterator.hasNext()) {
                Transaction object = new Transaction();
                object.fromJson((JSONObject)txIterator.next());
                this.transactionList.add(object);
            }
        }
        this.receiptList = new ArrayList<TransactionReceipt>();
        JSONArray receiptArray = jsonObject.getJSONArray("receipt_list");
        if (receiptArray != null) {
            Iterator receiptTterator = receiptArray.iterator();
            while (receiptTterator.hasNext()) {
                TransactionReceipt object = new TransactionReceipt();
                object.fromJson((JSONObject)receiptTterator.next());
                this.receiptList.add(object);
            }
        }
        this.consensusProof = ByteUtils.hexStringToBytes(jsonObject.getString("consensus_proof"));
    }
}

