/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.consensus.ConsensusAlgorithmType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class BlockProofInfo
extends MychainObject {
    private ConsensusAlgorithmType type;
    private byte[] proof;

    public BlockProofInfo(ConsensusAlgorithmType type, byte[] proof) {
        this.type = type;
        this.proof = proof;
    }

    public BlockProofInfo() {
    }

    public ConsensusAlgorithmType getType() {
        return this.type;
    }

    public void setType(ConsensusAlgorithmType type) {
        this.type = type;
    }

    public byte[] getProof() {
        return this.proof;
    }

    public void setProof(byte[] proof) {
        this.proof = proof;
    }

    @Override
    public byte[] toRlp() {
        byte[] typeBytes = Rlp.encodeInt(this.type.getValue());
        byte[] proofBytes = Rlp.encodeElement(this.proof);
        return Rlp.encodeList(typeBytes, proofBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.type = ConsensusAlgorithmType.getType(ByteUtils.byteArrayToInt(((RlpElement)list.get(0)).getRlpData()));
        this.proof = ((RlpElement)list.get(1)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("type", (Object)this.type.getValue());
        jsonObject.put("proof", (Object)ByteUtils.toHexString(this.proof));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.type = ConsensusAlgorithmType.getType(jsonObject.getIntValue("type"));
        this.proof = ByteUtils.hexStringToBytes(jsonObject.getString("proof"));
    }
}

