/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class BlockCacheInfo
extends MychainObject {
    private long unverifiedQueueLimit;
    private long verifiedQueueLimit;
    private long verifiedParentNotFoundQueueLimit;
    private long unverifiedQueueUsage;
    private long verifiedQueueUsage;
    private long verifiedParentNotFoundQueueUsage;
    private long unverifiedMaxBlockNumber;
    private long verifiedMaxBlockNumber;
    private long verifiedParentNotFoundMaxBlockNumber;

    public static BlockCacheInfo builder(long unverifiedQueueLimit, long verifiedQueueLimit, long verifiedParentNotFoundQueueLimit, long unverifiedQueueUsage, long verifiedQueueUsage, long verifiedParentNotFoundQueueUsage, long unverifiedMaxBlockNumber, long verifiedMaxBlockNumber, long verifiedParentNotFoundMaxBlockNumber) {
        BlockCacheInfo blockCacheInfo = new BlockCacheInfo();
        blockCacheInfo.unverifiedQueueLimit = unverifiedQueueLimit;
        blockCacheInfo.verifiedQueueLimit = verifiedQueueLimit;
        blockCacheInfo.verifiedParentNotFoundQueueLimit = verifiedParentNotFoundQueueLimit;
        blockCacheInfo.unverifiedQueueUsage = unverifiedQueueUsage;
        blockCacheInfo.verifiedQueueUsage = verifiedQueueUsage;
        blockCacheInfo.verifiedParentNotFoundQueueUsage = verifiedParentNotFoundQueueUsage;
        blockCacheInfo.unverifiedMaxBlockNumber = unverifiedMaxBlockNumber;
        blockCacheInfo.verifiedMaxBlockNumber = verifiedMaxBlockNumber;
        blockCacheInfo.verifiedParentNotFoundMaxBlockNumber = verifiedParentNotFoundMaxBlockNumber;
        return blockCacheInfo;
    }

    public long getUnverifiedQueueLimit() {
        return this.unverifiedQueueLimit;
    }

    public long getVerifiedQueueLimit() {
        return this.verifiedQueueLimit;
    }

    public long getVerifiedParentNotFoundQueueLimit() {
        return this.verifiedParentNotFoundQueueLimit;
    }

    public long getUnverifiedQueueUsage() {
        return this.unverifiedQueueUsage;
    }

    public long getVerifiedQueueUsage() {
        return this.verifiedQueueUsage;
    }

    public long getVerifiedParentNotFoundQueueUsage() {
        return this.verifiedParentNotFoundQueueUsage;
    }

    public long getUnverifiedMaxBlockNumber() {
        return this.unverifiedMaxBlockNumber;
    }

    public long getVerifiedMaxBlockNumber() {
        return this.verifiedMaxBlockNumber;
    }

    public long getVerifiedParentNotFoundMaxBlockNumber() {
        return this.verifiedParentNotFoundMaxBlockNumber;
    }

    @Override
    public byte[] toRlp() {
        byte[] unverifiedQueueLimitBytes = Rlp.encodeLong(this.unverifiedQueueLimit);
        byte[] verifiedQueueLimitBytes = Rlp.encodeLong(this.verifiedQueueLimit);
        byte[] verifiedParentNotFoundQueueLimitBytes = Rlp.encodeLong(this.verifiedParentNotFoundQueueLimit);
        byte[] unverifiedQueueUsageBytes = Rlp.encodeLong(this.unverifiedQueueUsage);
        byte[] verifiedQueueUsageBytes = Rlp.encodeLong(this.verifiedQueueUsage);
        byte[] verifiedParentNotFoundQueueUsageBytes = Rlp.encodeLong(this.verifiedParentNotFoundQueueUsage);
        byte[] unverifiedMaxBlockNumberBytes = Rlp.encodeLong(this.unverifiedMaxBlockNumber);
        byte[] verifiedMaxBlockNumberBytes = Rlp.encodeLong(this.verifiedMaxBlockNumber);
        byte[] verifiedParentNotFoundMaxBlockNumberBytes = Rlp.encodeLong(this.verifiedParentNotFoundMaxBlockNumber);
        return Rlp.encodeList(unverifiedQueueLimitBytes, verifiedQueueLimitBytes, verifiedParentNotFoundQueueLimitBytes, unverifiedQueueUsageBytes, verifiedQueueUsageBytes, verifiedParentNotFoundQueueUsageBytes, unverifiedMaxBlockNumberBytes, verifiedMaxBlockNumberBytes, verifiedParentNotFoundMaxBlockNumberBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.unverifiedQueueLimit = ByteUtils.byteArrayToLong(((RlpElement)list.get(0)).getRlpData());
        this.verifiedQueueLimit = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
        this.verifiedParentNotFoundQueueLimit = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.unverifiedQueueUsage = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
        this.verifiedQueueUsage = ByteUtils.byteArrayToLong(((RlpElement)list.get(4)).getRlpData());
        this.verifiedParentNotFoundQueueUsage = ByteUtils.byteArrayToLong(((RlpElement)list.get(5)).getRlpData());
        this.unverifiedMaxBlockNumber = ByteUtils.byteArrayToLong(((RlpElement)list.get(6)).getRlpData());
        this.verifiedMaxBlockNumber = ByteUtils.byteArrayToLong(((RlpElement)list.get(7)).getRlpData());
        this.verifiedParentNotFoundMaxBlockNumber = ByteUtils.byteArrayToLong(((RlpElement)list.get(8)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("unverified_queue_limit", (Object)this.unverifiedQueueLimit);
        jsonObject.put("verified_queue_limit", (Object)this.verifiedQueueLimit);
        jsonObject.put("verified_parent_not_found_queue_limit", (Object)this.verifiedParentNotFoundQueueLimit);
        jsonObject.put("unverified_queue_usage", (Object)this.unverifiedQueueUsage);
        jsonObject.put("verified_queue_usage", (Object)this.verifiedQueueUsage);
        jsonObject.put("verified_parent_not_found_queue_usage", (Object)this.verifiedParentNotFoundQueueUsage);
        jsonObject.put("unverified_max_block_number", (Object)this.unverifiedMaxBlockNumber);
        jsonObject.put("verified_max_block_number", (Object)this.verifiedMaxBlockNumber);
        jsonObject.put("verified_parent_not_found_max_block_number", (Object)this.verifiedParentNotFoundMaxBlockNumber);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.unverifiedQueueLimit = jsonObject.getLong("unverified_queue_limit");
        this.verifiedQueueLimit = jsonObject.getLong("verified_queue_limit");
        this.verifiedParentNotFoundQueueLimit = jsonObject.getLong("verified_parent_not_found_queue_limit");
        this.unverifiedQueueUsage = jsonObject.getLong("unverified_queue_usage");
        this.verifiedQueueUsage = jsonObject.getLong("verified_queue_usage");
        this.verifiedParentNotFoundQueueUsage = jsonObject.getLong("verified_parent_not_found_queue_usage");
        this.unverifiedMaxBlockNumber = jsonObject.getLong("unverified_max_block_number");
        this.verifiedMaxBlockNumber = jsonObject.getLong("verified_max_block_number");
        this.verifiedParentNotFoundMaxBlockNumber = jsonObject.getLong("verified_parent_not_found_max_block_number");
    }
}

