/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.status.ContractNodeStatusEnum;
import com.alipay.mychain.sdk.domain.status.EndPoint;
import com.alipay.mychain.sdk.domain.status.NodeRoleEnum;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NodeInfo
extends MychainObject {
    private Hash nodeId;
    private List<EndPoint> endPoints = new ArrayList<EndPoint>();
    private PublicKey publicKey;
    private NodeRoleEnum nodeRoleEnum;
    private ContractNodeStatusEnum contractNodeStatusEnum;

    public static NodeInfo builder(Hash nodeId, List<EndPoint> endPoints, PublicKey publicKey, NodeRoleEnum nodeRoleEnum, ContractNodeStatusEnum contractNodeStatusEnum) {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.nodeId = nodeId;
        nodeInfo.endPoints = endPoints;
        nodeInfo.publicKey = publicKey;
        nodeInfo.nodeRoleEnum = nodeRoleEnum;
        nodeInfo.contractNodeStatusEnum = contractNodeStatusEnum;
        return nodeInfo;
    }

    public Hash getNodeId() {
        return this.nodeId;
    }

    public List<EndPoint> getEndPoints() {
        return this.endPoints;
    }

    public void setEndPoints(List<EndPoint> endPoints) {
        this.endPoints = endPoints;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public NodeRoleEnum getNodeRoleEnum() {
        return this.nodeRoleEnum;
    }

    public ContractNodeStatusEnum getContractNodeStatusEnum() {
        return this.contractNodeStatusEnum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        if (this.nodeId != null ? !this.nodeId.equals(nodeInfo.nodeId) : nodeInfo.nodeId != null) {
            return false;
        }
        if (this.endPoints != null ? !this.endPoints.equals(nodeInfo.endPoints) : nodeInfo.endPoints != null) {
            return false;
        }
        if (this.publicKey != null ? !this.publicKey.equals(nodeInfo.publicKey) : nodeInfo.publicKey != null) {
            return false;
        }
        if (this.nodeRoleEnum != nodeInfo.nodeRoleEnum) {
            return false;
        }
        return this.contractNodeStatusEnum == nodeInfo.contractNodeStatusEnum;
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.endPoints != null ? this.endPoints.hashCode() : 0);
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        result = 31 * result + (this.nodeRoleEnum != null ? this.nodeRoleEnum.hashCode() : 0);
        result = 31 * result + (this.contractNodeStatusEnum != null ? this.contractNodeStatusEnum.hashCode() : 0);
        return result;
    }

    @Override
    public byte[] toRlp() {
        byte[] nodeIdBytes = Rlp.encodeElement(this.nodeId.getValue());
        byte[] publicKeyBytes = Rlp.encodeElement(this.publicKey.getValue());
        byte[] nodeRoleBytes = Rlp.encodeInt(this.nodeRoleEnum.getCode());
        byte[] nodeStatusBytes = Rlp.encodeInt(this.contractNodeStatusEnum.getCode());
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (EndPoint item : this.endPoints) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(nodeIdBytes, publicKeyBytes, nodeRoleBytes, nodeStatusBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.nodeId = new Hash(((RlpElement)list.get(0)).getRlpData());
        this.publicKey = new PublicKey(((RlpElement)list.get(1)).getRlpData());
        this.nodeRoleEnum = NodeRoleEnum.getNodeRoleEnumByCode(ByteUtils.byteArrayToInt(((RlpElement)list.get(2)).getRlpData()));
        this.contractNodeStatusEnum = ContractNodeStatusEnum.getContractNodeStatusEnumByCode(ByteUtils.byteArrayToInt(((RlpElement)list.get(3)).getRlpData()));
        this.endPoints = new ArrayList<EndPoint>();
        RlpList data = (RlpList)list.get(4);
        for (RlpElement element : data) {
            EndPoint item = new EndPoint();
            item.fromRlp((RlpList)element);
            this.endPoints.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("node_id", (Object)ByteUtils.toHexString(this.nodeId.getValue()));
        jsonObject.put("public_key", (Object)ByteUtils.toHexString(this.publicKey.getValue()));
        jsonObject.put("node_role", (Object)this.nodeRoleEnum.getCode());
        jsonObject.put("node_state", (Object)this.contractNodeStatusEnum.getCode());
        JSONArray jsonArray = new JSONArray();
        if (this.endPoints != null) {
            for (EndPoint item : this.endPoints) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("endpoints", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.nodeId = new Hash(jsonObject.getString("node_id"));
        this.publicKey = new PublicKey(jsonObject.getString("public_key"));
        this.nodeRoleEnum = NodeRoleEnum.getNodeRoleEnumByCode(jsonObject.getIntValue("node_role"));
        this.contractNodeStatusEnum = ContractNodeStatusEnum.getContractNodeStatusEnumByCode(jsonObject.getIntValue("node_state"));
        this.endPoints = new ArrayList<EndPoint>();
        JSONArray jsonArray = jsonObject.getJSONArray("endpoints");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                EndPoint object = new EndPoint();
                object.fromJson((JSONObject)iterator.next());
                this.endPoints.add(object);
            }
        }
    }
}

