/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.status.NodeStatus;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class P2PStatus
extends MychainObject {
    private long totalNodeCount;
    private long totalConsensusNodeCount;
    private long totalNonConsensusNodeCount;
    private long totalConnectedConsensusNodeCount;
    private long totalConnectedNonConsensusNodeCount;
    private List<NodeStatus> nodeStatuses;

    public static P2PStatus builder(long totalNodeCount, long totalConsensusNodeCount, long totalNonConsensusNodeCount, long totalConnectedConsensusNodeCount, long totalConnectedNonConsensusNodeCount, List<NodeStatus> nodeStatuses) {
        P2PStatus p2PStatus = new P2PStatus();
        p2PStatus.totalNodeCount = totalNodeCount;
        p2PStatus.totalConsensusNodeCount = totalConsensusNodeCount;
        p2PStatus.totalNonConsensusNodeCount = totalNonConsensusNodeCount;
        p2PStatus.totalConnectedConsensusNodeCount = totalConnectedConsensusNodeCount;
        p2PStatus.totalConnectedNonConsensusNodeCount = totalConnectedNonConsensusNodeCount;
        p2PStatus.nodeStatuses = nodeStatuses;
        return p2PStatus;
    }

    public long getTotalNonConsensusNodeCount() {
        return this.totalNonConsensusNodeCount;
    }

    public long getTotalConnectedConsensusNodeCount() {
        return this.totalConnectedConsensusNodeCount;
    }

    public long getTotalConnectedNonConsensusNodeCount() {
        return this.totalConnectedNonConsensusNodeCount;
    }

    public long getTotalNodeCount() {
        return this.totalNodeCount;
    }

    public long getTotalConsensusNodeCount() {
        return this.totalConsensusNodeCount;
    }

    public List<NodeStatus> getNodeStatuses() {
        return this.nodeStatuses;
    }

    @Override
    public byte[] toRlp() {
        byte[] totalNodeCountBytes = Rlp.encodeLong(this.totalNodeCount);
        byte[] totalConsensusNodeCountBytes = Rlp.encodeLong(this.totalConsensusNodeCount);
        byte[] totalNonConsensusNodeCountBytes = Rlp.encodeLong(this.totalNonConsensusNodeCount);
        byte[] totalConnectedConsensusNodeCountBytes = Rlp.encodeLong(this.totalConnectedConsensusNodeCount);
        byte[] totalConnectedNonConsensusNodeCountBytes = Rlp.encodeLong(this.totalConnectedNonConsensusNodeCount);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (NodeStatus item : this.nodeStatuses) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(totalNodeCountBytes, totalConsensusNodeCountBytes, totalNonConsensusNodeCountBytes, totalConnectedConsensusNodeCountBytes, totalConnectedNonConsensusNodeCountBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.totalNodeCount = ByteUtils.byteArrayToLong(((RlpElement)list.get(0)).getRlpData());
        this.totalConsensusNodeCount = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
        this.totalNonConsensusNodeCount = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.totalConnectedConsensusNodeCount = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
        this.totalConnectedNonConsensusNodeCount = ByteUtils.byteArrayToLong(((RlpElement)list.get(4)).getRlpData());
        this.nodeStatuses = new ArrayList<NodeStatus>();
        RlpList data = (RlpList)list.get(5);
        for (RlpElement element : data) {
            NodeStatus item = new NodeStatus();
            item.fromRlp((RlpList)element);
            this.nodeStatuses.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("total_node_count", (Object)this.totalNodeCount);
        jsonObject.put("total_consensus_node_count", (Object)this.totalConsensusNodeCount);
        jsonObject.put("total_non_consensus_node_count", (Object)this.totalNonConsensusNodeCount);
        jsonObject.put("total_connected_consensus_node_count", (Object)this.totalConnectedConsensusNodeCount);
        jsonObject.put("total_connected_non_consensus_node_count", (Object)this.totalConnectedNonConsensusNodeCount);
        JSONArray jsonArray = new JSONArray();
        if (this.nodeStatuses != null) {
            for (NodeStatus item : this.nodeStatuses) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("node_status", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.totalNodeCount = jsonObject.getLong("total_node_count");
        this.totalConsensusNodeCount = jsonObject.getLong("total_consensus_node_count");
        this.totalNonConsensusNodeCount = jsonObject.getLong("total_non_consensus_node_count");
        this.totalConnectedConsensusNodeCount = jsonObject.getLong("total_connected_consensus_node_count");
        this.totalConnectedNonConsensusNodeCount = jsonObject.getLong("total_connected_non_consensus_node_count");
        this.nodeStatuses = new ArrayList<NodeStatus>();
        JSONArray jsonArray = jsonObject.getJSONArray("node_status");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                NodeStatus object = new NodeStatus();
                object.fromJson((JSONObject)iterator.next());
                this.nodeStatuses.add(object);
            }
        }
    }
}

