/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.errorcode.IErrorCode;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class Response
extends Message {
    BaseFixedSizeByteArray.Fixed20ByteArray groupId = BaseFixedSizeByteArray.Fixed20ByteArray.defaultValue();
    private long sequenceId;
    private IErrorCode errorCode = ErrorCode.SUCCESS;
    private String exceptionMessage;

    public Response(MessageType messageType) {
        super(messageType);
    }

    public BaseFixedSizeByteArray.Fixed20ByteArray getGroupId() {
        return this.groupId;
    }

    public void setGroupId(BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        this.groupId = groupId;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public IErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(IErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public boolean isSuccess() {
        return this.getErrorCode().isSuccess();
    }

    @Override
    public byte[] toRlp() {
        byte[] sequenceIdBytes = Rlp.encodeInt((int)this.sequenceId);
        byte[] errorCodeBytes = Rlp.encodeInt(this.errorCode.getErrorCode());
        byte[] groupIdBytes = Rlp.encodeElement(this.groupId.getData());
        return Rlp.encodeList(super.toRlp(), sequenceIdBytes, errorCodeBytes, groupIdBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.sequenceId = ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData());
        this.errorCode = ErrorCode.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(2)).getRlpData()));
        if (list.size() > 3) {
            this.groupId = BaseFixedSizeByteArray.Fixed20ByteArray.valueOf(((RlpElement)list.get(3)).getRlpData());
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        if (this.sequenceId != 0L) {
            jsonObject.put("sequence", (Object)this.sequenceId);
        }
        if (this.groupId != null && !ByteUtils.toHexString(this.groupId.getData()).equalsIgnoreCase(ByteUtils.toHexString(BaseFixedSizeByteArray.Fixed20ByteArray.defaultValue().getData()))) {
            jsonObject.put("group_id", (Object)ByteUtils.toHexString(this.groupId.getData()));
        }
        jsonObject.put("return_code", (Object)this.errorCode.getErrorCode());
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        if (jsonObject.containsKey((Object)"sequence")) {
            this.sequenceId = jsonObject.getLong("sequence");
        }
        if (jsonObject.containsKey((Object)"group_id")) {
            this.groupId = BaseFixedSizeByteArray.Fixed20ByteArray.valueOf(jsonObject.getString("group_id"));
        }
        this.errorCode = ErrorCode.valueOf(jsonObject.getInteger("return_code"));
    }
}

