/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class FetchEventRequest
extends Request {
    private BigInteger eventId;

    public FetchEventRequest(BigInteger eventId) {
        super(MessageType.MSG_TYPE_EVENT_REQ_FETCH);
        this.eventId = eventId;
    }

    public FetchEventRequest() {
        super(MessageType.MSG_TYPE_EVENT_REQ_FETCH);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.eventId != null && this.eventId.compareTo(BigInteger.ZERO) > 0;
    }

    public BigInteger getEventId() {
        return this.eventId;
    }

    public void setEventId(BigInteger eventId) {
        this.eventId = eventId;
    }

    @Override
    public byte[] toRlp() {
        byte[] eventIdBytes = Rlp.encodeBigInteger(this.eventId);
        return Rlp.encodeList(super.toRlp(), eventIdBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.eventId = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("filter_id", (Object)this.eventId);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.eventId = jsonObject.getBigInteger("filter_id");
    }
}

