/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.event.EventModelType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListenTopicsEventRequest
extends Request {
    private List<String> topics;
    private EventModelType type = EventModelType.PULL;

    public ListenTopicsEventRequest(List<String> topics, EventModelType type) {
        super(MessageType.MSG_TYPE_EVENT_REQ_TOPICS);
        this.topics = topics;
        this.type = type;
    }

    public ListenTopicsEventRequest() {
        super(MessageType.MSG_TYPE_EVENT_REQ_TOPICS);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.topics != null && this.topics.size() > 0 && this.type != null && (this.type.equals((Object)EventModelType.PULL) || this.type.equals((Object)EventModelType.PUSH));
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.MSG_TYPE_EVENT_REQ_TOPICS;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public EventModelType getType() {
        return this.type;
    }

    public void setType(EventModelType type) {
        this.type = type;
    }

    @Override
    public byte[] toRlp() {
        byte[] typeBytes = Rlp.encodeInt(this.type.getCode());
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (String item : this.topics) {
            data.add(Rlp.encodeString(item));
        }
        return Rlp.encodeList(super.toRlp(), typeBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.type = EventModelType.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
        this.topics = new ArrayList<String>();
        RlpList data = (RlpList)list.get(2);
        for (RlpElement element : data) {
            this.topics.add(ByteUtils.byteArrayToString(element.getRlpData()));
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("event_type", (Object)this.type.getCode());
        JSONArray jsonArray = new JSONArray();
        if (this.topics != null) {
            for (String item : this.topics) {
                jsonArray.add((Object)item);
            }
        }
        jsonObject.put("topics", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.type = EventModelType.valueOf(jsonObject.getIntValue("event_type"));
        this.topics = new ArrayList<String>();
        JSONArray jsonArray = jsonObject.getJSONArray("topics");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                this.topics.add((String)iterator.next());
            }
        }
    }
}

