/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PushAccountEvent
extends Message {
    private List<Account> accounts;
    private BigInteger id;

    public PushAccountEvent(BigInteger id, List<Account> accounts) {
        super(MessageType.MSG_TYPE_EVENT_PUSH_ACCOUNT);
        this.id = id;
        this.accounts = accounts;
    }

    public PushAccountEvent() {
        super(MessageType.MSG_TYPE_EVENT_PUSH_ACCOUNT);
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    @Override
    public byte[] toRlp() {
        byte[] idBytes = Rlp.encodeBigInteger(this.id);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (Account item : this.accounts) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(super.toRlp(), idBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.id = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.accounts = new ArrayList<Account>();
        RlpList data = (RlpList)list.get(2);
        for (RlpElement element : data) {
            Account item = new Account();
            item.fromRlp((RlpList)element);
            this.accounts.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("filter_id", (Object)this.id);
        JSONArray jsonArray = new JSONArray();
        if (this.accounts != null) {
            for (Account item : this.accounts) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("accounts", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.id = jsonObject.getBigInteger("filter_id");
        this.accounts = new ArrayList<Account>();
        JSONArray jsonArray = jsonObject.getJSONArray("accounts");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                Account object = new Account();
                object.fromJson((JSONObject)iterator.next());
                this.accounts.add(object);
            }
        }
    }
}

