/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryContractRequest
extends Request {
    private Identity id;

    public QueryContractRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_CONTRACT);
    }

    public QueryContractRequest(Identity id) {
        super(MessageType.MSG_TYPE_QUERY_REQ_CONTRACT);
        this.id = id;
    }

    public Identity getId() {
        return this.id;
    }

    public void setId(Identity id) {
        this.id = id;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.id != null && !this.id.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue());
    }

    @Override
    public byte[] toRlp() {
        byte[] identityBytes = Rlp.encodeElement(this.id.getValue());
        return Rlp.encodeList(super.toRlp(), identityBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.id = new Identity(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("id", (Object)ByteUtils.toHexString(this.id.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.id = new Identity(jsonObject.getString("id"));
    }
}

