/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.spv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransactionProof
extends MychainObject {
    private int index;
    private int size;
    private BigInteger blockNum;
    private Hash txRoot;
    private List<Hash> branches;

    public TransactionProof(BigInteger blockNumber, int index, int size, Hash txRoot, List<Hash> branches) {
        this.blockNum = blockNumber;
        this.index = index;
        this.size = size;
        this.txRoot = txRoot;
        this.branches = branches;
    }

    public TransactionProof() {
    }

    public Hash getTxRoot() {
        return this.txRoot;
    }

    public void setTxRoot(Hash txRoot) {
        this.txRoot = txRoot;
    }

    public BigInteger getBlockNum() {
        return this.blockNum;
    }

    public void setBlockNum(BigInteger blockNum) {
        this.blockNum = blockNum;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<Hash> getBranches() {
        return this.branches;
    }

    public void setBranches(List<Hash> branches) {
        this.branches = branches;
    }

    @Override
    public byte[] toRlp() {
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNum);
        byte[] receiptRootBytes = Rlp.encodeElement(this.txRoot.getValue());
        byte[] indexBytes = Rlp.encodeInt(this.index);
        byte[] sizeBytes = Rlp.encodeInt(this.size);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        if (this.branches != null) {
            for (Hash item : this.branches) {
                data.add(Rlp.encodeElement(item.getValue()));
            }
        }
        return Rlp.encodeList(blockNumberBytes, receiptRootBytes, indexBytes, sizeBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.blockNum = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(0)).getRlpData());
        this.txRoot = new Hash(((RlpElement)list.get(1)).getRlpData());
        this.index = ByteUtils.byteArrayToInt(((RlpElement)list.get(2)).getRlpData());
        this.size = ByteUtils.byteArrayToInt(((RlpElement)list.get(3)).getRlpData());
        this.branches = new ArrayList<Hash>();
        RlpList data = (RlpList)list.get(4);
        for (RlpElement element : data) {
            this.branches.add(new Hash(element.getRlpData()));
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("block_number", (Object)this.blockNum);
        jsonObject.put("root", (Object)ByteUtils.toHexString(this.txRoot.getValue()));
        jsonObject.put("index", (Object)this.index);
        jsonObject.put("size", (Object)this.size);
        JSONArray jsonArray = new JSONArray();
        if (this.branches != null) {
            for (Hash item : this.branches) {
                jsonArray.add((Object)ByteUtils.toHexString(item.getValue()));
            }
        }
        jsonObject.put("branch", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.blockNum = jsonObject.getBigInteger("block_number");
        this.txRoot = new Hash(jsonObject.getString("root"));
        this.index = jsonObject.getIntValue("index");
        this.size = jsonObject.getIntValue("size");
        this.branches = new ArrayList<Hash>();
        JSONArray jsonArray = jsonObject.getJSONArray("branch");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                this.branches.add(new Hash((String)iterator.next()));
            }
        }
    }
}

