/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class UpdateBlackListRequest
extends Request {
    private List<Identity> blackList;
    private byte[] signature;

    public UpdateBlackListRequest() {
        super(MessageType.MSG_TYPE_ADMIN_REQ_UPDATE_BLACK_LIST);
    }

    public UpdateBlackListRequest(List<Identity> blackList) {
        super(MessageType.MSG_TYPE_ADMIN_REQ_UPDATE_BLACK_LIST);
        this.blackList = blackList;
    }

    public List<Identity> getBlackList() {
        return this.blackList;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean sign(SignerBase signer) {
        try {
            this.signature = signer.sign(this.hash().getValue());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Hash hash() {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (Identity item : this.blackList) {
            data.add(Rlp.encodeElement(item.getValue()));
        }
        byte[] bytes = Rlp.encodeList(data);
        return new Hash(HashFactory.getHash(HashTypeEnum.SHA256).hash(bytes));
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.blackList != null) {
            for (Identity identity : this.blackList) {
                if (!identity.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue())) continue;
                return false;
            }
        } else {
            return false;
        }
        return ArrayUtils.isNotEmpty((byte[])this.signature);
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (Identity item : this.blackList) {
            data.add(Rlp.encodeElement(item.getValue()));
        }
        byte[] signatureBytes = Rlp.encodeElement(this.signature);
        return Rlp.encodeList(super.toRlp(), Rlp.encodeList(data), signatureBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.blackList = new ArrayList<Identity>();
        RlpList data = (RlpList)list.get(1);
        for (RlpElement element : data) {
            Identity item = new Identity(element.getRlpData());
            this.blackList.add(item);
        }
        this.signature = ((RlpElement)list.get(2)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONArray jsonArray = new JSONArray();
        if (this.blackList != null) {
            for (Identity item : this.blackList) {
                jsonArray.add((Object)ByteUtils.toHexString(item.getValue()));
            }
        }
        jsonObject.put("black_list", (Object)jsonArray);
        jsonObject.put("signature", (Object)ByteUtils.toHexString(this.signature));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.blackList = new ArrayList<Identity>();
        JSONArray jsonArray = jsonObject.getJSONArray("black_list");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                Identity object = new Identity((String)iterator.next());
                this.blackList.add(object);
            }
        }
        this.signature = ByteUtils.hexStringToBytes(jsonObject.getString("signature"));
    }
}

