/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.block.BlockHeader;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PushBlockEvent
extends Message {
    private List<BlockHeader> blockHeaders;
    private BigInteger id;

    public PushBlockEvent(BigInteger id, List<BlockHeader> blockHeaders) {
        super(MessageType.MSG_TYPE_EVENT_PUSH_BLOCK);
        this.id = id;
        this.blockHeaders = blockHeaders;
    }

    public PushBlockEvent() {
        super(MessageType.MSG_TYPE_EVENT_PUSH_BLOCK);
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public List<BlockHeader> getBlockHeaders() {
        return this.blockHeaders;
    }

    public void setBlockHeaders(List<BlockHeader> blockHeaders) {
        this.blockHeaders = blockHeaders;
    }

    @Override
    public byte[] toRlp() {
        byte[] idBytes = Rlp.encodeBigInteger(this.id);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (BlockHeader item : this.blockHeaders) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(super.toRlp(), idBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.id = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.blockHeaders = new ArrayList<BlockHeader>();
        RlpList data = (RlpList)list.get(2);
        for (RlpElement element : data) {
            BlockHeader item = new BlockHeader();
            item.fromRlp((RlpList)element);
            this.blockHeaders.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("filter_id", (Object)this.id);
        JSONArray jsonArray = new JSONArray();
        if (this.blockHeaders != null) {
            for (BlockHeader item : this.blockHeaders) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("headers", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.id = jsonObject.getBigInteger("filter_id");
        this.blockHeaders = new ArrayList<BlockHeader>();
        JSONArray jsonArray = jsonObject.getJSONArray("headers");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                BlockHeader object = new BlockHeader();
                object.fromJson((JSONObject)iterator.next());
                this.blockHeaders.add(object);
            }
        }
    }
}

