/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.event.EventTopicResult;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PushTopicsEvent
extends Message {
    private List<EventTopicResult> results;
    private BigInteger id;

    public PushTopicsEvent(BigInteger id, List<EventTopicResult> results) {
        super(MessageType.MSG_TYPE_EVENT_PUSH_TOPICS);
        this.id = id;
        this.results = results;
    }

    public PushTopicsEvent() {
        super(MessageType.MSG_TYPE_EVENT_PUSH_TOPICS);
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public List<EventTopicResult> getResults() {
        return this.results;
    }

    public void setResults(List<EventTopicResult> results) {
        this.results = results;
    }

    @Override
    public byte[] toRlp() {
        byte[] idBytes = Rlp.encodeBigInteger(this.id);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (EventTopicResult item : this.results) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(super.toRlp(), idBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.id = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.results = new ArrayList<EventTopicResult>();
        RlpList data = (RlpList)list.get(2);
        for (RlpElement element : data) {
            EventTopicResult item = new EventTopicResult();
            item.fromRlp((RlpList)element);
            this.results.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("filter_id", (Object)this.id);
        JSONArray jsonArray = new JSONArray();
        if (this.results != null) {
            for (EventTopicResult item : this.results) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("results", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.id = jsonObject.getBigInteger("filter_id");
        this.results = new ArrayList<EventTopicResult>();
        JSONArray jsonArray = jsonObject.getJSONArray("results");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                EventTopicResult object = new EventTopicResult();
                object.fromJson((JSONObject)iterator.next());
                this.results.add(object);
            }
        }
    }
}

