/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network;

import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.MessageFactory;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.network.MessageProcessor;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;

public class MsgTimeoutTask
extends AbstractTask {
    private MessageProcessor processor;
    private Request request;
    private Hash hash;
    private INetwork network;

    public MsgTimeoutTask(MessageProcessor processor, Request request, Hash hash, INetwork network, ILogger logger, Integer timeout) {
        super(timeout, TaskType.ONCE, logger);
        this.processor = processor;
        this.request = request;
        this.hash = hash;
        this.network = network;
    }

    @Override
    public void run() {
        if (this.processor == null || this.request == null || this.network == null) {
            return;
        }
        Response response = (Response)MessageFactory.getResponse(this.request, ErrorCode.SDK_TIMED_OUT);
        if (response == null) {
            return;
        }
        this.processor.pushTimeoutMessage(this.request.getSequenceId(), response);
    }
}

