/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractNumericType;
import java.math.BigInteger;

public abstract class AbstractIntType
extends AbstractNumericType {
    public AbstractIntType(String typePrefix, int bitSize, BigInteger value) {
        super(typePrefix + bitSize, value, bitSize);
        if (!this.valid(bitSize, value)) {
            throw new UnsupportedOperationException("Bitsize must be 8 bit aligned, and in range 0 < bitSize <= 256");
        }
    }

    static boolean isValidBitSize(int bitSize) {
        return bitSize % 8 == 0 && bitSize > 0 && bitSize <= 256;
    }

    private static boolean isValidBitCount(int bitSize, BigInteger value) {
        return value.bitLength() <= bitSize;
    }

    boolean valid(int bitSize, BigInteger value) {
        return AbstractIntType.isValidBitSize(bitSize) && AbstractIntType.isValidBitCount(bitSize, value);
    }
}

