/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.annotation.privacy;

import com.alipay.mychain.zoro.annotation.ApplyEnvelope;
import com.alipay.mychain.zoro.annotation.CommitmentRelation;
import com.alipay.mychain.zoro.annotation.ProofList;
import com.alipay.mychain.zoro.annotation.privacy.Node;
import com.alipay.mychain.zoro.annotation.privacy.ZoroType;
import com.alipay.mychain.zoro.crypto.BulletProof;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.envelop.EnvelopeEnc;
import com.alipay.mychain.zoro.exception.ZoroException;
import com.alipay.mychain.zoro.util.Base64Codec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationHandlers {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationHandlers.class);

    public static void commitmentRelationHandler(Node node, CommitmentRelation annotation) {
        String annotationBlindFactor = annotation.blindFactor();
        String annotationChange = annotation.change();
        if ("".equals(annotationBlindFactor) && "".equals(annotationChange)) {
            byte[] amountBlindFactor;
            try {
                amountBlindFactor = BulletProof.generateBlindFactor();
            }
            catch (CryptoException e) {
                logger.error("Blind Factor Genenration Error", (Throwable)e);
                throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_GENERATION_FAILED, e.getMessage());
            }
            HashMap tempMap = (HashMap)node.getData();
            Node tempNode = (Node)tempMap.get(annotation.amount());
            AnnotationHandlers.longToNote(tempNode, amountBlindFactor);
            tempMap.put(annotation.amount(), tempNode);
            node.setData(tempMap);
        } else {
            byte[] changeBlindFactor;
            byte[] amountBlindFactor;
            HashMap originalNodeHashMap = (HashMap)node.getData();
            Node blindFactorNode = (Node)originalNodeHashMap.get(annotation.blindFactor());
            Node amountNode = (Node)originalNodeHashMap.get(annotation.amount());
            Node changeNode = (Node)originalNodeHashMap.get(annotation.change());
            byte[] blindFactor = Base64Codec.decode((String)blindFactorNode.getData());
            try {
                amountBlindFactor = BulletProof.generateBlindFactor();
            }
            catch (CryptoException e) {
                logger.error("Blind Factor Genenration Error", (Throwable)e);
                throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_GENERATION_FAILED, e.getMessage());
            }
            ArrayList<byte[]> posBlindFactor = new ArrayList<byte[]>();
            posBlindFactor.add(blindFactor);
            ArrayList<byte[]> negBlindFactor = new ArrayList<byte[]>();
            negBlindFactor.add(amountBlindFactor);
            try {
                changeBlindFactor = BulletProof.addBlindFactors(posBlindFactor, negBlindFactor);
            }
            catch (CryptoException e) {
                logger.error("Blind Factor Subtraction Exception", (Throwable)e);
                throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_SUBTRACTION_FAILED, e.getMessage());
            }
            AnnotationHandlers.longToNote(amountNode, amountBlindFactor);
            AnnotationHandlers.longToNote(changeNode, changeBlindFactor);
            originalNodeHashMap.put(annotation.amount(), amountNode);
            originalNodeHashMap.put(annotation.change(), changeNode);
            node.setData(originalNodeHashMap);
        }
    }

    public static void proofListHandler(Node node, ProofList annotation) {
        byte[] proof;
        ArrayList<byte[]> blindList = new ArrayList<byte[]>();
        long[] valueArray = new long[annotation.commitment().length];
        HashMap originalHashMap = (HashMap)node.getData();
        for (int i = 0; i < annotation.commitment().length; ++i) {
            Node tempNode = (Node)originalHashMap.get(annotation.commitment()[i]);
            HashMap insiderMap = (HashMap)tempNode.getData();
            long valueData = (Long)((Node)insiderMap.get("value")).getData();
            String blindFactorData = (String)((Node)insiderMap.get("blindFactor")).getData();
            blindList.add(Base64Codec.decode(blindFactorData));
            valueArray[i] = valueData;
        }
        try {
            proof = BulletProof.generateProof(blindList, valueArray);
        }
        catch (CryptoException e) {
            logger.error("Generate RangeProof Failed", (Throwable)e);
            throw new ZoroException(ZoroErrorCodeEnum.PROOF_GENERATION_FAILED, e.getMessage());
        }
        String proofString = Base64Codec.encode(proof);
        String prefixName = node.getConcreteName() + "_";
        Node proofNode = new Node(prefixName + "proof", null, null, (Type)((Object)String.class), proofString, true);
        originalHashMap.put(annotation.location(), proofNode);
        node.setData(originalHashMap);
    }

    public static HashMap<String, HashMap<String, byte[]>> applyEnvelopePhaseOneHandler(Node node, ApplyEnvelope annotation, HashMap<String, HashMap<String, byte[]>> cacheHashMap) {
        byte[] element;
        if (node.getData() == null) {
            logger.error("Message To Be Encrypted Is Null");
            throw new ZoroException(ZoroErrorCodeEnum.NULL_ENVELOPE_MESSAGE_CONTENT, "Message To Be Encrypted Is Null");
        }
        if (node.getData().getClass().equals(ZoroType.STRING)) {
            element = ((String)node.getData()).getBytes(StandardCharsets.UTF_8);
        } else if (node.getData().getClass().equals(Long.class)) {
            element = (node.getData() + "").getBytes(StandardCharsets.UTF_8);
        } else if (node.getData().getClass().equals(Integer.TYPE)) {
            element = (node.getData() + "").getBytes(StandardCharsets.UTF_8);
        } else {
            throw new ZoroException(ZoroErrorCodeEnum.INCORRECT_ENVELOPE_MESSAGE_TYPE, "Wrong Message Type To Be Encrypted");
        }
        if (cacheHashMap.containsKey(annotation.value())) {
            HashMap<String, byte[]> tempMap = cacheHashMap.get(annotation.value());
            tempMap.put(node.getConcreteName(), element);
            cacheHashMap.put(annotation.value(), tempMap);
        } else {
            HashMap<String, byte[]> newMap = new HashMap<String, byte[]>(16);
            newMap.put(node.getConcreteName(), element);
            cacheHashMap.put(annotation.value(), newMap);
        }
        return cacheHashMap;
    }

    public static void applyEnvelopePhaseTwoHandler(Node rootNode, HashMap<String, HashMap<String, byte[]>> cacheHashMap) {
        for (String key : cacheHashMap.keySet()) {
            AbstractMap.SimpleEntry<Vector<byte[]>, Map<RSAPublicKey, byte[]>> cipherPair;
            Object keyToPubKey2;
            HashMap<String, byte[]> tempMsgMap = cacheHashMap.get(key);
            HashMap nodeHashMap = (HashMap)rootNode.getData();
            if (!nodeHashMap.containsKey(key)) {
                logger.error("Cannot Find Field Key In Class");
                throw new ZoroException(ZoroErrorCodeEnum.ANNOTATION_MAPPER_ATTRIBUTE_NOT_EXIST, "Cannot Find Field Key In Class");
            }
            HashMap keyHashMap = (HashMap)((Node)nodeHashMap.get(key)).getData();
            Vector<RSAPublicKey> rsaPublicKeys = new Vector<RSAPublicKey>();
            for (Object keyToPubKey2 : keyHashMap.keySet()) {
                rsaPublicKeys.add((RSAPublicKey)keyHashMap.get(keyToPubKey2));
            }
            Vector<byte[]> msgVector = new Vector<byte[]>();
            keyToPubKey2 = cacheHashMap.get(key).keySet().iterator();
            while (keyToPubKey2.hasNext()) {
                String keyToMsg = (String)keyToPubKey2.next();
                msgVector.add(tempMsgMap.get(keyToMsg));
            }
            try {
                cipherPair = EnvelopeEnc.encrypt(msgVector, rsaPublicKeys);
            }
            catch (CryptoException e) {
                logger.error("Envelope Encryption Error", (Throwable)e);
                throw new ZoroException(ZoroErrorCodeEnum.ENVELOPE_ENCRYPT_FAILED, e.getMessage());
            }
            HashMap<String, String> tempFieldStringMap = new HashMap<String, String>(16);
            if (tempMsgMap.keySet().size() == cipherPair.getKey().size()) {
                Iterator<byte[]> iterCipher = cipherPair.getKey().iterator();
                for (String fieldAssignKey : tempMsgMap.keySet()) {
                    tempFieldStringMap.put(fieldAssignKey, Base64Codec.encode(iterCipher.next()));
                }
            } else {
                logger.error("Envelope Encryption Error: message list and cipher list length not equal");
                throw new ZoroException(ZoroErrorCodeEnum.UNKNOWN_CRYPTO_EXCEPTION, "message list and cipher list length not equal");
            }
            HashMap<String, String> tempKeyStringMap = new HashMap<String, String>(16);
            if (cipherPair.getValue().keySet().size() == keyHashMap.keySet().size()) {
                for (String keyAssignKey : keyHashMap.keySet()) {
                    tempKeyStringMap.put(keyAssignKey, Base64Codec.encode(cipherPair.getValue().get(keyHashMap.get(keyAssignKey))));
                }
            } else {
                logger.error("Envelope Encryption Error: envelope and keyMap length not equal");
                throw new ZoroException(ZoroErrorCodeEnum.UNKNOWN_CRYPTO_EXCEPTION, "envelope and keyMap length not equal");
            }
            Node tempNode = (Node)nodeHashMap.get(key);
            tempNode.setData(tempKeyStringMap);
            nodeHashMap.put(key, tempNode);
            AnnotationHandlers.writePlaintextsToTree(nodeHashMap, tempFieldStringMap);
            rootNode.setData(nodeHashMap);
        }
    }

    private static void writePlaintextsToTree(Map<String, Node> root, Map<String, String> attrToValue) {
        for (String key : root.keySet()) {
            Node tempNode;
            if (root.get(key).isLeaf()) {
                if (!attrToValue.containsKey(root.get(key).getConcreteName())) continue;
                tempNode = root.get(key);
                tempNode.setData(attrToValue.get(root.get(key).getConcreteName()));
                root.put(key, tempNode);
                continue;
            }
            if (root.get(key).getType() == Map.class) {
                tempNode = root.get(key);
                HashMap tempHash = (HashMap)root.get(key).getData();
                AnnotationHandlers.writePlaintextsToTree(tempHash, attrToValue);
                tempNode.setData(tempHash);
                root.put(key, tempNode);
                continue;
            }
            if (root.get(key).getType() != List.class) continue;
            Node tempRootNode = root.get(key);
            ArrayList<Node> tempNodeList = new ArrayList<Node>();
            ArrayList nodeList = (ArrayList)root.get(key).getData();
            for (Node node : nodeList) {
                HashMap tempHash = (HashMap)node.getData();
                AnnotationHandlers.writePlaintextsToTree(tempHash, attrToValue);
                node.setData(tempHash);
                tempNodeList.add(node);
            }
            tempRootNode.setData(tempNodeList);
            root.put(key, tempRootNode);
        }
    }

    private static Node longToNote(Node node, byte[] r) {
        Annotation[] annotations;
        byte[] pedersenCommitment = null;
        try {
            pedersenCommitment = BulletProof.generateCommit(r, (Long)node.getData());
        }
        catch (CryptoException ex) {
            logger.error("Failed to generate pedersen commitment: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_GENERATION_FAILED, ex.getMessage());
        }
        String base64PedersenCommitment = Base64Codec.encode(pedersenCommitment);
        String base64BlindFactor = Base64Codec.encode(r);
        Annotation envelop = null;
        for (Annotation elementOfArray : annotations = node.getFieldAnnotations()) {
            if (!(elementOfArray instanceof ApplyEnvelope)) continue;
            envelop = elementOfArray;
            break;
        }
        String prefixName = node.getConcreteName() + "_";
        Node pedersenCommitmentNode = new Node(prefixName + "pedersenCommitment", null, null, (Type)((Object)String.class), base64PedersenCommitment, true);
        Node encryptedBlindFactorNode = new Node(prefixName + "encryptedBlindFactor", new Annotation[]{envelop}, null, (Type)((Object)String.class), base64BlindFactor, true);
        Node encryptedValueNode = new Node(prefixName + "encryptedValue", new Annotation[]{envelop}, null, (Type)((Object)String.class), String.valueOf((Long)node.getData()), true);
        Node blindFactorNode = new Node(prefixName + "blindFactor", null, null, (Type)((Object)String.class), base64BlindFactor, true);
        Node valueNode = new Node(prefixName + "value", null, null, Long.TYPE, node.getData(), true);
        HashMap<String, Node> noteMap = new HashMap<String, Node>(16);
        noteMap.put("pedersenCommitment", pedersenCommitmentNode);
        noteMap.put("encryptedBlindFactor", encryptedBlindFactorNode);
        noteMap.put("encryptedValue", encryptedValueNode);
        noteMap.put("value", valueNode);
        noteMap.put("blindFactor", blindFactorNode);
        node.setConcreteName(prefixName);
        node.setFieldAnnotations(null);
        node.setType(ZoroType.MAP);
        node.setData(noteMap);
        node.setLeaf(false);
        return node;
    }
}

