/*
 * Decompiled with CFR 0.152.
 */
package com.pow.api.cls;

import android.devkit.api.Misc;
import android.util.Log;
import android_serialport_api.SerialPort;
import cn.trinea.android.common.util.ShellUtils;
import com.hitown.hitownsdk.HitownAC3508Control;
import com.lsc.gpio.Scan;
import com.power.control.DeviceControl;
import com.rscja.deviceapi.Module;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.zhsim.pow.ZhPower;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import rfid.lib.client.Power;

public class RfidPower {
    private static final String TAG = "MYINFO";
    PDATYPE ptype;
    private Module module;
    public static List<String> commnandList = new ArrayList<String>();
    private Scan scan = null;
    private DeviceControl DevCtrl;
    private final String dc_power = "dc_power";
    private final String en = "en";
    private final String comstr = "com";
    private final String RootPath = "/sys/devices/platform/uhf/";
    private com.BRMicro.SerialPort mSerialport;
    private com.device.serialport.SerialPort idatasp;
    private SerialPort sp;
    private ZhPower zp;
    private int Fd;

    private synchronized boolean writeFile(String name, int status) {
        try {
            File file = new File("/sys/devices/platform/uhf/" + name);
            if (file.exists()) {
                FileOutputStream out = new FileOutputStream(file);
                ((OutputStream)out).write(String.valueOf(status).getBytes());
                out.flush();
                ((OutputStream)out).close();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private boolean power_up() {
        return this.writeFile("dc_power", 1) && this.writeFile("com", 1) && this.writeFile("en", 1);
    }

    private boolean power_down() {
        return this.writeFile("en", 0) && this.writeFile("com", 0) && this.writeFile("dc_power", 0);
    }

    private void sleepThread(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean doSomethingInit() {
        try {
            HitownAC3508Control.getInstance().init();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public RfidPower(PDATYPE py) {
        this.ptype = py;
    }

    public PDATYPE GetType() {
        return this.ptype;
    }

    public boolean PowerUp() {
        Log.d((String)TAG, (String)this.ptype.toString());
        switch (this.ptype) {
            case CHAINWAY: {
                try {
                    this.module = Module.getInstance();
                    this.module.powerOn(3);
                    return this.module.uartSwitch(3);
                }
                catch (ConfigurationException ce) {
                    return false;
                }
            }
            case COMMANDLIST: {
                commnandList.add("echo 1 >/sys/devices/platform/gpio_test/uart1power");
                ShellUtils.CommandResult result = ShellUtils.execCommand(commnandList, (boolean)true);
                return result.result == 0;
            }
            case SCAN_ALPS_ANDROID_CUIUS2: {
                int re;
                if (this.scan == null) {
                    try {
                        this.scan = new Scan();
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                return (re = this.scan.ctrl(1)) == 0;
            }
            case ALPS_KT45: {
                try {
                    this.DevCtrl = new DeviceControl("/sys/class/misc/mtgpio/pin");
                    this.DevCtrl.PowerOnDevice();
                }
                catch (SecurityException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
            case HD508: {
                this.sleepThread(200L);
                boolean bl = this.doSomethingInit();
                this.sleepThread(200L);
                return bl;
            }
            case IDATA: {
                int re2 = com.device.serialport.SerialPort.ioctlFromJNI(3);
                return re2 == 0;
            }
            case JIEBAO: {
                boolean bl = this.power_up();
                return bl;
            }
            case EKEMP: {
                Misc.uhfEnable(true);
                try {
                    Thread.sleep(400L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            case SCAN_ALPS_ANDROID_CUIUS2_TEST: {
                return false;
            }
            case SENTER_ST308W: {
                Power.on();
                return true;
            }
            case SENTER_ST907: {
                Power.on_ST907_4P2v();
                return true;
            }
            case SCAN_ALPS_ANDROID_CUIUS2_NEBOARD: {
                int re;
                if (this.scan == null) {
                    try {
                        this.scan = new Scan();
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                if ((re = this.scan.ctrl(19)) != 0) {
                    return false;
                }
                re = this.scan.ctrl(3);
                if (re != 0) {
                    return false;
                }
                re = this.scan.ctrl(5);
                return re == 0;
            }
            case HANDEHUOER: {
                try {
                    this.mSerialport = new com.BRMicro.SerialPort();
                    this.mSerialport.zigbeepoweron();
                    this.mSerialport.rfidPoweron();
                    this.mSerialport.switch2Channel(13);
                }
                catch (Exception ex) {
                    return false;
                }
                return true;
            }
            case CZ880: {
                try {
                    FileWriter localFileWriterOn = new FileWriter(new File("/sys/class/tty/ttyHSL1/device/uart_switch"));
                    localFileWriterOn.write("slr53");
                    localFileWriterOn.close();
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case XIANSHI: {
                try {
                    FileWriter localFileWriterOn = new FileWriter(new File("/proc/gpiocontrol/set_id"));
                    localFileWriterOn.write("1");
                    localFileWriterOn.close();
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case XBANG: {
                String CTRL_FILE = "/sys/devices/platform/psam/psam_state";
                String data = "2";
                try {
                    FileOutputStream fis = new FileOutputStream(new File(CTRL_FILE));
                    fis.write(data.getBytes());
                    fis.close();
                }
                catch (IOException e) {
                    Log.e((String)"Exception", (String)("File write failed: " + e.toString()));
                    return false;
                }
                return true;
            }
            case NONE: {
                return true;
            }
        }
        return false;
    }

    public boolean PowerDown() {
        switch (this.ptype) {
            case CHAINWAY: {
                try {
                    this.module = Module.getInstance();
                    return this.module.powerOff(3);
                }
                catch (ConfigurationException ce) {
                    return false;
                }
            }
            case COMMANDLIST: {
                commnandList.add("echo 1 >/sys/devices/platform/gpio_test/uart1power");
                ShellUtils.CommandResult result = ShellUtils.execCommand(commnandList, (boolean)false);
                return result.result == 0;
            }
            case SCAN_ALPS_ANDROID_CUIUS2: {
                int re;
                if (this.scan == null) {
                    try {
                        this.scan = new Scan();
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                return (re = this.scan.ctrl(15)) == 0;
            }
            case ALPS_KT45: {
                try {
                    if (this.DevCtrl != null) {
                        this.DevCtrl.PowerOffDevice();
                    }
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
            case HD508: {
                try {
                    HitownAC3508Control.getInstance().close();
                }
                catch (Exception ex) {
                    return false;
                }
                return true;
            }
            case IDATA: {
                int re2 = com.device.serialport.SerialPort.ioctlFromJNI(4);
                return re2 == 0;
            }
            case JIEBAO: {
                return this.power_down();
            }
            case EKEMP: {
                Misc.uhfEnable(false);
                return false;
            }
            case SCAN_ALPS_ANDROID_CUIUS2_TEST: {
                return false;
            }
            case SENTER_ST308W: {
                Power.off();
                return true;
            }
            case SENTER_ST907: {
                Power.off_ST907_4P2v();
                return true;
            }
            case SCAN_ALPS_ANDROID_CUIUS2_NEBOARD: {
                int re;
                if (this.scan == null) {
                    try {
                        this.scan = new Scan();
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                if ((re = this.scan.ctrl(20)) != 0) {
                    return false;
                }
                re = this.scan.ctrl(4);
                if (re != 0) {
                    return false;
                }
                re = this.scan.ctrl(6);
                return re == 0;
            }
            case HANDEHUOER: {
                try {
                    this.mSerialport.zigbeepoweroff();
                    this.mSerialport.rfidPoweroff();
                }
                catch (Exception ex) {
                    return false;
                }
                return true;
            }
            case CZ880: {
                try {
                    FileWriter localFileWriterOn = new FileWriter(new File("/sys/class/tty/ttyHSL1/device/uart_switch"));
                    localFileWriterOn.write("disable");
                    localFileWriterOn.close();
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case XIANSHI: {
                try {
                    FileWriter localFileWriterOff = new FileWriter(new File("/proc/gpiocontrol/set_id"));
                    localFileWriterOff.write("0");
                    localFileWriterOff.close();
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case XBANG: {
                String CTRL_FILE = "/sys/devices/platform/psam/psam_state";
                String data = "3";
                try {
                    FileOutputStream fis = new FileOutputStream(new File(CTRL_FILE));
                    fis.write(data.getBytes());
                    fis.close();
                }
                catch (IOException e) {
                    Log.e((String)"Exception", (String)("File write failed: " + e.toString()));
                    return false;
                }
                return true;
            }
            case NONE: {
                return true;
            }
        }
        return false;
    }

    public String GetDevPath() {
        switch (this.ptype) {
            case CHAINWAY: {
                return "/dev/ttyMT3";
            }
            case COMMANDLIST: {
                return "/dev/ttyMT0";
            }
            case SCAN_ALPS_ANDROID_CUIUS2: {
                return "/dev/ttyMT1";
            }
            case ALPS_KT45: {
                return "/dev/ttyMT2";
            }
            case HD508: {
                return "/dev/ttyHSL1";
            }
            case IDATA: {
                return com.device.serialport.SerialPort.getDevPath(2);
            }
            case JIEBAO: {
                return "/dev/ttySAC3";
            }
            case EKEMP: {
                return "/dev/ttyVK3";
            }
            case SCAN_ALPS_ANDROID_CUIUS2_TEST: {
                return "/dev/ttyMT0";
            }
            case SENTER_ST308W: {
                return "/dev/ttyMT3";
            }
            case SENTER_ST907: {
                return "/dev/ttyHS1";
            }
            case SCAN_ALPS_ANDROID_CUIUS2_NEBOARD: {
                return "/dev/ttyMT0";
            }
            case HANDEHUOER: {
                return "/dev/ttyMT1";
            }
            case CZ880: {
                return "/dev/ttyHSL1";
            }
            case XIANSHI: {
                return "/dev/ttyS2";
            }
            case XBANG: {
                return "/dev/ttyHSL2";
            }
        }
        return "/dev/tty|192.168.1.100";
    }

    public static enum PDATYPE {
        CHAINWAY(1),
        COMMANDLIST(2),
        SCAN_ALPS_ANDROID_CUIUS2(3),
        ALPS_KT45(4),
        HD508(5),
        IDATA(6),
        JIEBAO(7),
        EKEMP(8),
        SCAN_ALPS_ANDROID_CUIUS2_TEST(9),
        SENTER_ST308W(10),
        SENTER_ST907(11),
        SCAN_ALPS_ANDROID_CUIUS2_NEBOARD(12),
        HANDEHUOER(13),
        CZ880(15),
        XIANSHI(16),
        XBANG(17),
        NONE(0);

        int p_v;

        private PDATYPE(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static PDATYPE valueOf(String string) {
            return Enum.valueOf(PDATYPE.class, string);
        }
    }
}

