/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class FingerprintWithMorpho
extends Device {
    private static FingerprintWithMorpho single = null;
    private static final String TAG = "FingerprintWithMorpho";
    private char mCount = '\u0000';
    private static boolean isDebug = false;
    protected DeviceConfiguration config;
    private boolean isStop = true;
    private static boolean runing = false;
    private PtCaptureCallBack ptCaptureCallBack = null;
    private EnrollCallBack enrollCallBack = null;
    private IdentificationCallBack identificationCallBack = null;
    private final int iGRAB = 1;
    private final int iENROLLL = 2;
    private final int iPTCAPTURE = 3;
    private final int iIDENTIFICATION = 4;
    private final int iTEMPLATEVERIFY = 5;
    private int RESULT_STATUS_SUCCESS = 0;
    private int RESULT_STATUS_CANCEL = -2;
    private int RESULT_STATUS_FAILURE = -1;
    private int RESULT_STATUS_NO_MATCH = -3;
    private final int RESULT_DATA = 1;
    private final int RESULT_MSG = 2;
    private final int RESULT_COMPLETE = 3;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            block23: {
                block26: {
                    block25: {
                        block24: {
                            if (isDebug) {
                                Log.i((String)FingerprintWithMorpho.TAG, (String)"handler---->handleMessage");
                            }
                            if (msg.what == 1) break block23;
                            if (msg.what != 2) break block24;
                            if (FingerprintWithMorpho.this.enrollCallBack == null) {
                                return;
                            }
                            switch (msg.arg1) {
                                case 2: {
                                    int codeID = Integer.parseInt(msg.obj.toString());
                                    FingerprintWithMorpho.this.enrollCallBack.messageInfo(FingerprintWithMorpho.this.getStatusMsg(codeID), codeID);
                                    break;
                                }
                                case 3: {
                                    boolean reuslt = Boolean.parseBoolean(msg.obj.toString());
                                    FingerprintWithMorpho.this.enrollCallBack.onComplete(reuslt, msg.arg2);
                                }
                            }
                            break block23;
                        }
                        if (msg.what != 3) break block25;
                        if (FingerprintWithMorpho.this.ptCaptureCallBack == null) {
                            return;
                        }
                        switch (msg.arg1) {
                            case 2: {
                                int codeID = Integer.parseInt(msg.obj.toString());
                                FingerprintWithMorpho.this.ptCaptureCallBack.messageInfo(FingerprintWithMorpho.this.getStatusMsg(codeID), codeID);
                                break;
                            }
                            case 3: {
                                byte[] reuslt = (byte[])msg.obj;
                                if (reuslt == null) {
                                    FingerprintWithMorpho.this.ptCaptureCallBack.onComplete(false, null, msg.arg2);
                                    break;
                                }
                                FingerprintWithMorpho.this.ptCaptureCallBack.onComplete(true, reuslt, msg.arg2);
                            }
                        }
                        break block23;
                    }
                    if (msg.what != 4) break block26;
                    if (isDebug) {
                        Log.i((String)FingerprintWithMorpho.TAG, (String)"iIDENTIFICATION");
                    }
                    if (FingerprintWithMorpho.this.identificationCallBack == null) {
                        if (isDebug) {
                            Log.i((String)FingerprintWithMorpho.TAG, (String)"identificationCallBack==null");
                        }
                        return;
                    }
                    if (isDebug) {
                        Log.i((String)FingerprintWithMorpho.TAG, (String)("identificationCallBack2222 msg.arg1=" + msg.arg1));
                    }
                    switch (msg.arg1) {
                        case 2: {
                            if (isDebug) {
                                Log.i((String)FingerprintWithMorpho.TAG, (String)"\u53d1\u9001\u6d88\u606f");
                            }
                            int codeID = Integer.parseInt(msg.obj.toString());
                            FingerprintWithMorpho.this.identificationCallBack.messageInfo(FingerprintWithMorpho.this.getStatusMsg(codeID), codeID);
                            if (isDebug) {
                                Log.i((String)FingerprintWithMorpho.TAG, (String)"\u53d1\u9001\u6d88\u606f\u5b8c\u6210");
                                break;
                            }
                            break block23;
                        }
                        case 3: {
                            String[] reuslt = (String[])msg.obj;
                            if (reuslt != null) {
                                FingerprintWithMorpho.this.identificationCallBack.onComplete(true, Integer.parseInt(reuslt[0]), reuslt[1], msg.arg2);
                                break;
                            }
                            FingerprintWithMorpho.this.identificationCallBack.onComplete(false, -1, "", msg.arg2);
                        }
                    }
                    break block23;
                }
                int cfr_ignored_0 = msg.what;
            }
        }
    };
    boolean isRunMessage = false;

    protected FingerprintWithMorpho() throws ConfigurationException {
        this.config = DeviceConfiguration.builderFingerprintConfiguration();
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public void setPtCaptureCallBack(PtCaptureCallBack callBack) {
        this.ptCaptureCallBack = callBack;
    }

    public void setPtEnrollCallBack(EnrollCallBack callBack) {
        this.enrollCallBack = callBack;
    }

    public void setIdentificationCallBack(IdentificationCallBack callBack) {
        this.identificationCallBack = callBack;
    }

    private boolean isCallBackNULL(int what) {
        if (what == 2 && this.enrollCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iENROLLL && enrollCallBack==null");
            }
            return true;
        }
        if (what == 3 && this.ptCaptureCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iPTCAPTURE && ptCaptureCallBack==null");
            }
            return true;
        }
        if (what == 4 && this.identificationCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iIDENTIFICATION && identificationCallBack==null");
            }
            return true;
        }
        return false;
    }

    private void sendMsg(int msgg, int what) {
        if (this.isCallBackNULL(what)) {
            return;
        }
        if (isDebug) {
            Log.i((String)TAG, (String)("iStatus=" + msgg));
        }
        Message msg = Message.obtain();
        msg.arg1 = 2;
        msg.what = what;
        msg.obj = msgg;
        this.handler.sendMessage(msg);
    }

    private void onComplete(boolean b, String id, String name, byte[] data, int param, int what) {
        if (isDebug) {
            Log.i((String)TAG, (String)"---------onComplete-------------");
        }
        if (this.isCallBackNULL(what)) {
            return;
        }
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = 3;
        msg.arg2 = param;
        switch (what) {
            case 2: {
                msg.obj = b;
                break;
            }
            case 3: {
                msg.obj = data;
                break;
            }
            case 4: {
                msg.obj = b ? new String[]{id, name} : null;
            }
        }
        this.handler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized FingerprintWithMorpho getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<FingerprintWithMorpho> clazz = FingerprintWithMorpho.class;
        synchronized (FingerprintWithMorpho.class) {
            if (single != null) return single;
            single = new FingerprintWithMorpho();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean init() {
        int result = this.getDeviceAPI().MorphoFingerInit(this.config.getDeviceName(), this.config.getUart(), 9600);
        if (result == 0) {
            Log.i((String)TAG, (String)"initMorpho() succ");
            this.setPowerOn(true);
            try {
                Thread.currentThread();
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        Log.e((String)TAG, (String)("initMorpho() err:" + result));
        return false;
    }

    public boolean free() {
        int result = this.getDeviceAPI().MorphoFingerFree(this.config.getDeviceName());
        if (result == 0) {
            Log.i((String)TAG, (String)"free() succ");
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err:" + result));
        return false;
    }

    public boolean stopPtCapture() {
        return this.morphoCancel();
    }

    public boolean stopEnroll() {
        return this.morphoCancel();
    }

    public boolean stopIdentification() {
        return this.morphoCancel();
    }

    public void startPtCapture(boolean encryptflag) {
        if (isDebug) {
            Log.i((String)TAG, (String)("StartPtCapture =>runing=" + runing));
        }
        if (runing) {
            this.sendMsg(202, 3);
            return;
        }
        runing = true;
        new ThreadPtCapture(encryptflag).start();
    }

    public void startEnroll(int id, String name) {
        if (isDebug) {
            Log.i((String)TAG, (String)("startEnroll =>runing=" + runing));
        }
        if (runing) {
            this.sendMsg(202, 2);
            return;
        }
        runing = true;
        new ThreadEnroll(id, name).start();
    }

    public void startIdentification() {
        if (isDebug) {
            Log.i((String)TAG, (String)("startIdentify =>runing=" + runing));
        }
        if (runing) {
            this.sendMsg(202, 2);
            return;
        }
        runing = true;
        new ThreadIdentification().start();
    }

    public synchronized String getMorphoDescriptor() {
        byte[] result = this.getDeviceAPI().MorphoDescriptor();
        byte[] status = Arrays.copyOfRange(result, 0, 4);
        int iStatus = StringUtility.bytesToInt(status);
        if (iStatus == 0) {
            byte[] len = Arrays.copyOfRange(result, 4, 8);
            int iLen = StringUtility.bytesToInt(len);
            byte[] version = Arrays.copyOfRange(result, 8, 8 + iLen);
            return new String(version);
        }
        return "";
    }

    private byte[] morphoCapture(char flag, char encryptflag) {
        return this.getDeviceAPI().MorphoCapture(flag, encryptflag);
    }

    private int morphoEnroll(int id, String Name, char flag) {
        char[] idArr = String.valueOf(id).toCharArray();
        char[] firstNameArr = Name.toCharArray();
        char[] idArrs = new char[idArr.length + 1];
        char[] firstNameArrs = new char[firstNameArr.length + 1];
        idArrs[0] = (char)idArr.length;
        int i = 0;
        while (i < idArr.length) {
            idArrs[i + 1] = idArr[i];
            ++i;
        }
        firstNameArrs[0] = (char)firstNameArr.length;
        i = 0;
        while (i < firstNameArr.length) {
            firstNameArrs[i + 1] = firstNameArr[i];
            ++i;
        }
        int result = this.getDeviceAPI().MorphoEnroll(flag, idArrs, firstNameArrs);
        if (result == 0) {
            Log.i((String)TAG, (String)"morphoEnroll() succ");
            return 0;
        }
        Log.e((String)TAG, (String)("morphoEnroll() err:" + result));
        return result;
    }

    public synchronized boolean setMorphoLoadKs(byte[] keybuf) {
        if (keybuf == null || keybuf.length == 0) {
            return false;
        }
        byte[] tempKey = new byte[24];
        if (keybuf.length > 24) {
            tempKey = Arrays.copyOfRange(keybuf, 0, 24);
        } else if (keybuf.length < 24) {
            int k = 0;
            while (k < keybuf.length) {
                tempKey[k] = keybuf[k];
                ++k;
            }
        } else {
            tempKey = keybuf;
        }
        return this.getDeviceAPI().MorphoLoadKs(tempKey) == 0;
    }

    public synchronized String getMorphoPIDSN() {
        byte[] result = this.getDeviceAPI().MorphoPIDSN();
        byte[] status = Arrays.copyOfRange(result, 0, 4);
        int iStatus = StringUtility.bytesToInt(status);
        if (iStatus == 0) {
            byte[] len = Arrays.copyOfRange(result, 4, 8);
            int iLen = StringUtility.bytesToInt(len);
            byte[] version = Arrays.copyOfRange(result, 8, 8 + iLen);
            return new String(version);
        }
        return "";
    }

    public synchronized boolean morphoEraseAllBase() {
        if (runing) {
            this.sendMsg(202, 2);
            return false;
        }
        return this.getDeviceAPI().MorphoEraseAllBase() == 0;
    }

    private boolean morphoCancel() {
        return this.getDeviceAPI().MorphoCancel() == 0;
    }

    private String[] morphoIdentify(char flag) {
        byte[] status;
        int iStatus;
        if (isDebug) {
            Log.i((String)TAG, (String)"morphoIdentify() begin");
        }
        byte[] result = this.getDeviceAPI().MorphoIdentify(flag);
        if (isDebug) {
            Log.i((String)TAG, (String)"morphoIdentify() end");
        }
        if ((iStatus = StringUtility.bytesToInt(status = Arrays.copyOfRange(result, 0, 4))) == 0) {
            int idIndex = 5;
            int idEnd = idIndex + (result[4] & 0xFF);
            byte[] id = Arrays.copyOfRange(result, idIndex, idEnd);
            int nameIndex = idEnd + 1;
            int nameEnd = nameIndex + (result[idEnd] & 0xFF);
            byte[] fName = Arrays.copyOfRange(result, nameIndex, nameEnd);
            char[] idc = StringUtility.bytesTochars(id, id.length);
            char[] name = StringUtility.bytesTochars(fName, fName.length);
            String[] strArr = new String[]{new String(idc), new String(name)};
            if (isDebug) {
                Log.i((String)TAG, (String)"morphoIdentify() ok");
            }
            return strArr;
        }
        Log.e((String)TAG, (String)("morphoIdentify() err:" + iStatus));
        String[] resultS = new String[]{String.valueOf(iStatus)};
        return resultS;
    }

    private synchronized char getCount() {
        this.mCount = (char)(this.mCount + '\u0001');
        if (this.mCount > '\u00ff') {
            this.mCount = '\u0000';
        }
        return this.mCount;
    }

    public synchronized String getStatusMsg(int status) {
        switch (status) {
            case 0: {
                return "success";
            }
            case -1: {
                return "ILV_Init failed";
            }
            case -2: {
                return "ILV_AddValue  failed";
            }
            case -3: {
                return "ILV Send  failed";
            }
            case -4: {
                return "Receive ILV answer  failed";
            }
            case -5: {
                return "Analyse ILV failed";
            }
            case -6: {
                return "Async_Event failed";
            }
            case -7: {
                return "An ILV error occurred, An unexpected error occurred during the execution of the command.";
            }
            case -8: {
                return "Authentication or Identification failed.";
            }
            case -9: {
                return "Security Protection Triggered";
            }
            case -10: {
                return "The database is full";
            }
            case -11: {
                return "The database is empty.";
            }
            case -12: {
                return "The flash can not be accessed";
            }
            case 100: {
                return "Processing, please keep finger on the sensor";
            }
            case 101: {
                return "User must move his finger up.";
            }
            case 102: {
                return "User must move his finger down. ";
            }
            case 103: {
                return "User must move his finger to the left. ";
            }
            case 104: {
                return "User must move his finger to the right. ";
            }
            case 105: {
                return "Finger image is too small. ";
            }
            case 106: {
                return "Possible latent fingerprint. The fingerprint detected on the sensor is at the same place as a previous fingerprint acquisition.";
            }
            case 107: {
                return "Remove your finger";
            }
            case 108: {
                return " The whole finger acquisition is completed with success.";
            }
            case 109: {
                return " The finger has been detected by hardware DTPR.";
            }
            case 110: {
                return "Processing, please keep finger on the sensor";
            }
            case 201: {
                return "stop";
            }
            case 202: {
                return "Fingerprint module busy";
            }
            case 252: {
                return "UserID is not valid.";
            }
            case 248: {
                return "User has already been enrolled.";
            }
            case 203: {
                return "failure";
            }
        }
        return "Message codes\uff1a" + status;
    }

    public static interface EnrollCallBack {
        public void messageInfo(String var1, int var2);

        public void onComplete(boolean var1, int var2);
    }

    public static interface IdentificationCallBack {
        public void messageInfo(String var1, int var2);

        public void onComplete(boolean var1, int var2, String var3, int var4);
    }

    private class MorphoMessage
    extends Thread {
        int type = 3;

        public MorphoMessage(int itype) {
            this.type = itype;
        }

        @Override
        public void run() {
            int oldstatus = 0;
            while (FingerprintWithMorpho.this.isRunMessage) {
                int isstatus = FingerprintWithMorpho.this.getDeviceAPI().MorphoFingerMessage();
                if (isstatus != -1 && oldstatus != isstatus) {
                    oldstatus = isstatus;
                    FingerprintWithMorpho.this.sendMsg(isstatus, this.type);
                    if (isDebug) {
                        Log.i((String)FingerprintWithMorpho.TAG, (String)("MorphoMessage  isstatus=" + isstatus));
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface PtCaptureCallBack {
        public void messageInfo(String var1, int var2);

        public void onComplete(boolean var1, byte[] var2, int var3);
    }

    class ThreadEnroll
    extends Thread {
        int id;
        String Name = "";

        private ThreadEnroll(int id, String Name) {
            this.id = id;
            this.Name = Name;
        }

        @Override
        public void run() {
            if (this.id < 0 || this.Name.isEmpty()) {
                FingerprintWithMorpho.this.sendMsg(203, 2);
                FingerprintWithMorpho.this.onComplete(false, "", "", null, FingerprintWithMorpho.this.RESULT_STATUS_FAILURE, 2);
                return;
            }
            if (this.enroll()) {
                FingerprintWithMorpho.this.onComplete(true, "", "", null, FingerprintWithMorpho.this.RESULT_STATUS_SUCCESS, 2);
            } else {
                FingerprintWithMorpho.this.onComplete(false, "", "", null, FingerprintWithMorpho.this.RESULT_STATUS_FAILURE, 2);
            }
            runing = false;
        }

        private boolean enroll() {
            FingerprintWithMorpho.this.mCount = '\u0100';
            int iStatus = FingerprintWithMorpho.this.morphoEnroll(this.id, this.Name, FingerprintWithMorpho.this.getCount());
            FingerprintWithMorpho.this.sendMsg(iStatus, 2);
            if (iStatus < 0) {
                return false;
            }
            return iStatus == 0;
        }
    }

    class ThreadIdentification
    extends Thread {
        ThreadIdentification() {
        }

        @Override
        public void run() {
            String[] reslut = this.getData();
            if (isDebug) {
                Log.i((String)FingerprintWithMorpho.TAG, (String)"getData()\u6267\u884c\u5b8c\u6210");
            }
            if (reslut == null) {
                FingerprintWithMorpho.this.onComplete(false, "", "", null, FingerprintWithMorpho.this.RESULT_STATUS_NO_MATCH, 4);
            } else {
                FingerprintWithMorpho.this.onComplete(true, reslut[0], reslut[1], null, FingerprintWithMorpho.this.RESULT_STATUS_SUCCESS, 4);
            }
            runing = false;
        }

        public String[] getData() {
            FingerprintWithMorpho.this.mCount = '\u0100';
            String[] result = FingerprintWithMorpho.this.morphoIdentify(FingerprintWithMorpho.this.getCount());
            if (result.length == 2) {
                if (isDebug) {
                    Log.i((String)FingerprintWithMorpho.TAG, (String)"ThreadIdentification 11");
                }
                FingerprintWithMorpho.this.sendMsg(0, 4);
                return result;
            }
            if (isDebug) {
                Log.i((String)FingerprintWithMorpho.TAG, (String)"ThreadIdentification 22");
            }
            FingerprintWithMorpho.this.sendMsg(Integer.parseInt(result[0]), 4);
            return null;
        }
    }

    class ThreadPtCapture
    extends Thread {
        char encryptflag = '\u0000';
        int resultCode;

        private ThreadPtCapture(boolean flag) {
            this.resultCode = FingerprintWithMorpho.this.RESULT_STATUS_FAILURE;
            this.encryptflag = flag ? (char)'\u0001' : '\u0000';
        }

        @Override
        public void run() {
            FingerprintWithMorpho.this.isRunMessage = true;
            new MorphoMessage(3).start();
            byte[] data = this.getData(this.encryptflag);
            FingerprintWithMorpho.this.isRunMessage = false;
            if (data == null) {
                FingerprintWithMorpho.this.onComplete(false, "", "", data, this.resultCode, 3);
            } else {
                FingerprintWithMorpho.this.onComplete(true, "", "", data, this.resultCode, 3);
            }
            runing = false;
        }

        private byte[] getData(char encryptflag) {
            int iStatus = 0;
            FingerprintWithMorpho.this.mCount = '\u0100';
            byte[] buff = FingerprintWithMorpho.this.morphoCapture(FingerprintWithMorpho.this.getCount(), encryptflag);
            iStatus = StringUtility.bytesToInt(Arrays.copyOfRange(buff, 0, 4));
            if (iStatus < 0) {
                this.resultCode = FingerprintWithMorpho.this.RESULT_STATUS_FAILURE;
                FingerprintWithMorpho.this.sendMsg(iStatus, 3);
                return null;
            }
            if (iStatus == 0) {
                this.resultCode = FingerprintWithMorpho.this.RESULT_STATUS_SUCCESS;
                FingerprintWithMorpho.this.sendMsg(0, 3);
                int templateSize = StringUtility.bytesToInt(Arrays.copyOfRange(buff, 4, 8));
                byte[] template = Arrays.copyOfRange(buff, 8, 8 + templateSize);
                return template;
            }
            this.resultCode = FingerprintWithMorpho.this.RESULT_STATUS_FAILURE;
            FingerprintWithMorpho.this.sendMsg(iStatus, 3);
            return null;
        }
    }
}

