/*
 * Decompiled with CFR 0.152.
 */
package com.device.serialport;

public final class SerialPort {
    private static final int RETURNCODE_FAILURE = 1;
    private static final int RETURNCODE_SUCCESS = 0;
    public static final int IOCTRL_PMU_RFID_ON = 3;
    public static final int IOCTRL_PMU_RFID_OFF = 4;
    private static final int IOCTRL_PMU_BARCODE_ON = 5;
    private static final int IOCTRL_PMU_BARCODE_OFF = 6;
    static final int IOCTRL_PMU_RS232_ON = 23;
    static final int IOCTRL_PMU_RS232_OFF = 24;
    private static int device = 0;

    static {
        System.loadLibrary("serial_port_idata");
    }

    private static native int initFromJNI(int var0, int var1, int var2);

    private static native int setTimeArg(int var0, int var1);

    public static native int ioctlFromJNI(int var0);

    public static native String getDevPath(int var0);

    private native int getReceiveArray(byte[] var1, int var2);

    private native int writeByteArrFromJNI(byte[] var1, int var2);

    private static native int exitFromJNI();

    public static int openSerial(int dev, int baud, int evenMode) {
        int hSerialRFID = -1;
        hSerialRFID = SerialPort.initFromJNI(dev, baud, evenMode);
        if (-1 == hSerialRFID) {
            return 1;
        }
        device = dev;
        SerialPort.setArg(1, 400);
        return 0;
    }

    public int read(byte[] caRecvData, int nByteSize) {
        return this.getReceiveArray(caRecvData, nByteSize);
    }

    public int read(byte[] caRecvData) {
        return this.getReceiveArray(caRecvData, 0);
    }

    public int write(byte[] baWriteData, int nByteSize) {
        return this.writeByteArrFromJNI(baWriteData, nByteSize);
    }

    public String getDevicePath(int device) {
        return SerialPort.getDevPath(device);
    }

    public static int setArg(int writeDelay, int firstReadWait) {
        return SerialPort.setTimeArg(writeDelay, firstReadWait);
    }

    public int SetPowerState(int controlcode) {
        return SerialPort.ioctlFromJNI(controlcode);
    }

    public static int closeSerial() {
        switch (device) {
            case 1: {
                SerialPort.ioctlFromJNI(5);
                break;
            }
            case 2: {
                SerialPort.ioctlFromJNI(3);
                break;
            }
            case 3: {
                SerialPort.ioctlFromJNI(23);
                break;
            }
        }
        SerialPort.exitFromJNI();
        return 0;
    }
}

