/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.uhf.Common;

import android.app.Application;
import android.content.Context;
import android.content.IntentFilter;
import android.media.SoundPool;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.View;
import android.widget.RadioGroup;
import android.widget.TabHost;
import com.uhf.api.cls.Reader;
import com.uhf.uhf.Common.InventoryBuffer;
import com.uhf.uhf.UHF1.UHF001;
import com.uhf.uhf.UHF1.UHF1Application;
import com.uhf.uhf.UHF1Function.AndroidWakeLock;
import com.uhf.uhf.UHF1Function.SPconfig;
import com.uhf.uhf.UHF1Function.ScreenListener;
import com.uhf.uhf.UHF5.RFIDOperate;
import com.uhf.uhf.UHF5helper.ReaderHelper;
import com.uhf.uhf.UHF6.BaseTabFragmentActivity;
import com.uhf.uhf.UHF6.UHF006;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Comm {
    public static Application app;
    public static UHF1Application myapp;
    public static SPconfig spConfig;
    public static Module moduleType;
    public static AndroidWakeLock Awl;
    public static SoundPool soundPool;
    public static String COM;
    public static int Baudrate;
    public static TabHost supoinTabHost;
    public static int rfidSleep;
    public static int rfidRunTime;
    public static int session;
    public static int btTarget;
    public static RFIDOperate rfidOperate;
    public static IntentFilter itent;
    public static List<InventoryBuffer.InventoryTagMap> lsTagList;
    public static int tagListSize;
    public static int ReadCnt;
    public static operateType opeT;
    public static int mPos1;
    public static int mPos2;
    public static String strPwd;
    public static int uhf5outpouwer;
    public static boolean isQuick;
    public static final int OPERATE_TEXT = 1;
    public static final int UHF5MESSAGE_TEXT = 2;
    public static final int UHF1MESSAGE_TEXT = 3;
    public static Handler mRWLHandler;
    public static Handler mOtherHandler;
    public static boolean isrun;
    public static String[] tag;
    public static int[] tagcnt;
    public static List<Byte> LB;
    public static Reader.TAGINFO[] Ltis;
    public static Reader.TAGINFO tfs;
    public static boolean runCycleRead;
    public static String tagUHF1;
    public static String tagUHF5;
    public static int version;
    public static int ant;
    public static LocalBroadcastManager lbm;
    public static Handler connecthandler;
    public static Context context;
    public static ScreenListener l;
    public static int Qvalue;
    public static String strModel;
    public static boolean repeatSound;
    public static BaseTabFragmentActivity baseTabFragment;
    public static UHF006 uhf6;
    public static final String CTRL_FILE_YF = "/sys/devices/platform/psam/psam_state";
    public static final String CTRL_FILE_G3G = "/sys/devices/platform/psam/psam_state";
    public static final String CTRL_FILE_MTK = "/sys/devices/platform/psam_dev/psam_state";
    private static final String CTRL_FILE_G4G = "/sys/devices/soc.0/78b0000.serial/uart_switch";
    public static DeviceType dt;
    public static SerialPortCallback comm_callback;

    private static void writeToCtrlFile(String data) {
        try {
            if (dt == DeviceType.supion_S_3) {
                FileOutputStream fps = new FileOutputStream(new File("/sys/devices/platform/psam/psam_state"));
                fps.write(data.getBytes());
                fps.close();
            } else if (dt == DeviceType.supion_M_3 || dt == DeviceType.supion_M_4) {
                FileOutputStream fps = new FileOutputStream(new File(CTRL_FILE_MTK));
                fps.write(data.getBytes());
                fps.close();
            } else if (dt == DeviceType.supion_Y_4) {
                FileOutputStream fps = new FileOutputStream(new File("/sys/devices/platform/psam/psam_state"));
                fps.write(data.getBytes());
                fps.close();
            } else {
                FileOutputStream fps = new FileOutputStream(new File(CTRL_FILE_G4G));
                fps.write(data.getBytes());
                fps.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void checkDevice() {
        String strM = Build.MODEL;
        int SDK = Build.VERSION.SDK_INT;
        try {
            if (strM.equals("SHT3X")) {
                if (SDK == 23) {
                    dt = DeviceType.supion_Y_4;
                    COM = "dev/ttyMT0";
                } else {
                    dt = DeviceType.supion_M_3;
                    COM = "dev/ttyMT2";
                }
            } else if (strM.equals("SHT3X-4G")) {
                dt = DeviceType.supion_M_4;
                COM = "dev/ttyMT3";
            } else if (strM.equals("SHT0X")) {
                dt = DeviceType.supion_S_4;
                COM = "/dev/ttyHSL1";
            } else if (SDK == 18) {
                dt = DeviceType.supion_S_3;
                COM = "/dev/ttyHSL2";
            } else if (SDK == 22) {
                dt = DeviceType.supion_S_4;
                COM = "/dev/ttyHSL0";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"TAG", (String)("err:" + e.getMessage()));
        }
    }

    public static boolean powerUp() {
        try {
            if (dt == DeviceType.supion_S_3 || dt == DeviceType.supion_M_3 || dt == DeviceType.supion_M_4) {
                Comm.writeToCtrlFile("2");
            } else if (dt == DeviceType.supion_S_4 || dt == DeviceType.supion_Y_4) {
                Comm.writeToCtrlFile("uart3");
            } else {
                Comm.writeToCtrlFile("2");
                Comm.writeToCtrlFile("uart3");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean powerDown() {
        try {
            if (dt == DeviceType.supion_S_3 || dt == DeviceType.supion_M_3 || dt == DeviceType.supion_M_4) {
                Comm.writeToCtrlFile("3");
            } else if (dt == DeviceType.supion_S_4 || dt == DeviceType.supion_Y_4) {
                Comm.writeToCtrlFile("disable");
                Comm.writeToCtrlFile("uart2");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void Connect() {
        String strSERIAL = Build.SERIAL;
        String strModule = strSERIAL.substring(5, 6);
        Log.d((String)"UHF", (String)("strModule:" + strModule));
        switch (strModule) {
            case "1": 
            case "2": {
                Comm.Connect(1);
                break;
            }
            case "6": {
                Comm.Connect(6);
                break;
            }
            default: {
                Comm.connectModule();
            }
        }
    }

    public static void Connect(int module) {
        String strSERIAL = Build.SERIAL;
        String strModule = strSERIAL.substring(5, 6);
        Log.d((String)"UHF", (String)("strModule:" + strModule));
        Message m = connecthandler.obtainMessage();
        Bundle b = new Bundle();
        switch (module) {
            case 1: 
            case 2: {
                if (UHF001.connect()) {
                    if (moduleType != null) {
                        strModel = moduleType.toString().substring(2);
                        b.putString("Msg", "\u6a21\u5757\u521d\u59cb\u5316\u6210\u529f");
                        moduleType = Module.UHF001;
                        Comm.myapp.needreconnect = false;
                    }
                    m.setData(b);
                    connecthandler.sendMessage(m);
                    break;
                }
                Log.d((String)"UHF", (String)" u1 connectModule();");
                Comm.connectModule();
                break;
            }
            case 5: 
            case 6: {
                if (baseTabFragment.initUHF() && Comm.baseTabFragment.isCW) {
                    Log.d((String)"UHF", (String)"initUHF");
                    uhf6 = new UHF006();
                    Log.d((String)"UHF", (String)"new com.uhf.uhf.UHF6.UHF006();");
                    ReaderHelper.m_curInventoryBuffer = new InventoryBuffer();
                    Log.d((String)"UHF", (String)"initUHF_true");
                    moduleType = Module.UHF006;
                    strModel = moduleType.toString().substring(2);
                    b.putString("Msg", "\u6a21\u5757\u521d\u59cb\u5316\u6210\u529f");
                    m.setData(b);
                    connecthandler.sendMessage(m);
                    break;
                }
                Log.d((String)"UHF", (String)" u6 connectModule();");
                Comm.connectModule();
                break;
            }
            default: {
                Comm.connectModule();
            }
        }
    }

    public static void connectModule() {
        if (UHF001.connect()) {
            Log.d((String)"UHF", (String)"UHF001.connect()");
            Message m = connecthandler.obtainMessage();
            Bundle b = new Bundle();
            if (moduleType != null) {
                strModel = moduleType.toString().substring(2);
                b.putString("Msg", "\u6a21\u5757\u521d\u59cb\u5316\u6210\u529f");
                moduleType = Module.UHF001;
                Comm.myapp.needreconnect = false;
            }
            m.setData(b);
            connecthandler.sendMessage(m);
        } else if (baseTabFragment.initUHF() && Comm.baseTabFragment.isCW) {
            Log.d((String)"UHF", (String)"baseTabFragment.initUHF");
            uhf6 = new UHF006();
            ReaderHelper.m_curInventoryBuffer = new InventoryBuffer();
            Message m = connecthandler.obtainMessage();
            Bundle b = new Bundle();
            moduleType = Module.UHF006;
            strModel = moduleType.toString().substring(2);
            b.putString("Msg", "\u6a21\u5757\u521d\u59cb\u5316\u6210\u529f");
            m.setData(b);
            connecthandler.sendMessage(m);
        } else {
            Comm.ConnectUHF5();
        }
    }

    public static void ConnectUHF5() {
        Comm.UHF005connect(new SerialPortCallback(){

            @Override
            public void onReceive(String strVersion, int i) {
                Message m = connecthandler.obtainMessage();
                Bundle b = new Bundle();
                if (!strVersion.equals("0")) {
                    moduleType = Module.UHF005;
                    strModel = moduleType.toString().substring(2);
                    b.putString("Msg", "\u6a21\u5757\u521d\u59cb\u5316\u6210\u529f");
                    m.setData(b);
                    connecthandler.sendMessage(m);
                }
            }
        });
    }

    public static void startScan() {
        isrun = true;
        if (dt == DeviceType.supion_S_3 || dt == DeviceType.supion_M_3 || dt == DeviceType.supion_M_4) {
            Comm.writeToCtrlFile("startrfid");
        } else if (dt == DeviceType.supion_S_4) {
            Comm.writeToCtrlFile(new String("startrfid"));
        }
        if (moduleType == Module.UHF001 && UHF001.CheckToScan()) {
            if (Comm.myapp.ThreadMODE == 0) {
                UHF001.UHF1startScan();
            }
            Comm.myapp.Devaddrs.clear();
        } else if (moduleType == Module.UHF005) {
            rfidOperate.startScan(session, btTarget, ant);
        } else if (moduleType == Module.UHF006) {
            uhf6.readTag(1);
        } else if (dt == DeviceType.supion_S_3 || dt == DeviceType.supion_M_3 || dt == DeviceType.supion_M_4) {
            Comm.writeToCtrlFile("stoprfid");
        } else if (dt == DeviceType.supion_S_4) {
            Comm.writeToCtrlFile(new String("stoprfid"));
        }
    }

    public static void stopScan() {
        isrun = false;
        if (moduleType == Module.UHF001) {
            if (Comm.myapp.nostop && (UHF001.er = Comm.myapp.Mreader.AsyncStopReading()) != Reader.READER_ERR.MT_OK_ERR) {
                return;
            }
            if (Comm.myapp.ThreadMODE == 0) {
                UHF001.UHF1stopScan();
            } else {
                try {
                    UHF001.runThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Comm.myapp.Devaddrs.putAll(UHF001.Devaddrs);
            if (Comm.myapp.nostop) {
                UHF001.UHF1sendMes();
            }
        } else if (moduleType == Module.UHF005) {
            rfidOperate.stop();
        } else if (moduleType == Module.UHF006) {
            uhf6.UHF6Stop();
        }
        if (dt == DeviceType.supion_S_3 || dt == DeviceType.supion_M_3 || dt == DeviceType.supion_M_4) {
            Comm.writeToCtrlFile("stoprfid");
        } else if (dt == DeviceType.supion_S_4) {
            Comm.writeToCtrlFile(new String("stoprfid"));
        }
    }

    public static void clean() {
        if (moduleType == Module.UHF001 && !isrun) {
            UHF001.Devaddrs.clear();
            Comm.myapp.Devaddrs.clear();
            Comm.myapp.Curepc = "";
            tagListSize = 0;
            ReaderHelper.m_curInventoryBuffer.dtIndexMap.clear();
            lsTagList.clear();
        } else if (moduleType == Module.UHF005 && !isrun) {
            RFIDOperate.m_curInventoryBuffer.clearInventoryPar();
            RFIDOperate.m_curInventoryBuffer.clearInventoryRealResult();
            tagListSize = 0;
            lsTagList.clear();
        } else if (moduleType == Module.UHF006 && !isrun) {
            tagListSize = 0;
            ReaderHelper.m_curInventoryBuffer.dtIndexMap.clear();
            lsTagList.clear();
        }
    }

    public static boolean setParameters() {
        if (moduleType == Module.UHF001 && UHF001.setUHF1Parameters()) {
            return true;
        }
        if (moduleType == Module.UHF005 && RFIDOperate.setUHF5Parameters()) {
            rfidSleep = 50;
            return true;
        }
        if (moduleType == Module.UHF006 && uhf6.setUHF6Parameters()) {
            rfidSleep = 0;
            return true;
        }
        return false;
    }

    public static void readTag(int ant, int tagBank, String opCount, String startAdd, int datatype) {
        Message m = new Message();
        Bundle b = new Bundle();
        try {
            if (moduleType == Module.UHF001) {
                String val = UHF001.uhf1readOp(ant, tagBank, opCount, startAdd, datatype);
                b.putString("readData", val);
                m.setData(b);
                mRWLHandler.sendMessage(m);
            } else if (moduleType == Module.UHF005) {
                opeT = operateType.readOpe;
                String val = RFIDOperate.uhf5readOp(ant, tagBank, opCount, startAdd, datatype);
                if (val != "") {
                    b.putString("Err", val);
                }
            } else if (moduleType == Module.UHF006) {
                opeT = operateType.readOpe;
                String val = uhf6.uhf6readOp(ant, tagBank, opCount, startAdd, datatype);
                b.putString("readData", val);
                m.setData(b);
                mRWLHandler.sendMessage(m);
                if (val != "") {
                    b.putString("Err", val);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"readTag", (String)e.getMessage());
            b.putString("Err", e.getMessage());
        }
    }

    public static void writeTag(int ant, int tagBank, String opCount, String startAdd, int datatype, String strWriteData) {
        opeT = operateType.writeOpe;
        Message m = new Message();
        Bundle b = new Bundle();
        try {
            Boolean writeSuc = false;
            if (moduleType == Module.UHF001) {
                writeSuc = UHF001.uhf1writeOp(datatype, ant, tagBank, opCount, startAdd, strWriteData);
                if (writeSuc.booleanValue()) {
                    b.putBoolean("isWriteSucceed", true);
                } else {
                    b.putBoolean("isWriteSucceed", false);
                }
                m.setData(b);
                mRWLHandler.sendMessage(m);
            } else if (moduleType == Module.UHF005) {
                String strRet = RFIDOperate.uhf5writeOp(ant, tagBank, opCount, startAdd, datatype, strWriteData);
                if (strRet != "") {
                    Log.d((String)"wirteTag", (String)strRet);
                    b.putBoolean("isWriteSucceed", false);
                }
            } else if (moduleType == Module.UHF006) {
                writeSuc = uhf6.uhf6writeOp(ant, tagBank, opCount, startAdd, datatype, strWriteData);
                if (writeSuc.booleanValue()) {
                    b.putBoolean("isWriteSucceed", true);
                } else {
                    b.putBoolean("isWriteSucceed", false);
                }
                m.setData(b);
                mRWLHandler.sendMessage(m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"wirteTag", (String)e.getMessage());
            b.putBoolean("isWriteSucceed", false);
            m.setData(b);
            mRWLHandler.sendMessage(m);
        }
    }

    public static void lockTag(int ant, int lbank, int ltype) {
        Message m = new Message();
        Bundle b = new Bundle();
        try {
            if (moduleType == Module.UHF001) {
                boolean lock = UHF001.uhf1lockOp(ant, lbank, ltype);
                if (lock) {
                    b.putBoolean("isLockSucceed", true);
                } else {
                    b.putBoolean("isLockSucceed", false);
                }
                m.setData(b);
                mRWLHandler.sendMessage(m);
            } else if (moduleType == Module.UHF005) {
                opeT = operateType.lockOpe;
                String strRet = RFIDOperate.uhf5lockOp(ant, lbank, ltype);
                if (strRet != "") {
                    Log.d((String)"lockTag", (String)strRet);
                }
            } else if (moduleType == Module.UHF006) {
                opeT = operateType.lockOpe;
                boolean lock = uhf6.uhf6lockOp(ant, lbank, ltype);
                if (lock) {
                    b.putBoolean("isLockSucceed", true);
                } else {
                    b.putBoolean("isLockSucceed", false);
                }
                m.setData(b);
                mRWLHandler.sendMessage(m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"lockTag", (String)e.getMessage());
        }
    }

    public static void getAntCheck() {
        Message m = new Message();
        Bundle b = new Bundle();
        if (moduleType == Module.UHF001) {
            int antIndex = UHF001.getAntCheck();
            b.putInt("antIndex", antIndex);
        }
        m.setData(b);
        mOtherHandler.sendMessage(m);
    }

    public static void setANTCheck(int antCheckEnable) {
        Message m = new Message();
        Bundle b = new Bundle();
        if (moduleType == Module.UHF001) {
            boolean antCheck = UHF001.setAntCheck(antCheckEnable);
            b.putBoolean("isSetAntCheck", antCheck);
        }
        m.setData(b);
        mOtherHandler.sendMessage(m);
    }

    public static void getAntPower() {
        Message m = new Message();
        Bundle b = new Bundle();
        if (moduleType == Module.UHF001) {
            UHF001.getAntPowerConf = new Reader.AntPowerConf(Comm.myapp.Mreader);
            UHF001.getPower();
            if (UHF001.getAntPowerConf != null) {
                for (int i = 0; i < UHF001.getAntPowerConf.antcnt; ++i) {
                    if (i == 0) {
                        int ant1Power = (UHF001.getAntPowerConf.Powers[i].readPower - 500) / 100;
                        b.putInt("ant1Power", ant1Power);
                        continue;
                    }
                    if (i == 1) {
                        int ant2Power = (UHF001.getAntPowerConf.Powers[i].readPower - 500) / 100;
                        b.putInt("ant2Power", ant2Power);
                        continue;
                    }
                    if (i == 2) {
                        int ant3Power = (UHF001.getAntPowerConf.Powers[i].readPower - 500) / 100;
                        b.putInt("ant3Power", ant3Power);
                        continue;
                    }
                    if (i != 3) continue;
                    int ant4Power = (UHF001.getAntPowerConf.Powers[i].readPower - 500) / 100;
                    b.putInt("ant4Power", ant4Power);
                }
            }
            m.setData(b);
            mOtherHandler.sendMessage(m);
        } else if (moduleType == Module.UHF005) {
            RFIDOperate.mReader.getOutputPower(RFIDOperate.m_curReaderSetting.btReadId);
        } else if (moduleType == Module.UHF006) {
            String strPower = uhf6.getOutputPower();
            b.putInt("ant1Power", Integer.parseInt(strPower) - 5);
            b.putInt("ant2Power", 1);
            b.putInt("ant3Power", 1);
            b.putInt("ant4Power", 1);
            m.setData(b);
            mOtherHandler.sendMessage(m);
        }
    }

    public static void setAntPower(int ant1pow, int ant2pow, int ant3pow, int ant4pow) {
        opeT = operateType.setPower;
        Message m = new Message();
        Bundle b = new Bundle();
        boolean isSuc = false;
        if (moduleType == Module.UHF001) {
            UHF001.setAntPowerConf = new Reader.AntPowerConf(Comm.myapp.Mreader);
            int[] rp = new int[4];
            int[] wp = new int[4];
            rp[0] = ant1pow;
            rp[1] = ant2pow;
            rp[2] = ant3pow;
            rp[3] = ant4pow;
            wp[0] = rp[0];
            wp[1] = rp[1];
            wp[2] = rp[2];
            wp[3] = rp[3];
            UHF001.setAntPowerConf.antcnt = Comm.myapp.antportc;
            int[] rpow = new int[UHF001.setAntPowerConf.antcnt];
            int[] wpow = new int[UHF001.setAntPowerConf.antcnt];
            for (int i = 0; i < UHF001.setAntPowerConf.antcnt; ++i) {
                Reader.AntPower jaap = new Reader.AntPower(Comm.myapp.Mreader);
                jaap.antid = i + 1;
                jaap.readPower = (short)(500 + 100 * rp[i]);
                rpow[i] = jaap.readPower;
                jaap.writePower = (short)(500 + 100 * wp[i]);
                wpow[i] = jaap.writePower;
                UHF001.setAntPowerConf.Powers[i] = jaap;
            }
            boolean setPower = UHF001.setPower(rpow, wpow);
            isSuc = setPower;
            b.putBoolean("isSetPower", isSuc);
            m.setData(b);
            mOtherHandler.sendMessage(m);
        } else if (moduleType == Module.UHF005) {
            uhf5outpouwer = (short)((500 + 100 * ant1pow) / 100);
            byte btOutputPower = (byte)uhf5outpouwer;
            RFIDOperate.mReader.setOutputPower(RFIDOperate.m_curReaderSetting.btReadId, btOutputPower);
            RFIDOperate.m_curReaderSetting.btAryOutputPower = new byte[]{btOutputPower};
        } else if (moduleType == Module.UHF006) {
            short uhf6outpouwer = (short)((500 + 100 * ant1pow) / 100);
            boolean setPower = uhf6.setOutputPower(uhf6outpouwer);
            isSuc = setPower;
            b.putBoolean("isSetPower", isSuc);
            m.setData(b);
            mOtherHandler.sendMessage(m);
        }
    }

    public static void getAntReg() {
        Message m = new Message();
        Bundle b = new Bundle();
        if (moduleType == Module.UHF001) {
            int index = -1;
            UHF001.getReg();
            if (UHF001.er == Reader.READER_ERR.MT_OK_ERR) {
                switch (UHF001.getRegion_Conf[0]) {
                    case RG_PRC: {
                        index = 0;
                        break;
                    }
                    case RG_EU: {
                        index = 2;
                        break;
                    }
                    case RG_EU2: {
                        index = 2;
                        break;
                    }
                    case RG_EU3: {
                        index = 2;
                        break;
                    }
                    case RG_KR: {
                        index = 3;
                        break;
                    }
                    case RG_NA: {
                        index = 1;
                        break;
                    }
                    default: {
                        index = 3;
                    }
                }
            }
            b.putInt("getReg", index);
            m.setData(b);
            mOtherHandler.sendMessage(m);
        } else if (moduleType == Module.UHF005) {
            RFIDOperate.mReader.getFrequencyRegion(RFIDOperate.m_curReaderSetting.btReadId);
        } else if (moduleType == Module.UHF006) {
            int reg = uhf6.getFrequencyRegion();
            if (reg == 0 || reg == 1) {
                reg = 0;
            } else if (reg == 4) {
                reg = 1;
            }
            b.putInt("getReg", reg);
            m.setData(b);
            mOtherHandler.sendMessage(m);
        }
    }

    public static void setAntReg(int Region) {
        if (moduleType == Module.UHF001) {
            Message m = new Message();
            Bundle b = new Bundle();
            switch (Region) {
                case 0: {
                    UHF001.setRegion_Conf = Reader.Region_Conf.RG_PRC;
                    break;
                }
                case 1: {
                    UHF001.setRegion_Conf = Reader.Region_Conf.RG_NA;
                    break;
                }
                case 2: {
                    UHF001.setRegion_Conf = Reader.Region_Conf.RG_EU;
                    break;
                }
                case 3: {
                    UHF001.setRegion_Conf = Reader.Region_Conf.RG_NONE;
                    break;
                }
                default: {
                    UHF001.setRegion_Conf = Reader.Region_Conf.RG_NONE;
                }
            }
            boolean setFre = UHF001.setReg(UHF001.setRegion_Conf);
            if (setFre) {
                Comm.myapp.Rparams.region = Region;
                Comm.myapp.Rparams.frelen = 0;
                b.putBoolean("isSetReg", true);
            } else {
                b.putBoolean("isSetReg", false);
            }
            m.setData(b);
            mOtherHandler.sendMessage(m);
        } else if (moduleType == Module.UHF005) {
            byte btRegion = 0;
            byte btStartFreq = 0;
            byte btEndFreq = 0;
            switch (Region) {
                case 0: {
                    btRegion = 3;
                    btStartFreq = 43;
                    btEndFreq = 53;
                    break;
                }
                case 1: {
                    btRegion = 1;
                    btStartFreq = 7;
                    btEndFreq = 59;
                    break;
                }
                case 2: {
                    btRegion = 2;
                    btStartFreq = 0;
                    btEndFreq = 6;
                    break;
                }
            }
            Log.d((String)"UHF005", (String)" btRegion = 0x01;");
            RFIDOperate.mReader.setFrequencyRegion(RFIDOperate.m_curReaderSetting.btReadId, btRegion, btStartFreq, btEndFreq);
            Log.d((String)"UHF005", (String)("btStartFreq:" + String.valueOf(btStartFreq) + " btEndFreq:" + String.valueOf(btEndFreq)));
            RFIDOperate.m_curReaderSetting.btRegion = btRegion;
            RFIDOperate.m_curReaderSetting.btFrequencyStart = btStartFreq;
            RFIDOperate.m_curReaderSetting.btFrequencyEnd = btEndFreq;
        } else if (moduleType == Module.UHF006) {
            Message m = new Message();
            Bundle b = new Bundle();
            switch (Region) {
                case 0: {
                    Region = 0;
                    break;
                }
                case 1: {
                    Region = 4;
                    break;
                }
                case 2: {
                    Region = 2;
                    break;
                }
                case 3: {
                    Region = 3;
                }
            }
            boolean bo = uhf6.setFrequencyRegion(Region);
            if (bo) {
                b.putBoolean("isSetReg", true);
            } else {
                b.putBoolean("isSetReg", false);
            }
            m.setData(b);
            mOtherHandler.sendMessage(m);
        }
    }

    public static String[] getAntFre(int region) {
        String[] ssf = new String[]{""};
        if (moduleType == Module.UHF001) {
            Reader.HoptableData_ST hdst2 = new Reader.HoptableData_ST(Comm.myapp.Mreader);
            UHF001.er = Comm.myapp.Mreader.ParamGet(Reader.Mtr_Param.MTR_PARAM_FREQUENCY_HOPTABLE, (Object)hdst2);
            if (UHF001.er == Reader.READER_ERR.MT_OK_ERR) {
                int[] tablefre = Comm.Sort(hdst2.htb, hdst2.lenhtb);
                ssf = new String[hdst2.lenhtb];
                for (int i = 0; i < hdst2.lenhtb; ++i) {
                    ssf[i] = String.valueOf(tablefre[i]);
                }
            }
        } else if (moduleType == Module.UHF005) {
            ssf = RFIDOperate.getuhf5Fre(region);
        } else if (moduleType == Module.UHF006) {
            uhf6.getFrequencyRegion();
        }
        return ssf;
    }

    public static String setAntFre() {
        String strR = "";
        return "";
    }

    public static void getSes() {
        char[] GetGen2;
        Message m = new Message();
        Bundle b = new Bundle();
        if (moduleType == Module.UHF001) {
            int[] val2 = new int[]{-1};
            UHF001.getGen2Session(val2);
            if (val2[0] != -1) {
                b.putInt("session", val2[0]);
            }
        } else if (moduleType == Module.UHF005) {
            switch (session) {
                case 0: {
                    b.putInt("session", 0);
                    break;
                }
                case 1: {
                    b.putInt("session", 1);
                    break;
                }
                case 2: {
                    b.putInt("session", 2);
                    break;
                }
                case 3: {
                    b.putInt("session", 3);
                }
            }
        } else if (moduleType == Module.UHF006 && (GetGen2 = Comm.baseTabFragment.mReader.GetGen2()).length > 11) {
            b.putInt("session", (int)GetGen2[11]);
        }
        m.setData(b);
        mOtherHandler.sendMessage(m);
    }

    public static void setSes(int ses) {
        char[] p;
        Message m = new Message();
        Bundle b = new Bundle();
        if (moduleType == Module.UHF001) {
            int[] val = new int[]{-1};
            val[0] = ses;
            UHF001.er = Comm.myapp.Mreader.ParamSet(Reader.Mtr_Param.MTR_PARAM_POTL_GEN2_SESSION, (Object)val);
            if (UHF001.er == Reader.READER_ERR.MT_OK_ERR) {
                Comm.myapp.Rparams.session = val[0];
                b.putBoolean("isSetSes", true);
            } else {
                b.putBoolean("isSetSes", false);
            }
        } else if (moduleType == Module.UHF005) {
            session = ses;
            b.putBoolean("isSetSes", true);
        } else if (moduleType == Module.UHF006 && (p = Comm.baseTabFragment.mReader.GetGen2()) != null && p.length >= 14) {
            char target = p[0];
            char action = p[1];
            char t = p[2];
            char q = p[3];
            char startQ = p[4];
            char minQ = p[5];
            char maxQ = p[6];
            char dr = p[7];
            char coding = p[8];
            char p1 = p[9];
            char Sel = p[10];
            char Session = p[11];
            int sess = ses;
            char g = p[12];
            char linkFrequency = p[13];
            if (Comm.baseTabFragment.mReader.SetGen2((int)target, (int)action, (int)t, (int)q, (int)startQ, (int)minQ, (int)maxQ, (int)dr, (int)coding, (int)p1, (int)Sel, sess, (int)g, (int)linkFrequency)) {
                b.putBoolean("isSetSes", true);
            } else {
                b.putBoolean("isSetSes", false);
            }
        }
        m.setData(b);
        mOtherHandler.sendMessage(m);
    }

    public static void getQValue() {
        Message m = new Message();
        Bundle b = new Bundle();
        int[] val = new int[]{-1};
        if (moduleType == Module.UHF001) {
            if (Comm.myapp.Rparams.qv < 0) {
                UHF001.getgen2q(val);
                b.putInt("Q", val[0]);
                Qvalue = val[0];
            } else {
                b.putInt("Q", Comm.myapp.Rparams.qv);
            }
        } else if (moduleType == Module.UHF005) {
            b.putInt("Q", val[0]);
            Qvalue = val[0];
        } else if (moduleType == Module.UHF006) {
            b.putInt("Q", val[0]);
            Qvalue = val[0];
        }
        m.setData(b);
        mOtherHandler.sendMessage(m);
    }

    public static void setQValue(int Q) {
        Message m = new Message();
        Bundle b = new Bundle();
        if (moduleType == Module.UHF001) {
            int[] val = new int[]{-1};
            val[0] = Q;
            UHF001.er = Comm.myapp.Mreader.ParamSet(Reader.Mtr_Param.MTR_PARAM_POTL_GEN2_Q, (Object)val);
            if (UHF001.er == Reader.READER_ERR.MT_OK_ERR) {
                Comm.myapp.Rparams.qv = val[0];
                b.putInt("isSetQ", 1);
            } else {
                b.putInt("isSetQ", 0);
            }
        } else if (moduleType == Module.UHF005) {
            b.putInt("isSetQ", -1);
        } else if (moduleType == Module.UHF006) {
            try {
                char[] p = Comm.baseTabFragment.mReader.GetGen2();
                if (p != null && p.length >= 14) {
                    char target = p[0];
                    char action = p[1];
                    char t = p[2];
                    char qv = p[3];
                    int startQ = p[4];
                    char minQ = p[5];
                    char maxQ = p[6];
                    char dr = p[7];
                    char coding = p[8];
                    char p1 = p[9];
                    char Sel = p[10];
                    char Session = p[11];
                    char g = p[12];
                    char linkFrequency = p[13];
                    if (Q == 0) {
                        qv = '\u0001';
                    } else if (Q == 1) {
                        qv = '\u0000';
                        startQ = Q - 1;
                    }
                    if (Comm.baseTabFragment.mReader.SetGen2((int)target, (int)action, (int)t, (int)qv, startQ, (int)minQ, (int)maxQ, (int)dr, (int)coding, (int)p1, (int)Sel, (int)Session, (int)g, (int)linkFrequency)) {
                        // empty if block
                    }
                    b.putInt("isSetQ", -1);
                    Log.d((String)"UHFREAD", (String)("Q:" + String.valueOf(Q)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.d((String)"UHFREAD", (String)("e:" + e.getMessage()));
            }
        }
        m.setData(b);
        mOtherHandler.sendMessage(m);
    }

    public static int getRunTime() {
        int RunTime = -1;
        String strWaitTime = "";
        try {
            if (moduleType == Module.UHF001) {
                RunTime = Comm.myapp.Rparams.readtime;
            } else if (moduleType == Module.UHF006 || moduleType == Module.UHF005) {
                RunTime = -1;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            RunTime = 0;
        }
        return RunTime;
    }

    public static int setRunTime(String strRunTime) {
        int rel = -1;
        try {
            if (moduleType == Module.UHF001) {
                String strruntime = strRunTime;
                int runtime = Integer.parseInt(strruntime);
                int i = strruntime.length();
                while (--i >= 0) {
                    if (Character.isDigit(strruntime.charAt(i))) continue;
                    rel = 0;
                }
                Comm.myapp.Rparams.readtime = runtime;
                rel = 1;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            rel = 0;
        }
        return rel;
    }

    public static String getDeviceNo() {
        String strSERIAL = "";
        try {
            strSERIAL = Build.SERIAL;
            strSERIAL = strSERIAL + strModel;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            strSERIAL = strModel;
        }
        return strSERIAL;
    }

    public static void getTemperature() {
        try {
            String strTemperature = "";
            Message msg = new Message();
            Bundle b = new Bundle();
            if (moduleType == Module.UHF001 && !strModel.equals("F001")) {
                Log.d((String)"UHF", (String)("UHF001 strModel:" + strModel));
                int[] val = new int[]{0};
                UHF001.er = Comm.myapp.Mreader.ParamGet(Reader.Mtr_Param.MTR_PARAM_RF_TEMPERATURE, (Object)val);
                if (UHF001.er == Reader.READER_ERR.MT_OK_ERR) {
                    strTemperature = String.valueOf(val[0]) + "\u2103";
                }
                Log.d((String)"UHF", (String)("UHF001 strTemperature:" + strTemperature));
                b.putString("Tem", strTemperature);
                msg.setData(b);
                mOtherHandler.sendMessage(msg);
            } else if (moduleType == Module.UHF005) {
                rfidOperate.getTemperature();
            } else if (moduleType == Module.UHF006) {
                int t = Comm.baseTabFragment.mReader.getTemperature();
                strTemperature = String.valueOf(t) + "\u2103";
                Log.d((String)"UHF", (String)("UHF006 strTemperature:" + strTemperature));
                b.putString("Tem", strTemperature);
                msg.setData(b);
                mOtherHandler.sendMessage(msg);
            } else {
                strTemperature = "0";
                b.putString("Tem", strTemperature);
                msg.setData(b);
                mOtherHandler.sendMessage(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"UHF", (String)("Exception" + e.getMessage()));
        }
    }

    public static boolean UHF005connect(SerialPortCallback callback) {
        Log.d((String)tagUHF5, (String)"initUHF_true");
        try {
            try {
                rfidOperate = new RFIDOperate();
                rfidOperate.onCreate(context, "30");
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            Log.d((String)tagUHF5, (String)"connect");
            comm_callback = callback;
            ReaderHelper.mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
            itent.addAction("com.reader.helper.writeLog");
            itent.addAction("com.reader.helper.refresh.readerSetting");
            itent.addAction("com.reader.helper.refresh.inventoryReal");
            itent.addAction("com.reader.helper.refresh.fastSwitch");
            itent.addAction("com.reader.helper.refresh.inventory");
            itent.addAction("com.reader.helper.refresh.inventoryReal");
            itent.addAction("com.reader.helper.refresh.ISO180006B");
            itent.addAction("com.reader.helper.refresh.operateTag");
            itent.addAction("com.reader.helper.refresh.readerSetting");
            itent.addAction("com.reader.helper.writeData");
            ReaderHelper.mLocalBroadcastManager.registerReceiver(Comm.rfidOperate.mRecv, itent);
            version = RFIDOperate.mReader.getFirmwareVersion(RFIDOperate.m_curReaderSetting.btReadId);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)tagUHF5, (String)("Erro:" + e.toString()));
            return false;
        }
        return true;
    }

    public static int SortGroup(RadioGroup rg) {
        int check1 = rg.getCheckedRadioButtonId();
        if (check1 != -1) {
            for (int i = 0; i < rg.getChildCount(); ++i) {
                View vi = rg.getChildAt(i);
                int vv = vi.getId();
                if (check1 != vv) continue;
                return i;
            }
            return -1;
        }
        return check1;
    }

    public static int[] Sort(int[] array, int len) {
        int tmpIntValue = 0;
        for (int xIndex = 0; xIndex < len; ++xIndex) {
            for (int yIndex = 0; yIndex < len; ++yIndex) {
                if (array[xIndex] >= array[yIndex]) continue;
                tmpIntValue = array[xIndex];
                array[xIndex] = array[yIndex];
                array[yIndex] = tmpIntValue;
            }
        }
        return array;
    }

    public static int[] CollectionTointArray(List list) {
        Iterator itor = list.iterator();
        int[] backdata = new int[list.size()];
        int i = 0;
        while (itor.hasNext()) {
            backdata[i++] = (Integer)itor.next();
        }
        return backdata;
    }

    public static void Str2Hex(String buf, int len, byte[] hexbuf) {
        String chex = "0123456789ABCDEF";
        if (len % 2 == 0) {
            for (int i = 0; i < len; i += 2) {
                byte hnx = (byte)chex.indexOf(buf.toUpperCase().substring(i, i + 1));
                byte lnx = (byte)chex.indexOf(buf.toUpperCase().substring(i + 1, i + 2));
                hexbuf[i / 2] = (byte)(hnx << 4 & 0xFF | lnx & 0xFF);
            }
        }
    }

    public static void Hex2Str(byte[] buf, int len, char[] out) {
        char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < len; ++i) {
            out[i * 2] = hexc[(buf[i] & 0xFF) / 16];
            out[i * 2 + 1] = hexc[(buf[i] & 0xFF) % 16];
        }
    }

    public static void playSound() {
        soundPool.play(1, 1.0f, 1.0f, 0, 0, 1.0f);
    }

    static {
        moduleType = null;
        COM = "/dev/ttyHSL0";
        Baudrate = 115200;
        rfidSleep = 50;
        rfidRunTime = 100;
        session = 0;
        btTarget = 0;
        itent = new IntentFilter();
        lsTagList = new ArrayList<InventoryBuffer.InventoryTagMap>();
        tagListSize = 0;
        ReadCnt = 0;
        mPos1 = -1;
        mPos2 = -1;
        strPwd = "";
        isQuick = false;
        tag = null;
        tagcnt = new int[1];
        LB = new ArrayList<Byte>();
        Ltis = null;
        tagUHF1 = "tagUHF1";
        tagUHF5 = "UHF5";
        version = 0;
        ant = 0;
        Qvalue = 0;
        strModel = "";
        repeatSound = true;
        baseTabFragment = new BaseTabFragmentActivity();
    }

    public static enum runType {
        MT_HARDWARE_TOO_MANY_RESET,
        MT_HARDWARE_SUCCEED,
        MT_HARDWARE_FAILS;

    }

    public static enum Module {
        UHF001,
        UHF002,
        UHF003,
        UHF005,
        UHF006;

    }

    public static enum operateType {
        nullOperate,
        getAntCheck,
        setAntCheck,
        getPower,
        setPower,
        getReg,
        setReg,
        getFre,
        setFre,
        getQ,
        setQ,
        getSession,
        setSession,
        getTem,
        readOpe,
        writeOpe,
        writeepcOpe,
        lockOpe;

    }

    static enum DeviceType {
        supion_S_3,
        supion_S_4,
        supion_M_3,
        supion_M_4,
        supion_Y_4;

    }

    public static interface SerialPortCallback {
        public void onReceive(String var1, int var2);
    }
}

