/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.uhf.UHF1Function;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;

public class ScreenListener {
    private Context mContext;
    private ScreenBroadcastReceiver mScreenReceiver;
    private ScreenStateListener mScreenStateListener;

    public ScreenListener(Context context) {
        this.mContext = context;
        this.mScreenReceiver = new ScreenBroadcastReceiver();
    }

    public void begin(ScreenStateListener listener) {
        this.mScreenStateListener = listener;
        this.registerListener();
        this.getScreenState();
    }

    private void getScreenState() {
        PowerManager manager = (PowerManager)this.mContext.getSystemService("power");
        if (manager.isScreenOn()) {
            if (this.mScreenStateListener != null) {
                this.mScreenStateListener.onScreenOn();
            }
        } else if (this.mScreenStateListener != null) {
            this.mScreenStateListener.onScreenOff();
        }
    }

    public void unregisterListener() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mScreenReceiver);
    }

    private void registerListener() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        this.mContext.registerReceiver((BroadcastReceiver)this.mScreenReceiver, filter);
    }

    public static interface ScreenStateListener {
        public void onScreenOn();

        public void onScreenOff();
    }

    private class ScreenBroadcastReceiver
    extends BroadcastReceiver {
        private String action = null;

        private ScreenBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            this.action = intent.getAction();
            if ("android.intent.action.SCREEN_ON".equals(this.action)) {
                ScreenListener.this.mScreenStateListener.onScreenOn();
            } else if ("android.intent.action.SCREEN_OFF".equals(this.action)) {
                ScreenListener.this.mScreenStateListener.onScreenOff();
            } else if ("android.intent.action.USER_PRESENT".equals(this.action)) {
                // empty if block
            }
        }
    }
}

