/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.uhf.UHF5;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Vibrator;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.uhf.uhf.Common.Comm;
import com.uhf.uhf.Common.InventoryBuffer;
import com.uhf.uhf.UHF5.UHF5Application;
import com.uhf.uhf.UHF5Base.ReaderBase;
import com.uhf.uhf.UHF5Base.StringTool;
import com.uhf.uhf.UHF5helper.ISO180006BOperateTagBuffer;
import com.uhf.uhf.UHF5helper.OperateTagBuffer;
import com.uhf.uhf.UHF5helper.ReaderHelper;
import com.uhf.uhf.UHF5helper.ReaderSetting;
import com.uhf.uhf.serialport.SerialPort;
import com.uhf.uhf.serialport.SerialPortFinder;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;

public class RFIDOperate {
    private String TAG = "RFIDOperate";
    private String scanCode;
    private Vibrator mvibrator;
    private boolean g_mvibrator = true;
    private boolean g_sound = true;
    private MediaPlayer mmediaplayer;
    public static final String CTRL_FILE = "/sys/devices/platform/psam/psam_state";
    private final String dc_power = "dc_power";
    private final String en = "en";
    private final String comstr = "com";
    private final String RootPath = "/sys/devices/platform/uhf/";
    private int[] uants = new int[]{1};
    UHF5Application myapp;
    static int readtime = 50;
    static int sleep = 0;
    static int operaCount = 0;
    static int operadatatype = 0;
    PowerManager pm;
    PowerManager.WakeLock wl;
    Context mContext;
    public static String opwStr;
    public ReaderHelper mReaderHelper;
    public SerialPortFinder mSerialPortFinder;
    public SerialPort mSerialPort = null;
    public static ReaderBase mReader;
    public static ReaderSetting m_curReaderSetting;
    public static InventoryBuffer m_curInventoryBuffer;
    public static OperateTagBuffer m_curOperateTagBuffer;
    public static ISO180006BOperateTagBuffer m_curOperateTagISO18000Buffer;
    public LocalBroadcastManager lbm;
    public Handler mHandler;
    private Handler mLoopHandler = new Handler();
    private Runnable mLoopRunnable = new Runnable(){

        @Override
        public void run() {
            byte btWorkAntenna = RFIDOperate.m_curInventoryBuffer.lAntenna.get(RFIDOperate.m_curInventoryBuffer.nIndexAntenna);
            if (btWorkAntenna < 0) {
                btWorkAntenna = 0;
            }
            mReader.setWorkAntenna(RFIDOperate.m_curReaderSetting.btReadId, btWorkAntenna);
            RFIDOperate.this.mLoopHandler.postDelayed((Runnable)this, (long)Comm.rfidSleep);
        }
    };
    int TagsCountTest = 0;
    int mTagsCount = 0;
    int mtagstotal = 0;
    int TagsTotaltext = 0;
    public final BroadcastReceiver mRecv = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Message msg;
            byte btCmd = intent.getByteExtra("cmd", (byte)0);
            Log.d((String)"UHF5", (String)intent.getAction());
            String strCmd = new String(String.valueOf(btCmd));
            Log.d((String)"UHF5", (String)strCmd);
            if (intent.getAction().equals("com.reader.helper.writeData") && btCmd == 0 && Comm.strModel.length() != 4) {
                Log.d((String)"UHF5", (String)"btCmd == 0 comm_callback");
                Comm.comm_callback.onReceive("0", 0);
            }
            if (intent.getAction().equals("com.reader.helper.refresh.readerSetting") && btCmd == 114) {
                Log.d((String)"UHF5", (String)"GET_FIRMWARE_VERSION  comm_callback");
                String strVersion = String.valueOf(RFIDOperate.m_curReaderSetting.btMajor & 0xFF) + "." + String.valueOf(RFIDOperate.m_curReaderSetting.btMinor & 0xFF);
                Comm.comm_callback.onReceive(strVersion, 0);
            } else if (intent.getAction().equals("com.reader.helper.refresh.inventoryReal")) {
                switch (btCmd) {
                    case -119: 
                    case -117: {
                        RFIDOperate.this.mLoopHandler.removeCallbacks(RFIDOperate.this.mLoopRunnable);
                        RFIDOperate.this.mLoopHandler.postDelayed(RFIDOperate.this.mLoopRunnable, (long)Comm.rfidSleep);
                        RFIDOperate.this.refreshText();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        if (RFIDOperate.this.mReaderHelper.getInventoryFlag()) {
                            RFIDOperate.this.mLoopHandler.removeCallbacks(RFIDOperate.this.mLoopRunnable);
                            RFIDOperate.this.mLoopHandler.postDelayed(RFIDOperate.this.mLoopRunnable, (long)Comm.rfidSleep);
                        } else {
                            RFIDOperate.this.mLoopHandler.removeCallbacks(RFIDOperate.this.mLoopRunnable);
                        }
                        RFIDOperate.this.refreshText();
                    }
                }
            }
            if (intent.getAction().equals("com.reader.helper.refresh.readerSetting") && Comm.opeT == Comm.operateType.getPower) {
                msg = new Message();
                Bundle b = new Bundle();
                if (RFIDOperate.m_curReaderSetting.btAryOutputPower != null) {
                    Comm.uhf5outpouwer = RFIDOperate.m_curReaderSetting.btAryOutputPower[0] & 0xFF;
                    int setSel = (Comm.uhf5outpouwer * 100 + 10 - 500) / 100;
                    opwStr = String.valueOf(Comm.uhf5outpouwer);
                    b.putInt("ant1Power", setSel);
                }
                msg.setData(b);
                Comm.mOtherHandler.sendMessage(msg);
            } else if (intent.getAction().equals("com.reader.helper.refresh.readerSetting") && Comm.opeT == Comm.operateType.setPower || intent.getAction().equals("com.reader.helper.writeData") && Comm.opeT == Comm.operateType.setPower) {
                msg = new Message();
                Bundle b = new Bundle();
                boolean isSuc = false;
                if (RFIDOperate.m_curReaderSetting.btAryOutputPower != null) {
                    opwStr = String.valueOf(Comm.uhf5outpouwer);
                    isSuc = true;
                } else {
                    isSuc = false;
                }
                b.putBoolean("isSetPower", isSuc);
                msg.setData(b);
                Comm.mOtherHandler.sendMessage(msg);
            } else if (intent.getAction().equals("com.reader.helper.refresh.readerSetting") && Comm.opeT == Comm.operateType.getReg) {
                msg = new Message();
                Bundle b = new Bundle();
                switch (RFIDOperate.m_curReaderSetting.btRegion & 0xFF) {
                    case 1: {
                        Comm.mPos1 = (RFIDOperate.m_curReaderSetting.btFrequencyStart & 0xFF) - 43;
                        Comm.mPos2 = (RFIDOperate.m_curReaderSetting.btFrequencyEnd & 0xFF) - 43;
                        b.putInt("getReg", 1);
                        break;
                    }
                    case 2: {
                        Comm.mPos1 = (RFIDOperate.m_curReaderSetting.btFrequencyStart & 0xFF) - 7;
                        Comm.mPos2 = (RFIDOperate.m_curReaderSetting.btFrequencyEnd & 0xFF) - 7;
                        b.putInt("getReg", 2);
                        break;
                    }
                    case 3: {
                        Comm.mPos1 = RFIDOperate.m_curReaderSetting.btFrequencyStart & 0xFF;
                        Comm.mPos2 = RFIDOperate.m_curReaderSetting.btFrequencyEnd & 0xFF;
                        b.putInt("getReg", 0);
                        break;
                    }
                    case 4: {
                        b.putInt("getReg", 3);
                        break;
                    }
                }
                msg.setData(b);
                Comm.mOtherHandler.sendMessage(msg);
            } else if (intent.getAction().equals("com.reader.helper.refresh.readerSetting") && Comm.opeT == Comm.operateType.setReg) {
                msg = new Message();
                Bundle b = new Bundle();
                int i = RFIDOperate.m_curReaderSetting.btRegion & 0xFF;
                Boolean isSetReg = i > 0 && i < 5 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                b.putBoolean("isSetReg", isSetReg.booleanValue());
                msg.setData(b);
                Comm.mOtherHandler.sendMessage(msg);
            } else if (intent.getAction().equals("com.reader.helper.refresh.readerSetting") && Comm.opeT == Comm.operateType.getTem) {
                msg = new Message();
                Bundle b = new Bundle();
                String strTemperature = "";
                strTemperature = RFIDOperate.m_curReaderSetting.btPlusMinus == 0 ? "-" + String.valueOf(RFIDOperate.m_curReaderSetting.btTemperature & 0xFF) + "\u2103" : String.valueOf(RFIDOperate.m_curReaderSetting.btTemperature & 0xFF) + "\u2103";
                Log.d((String)"UHF", (String)("UHF006 strTemperature:" + strTemperature));
                b.putString("Tem", strTemperature);
                msg.setData(b);
                Comm.mOtherHandler.sendMessage(msg);
            } else if (intent.getAction().equals("com.reader.helper.refresh.operateTag") && Comm.opeT == Comm.operateType.readOpe) {
                msg = new Message();
                String strData = "";
                byte[] rdata = new byte[Integer.valueOf(operaCount) * 2];
                char[] out = null;
                if (RFIDOperate.m_curOperateTagBuffer.lsTagList.size() > 0) {
                    strData = RFIDOperate.m_curOperateTagBuffer.lsTagList.get((int)0).strData;
                    Comm.Str2Hex(strData, operaCount, rdata);
                    if (operadatatype == 1) {
                        out = new char[rdata.length];
                        for (int i = 0; i < rdata.length; ++i) {
                            out[i] = (char)rdata[i];
                        }
                        strData = String.valueOf(out);
                    } else if (operadatatype == 2) {
                        try {
                            strData = new String(rdata, "gbk");
                        }
                        catch (UnsupportedEncodingException e) {
                            Log.d((String)Comm.tagUHF1, (String)("readOP err:" + e.getMessage()));
                            e.printStackTrace();
                        }
                    }
                    Bundle b = new Bundle();
                    b.putString("readData", strData);
                    msg.setData(b);
                }
                Comm.mRWLHandler.sendMessage(msg);
            } else if (intent.getAction().equals("com.reader.helper.refresh.operateTag") && Comm.opeT == Comm.operateType.writeOpe) {
                boolean isSucceed = false;
                if (RFIDOperate.m_curOperateTagBuffer.lsTagList.size() > 0) {
                    isSucceed = true;
                }
                Message msg2 = new Message();
                Bundle b = new Bundle();
                b.putBoolean("isWriteSucceed", isSucceed);
                msg2.setData(b);
                Comm.mRWLHandler.sendMessage(msg2);
            } else if (intent.getAction().equals("com.reader.helper.refresh.operateTag") && Comm.opeT == Comm.operateType.lockOpe) {
                boolean isSucceed = false;
                if (RFIDOperate.m_curOperateTagBuffer.lsTagList.size() > 0) {
                    isSucceed = true;
                }
                Message msg3 = new Message();
                Bundle b = new Bundle();
                b.putBoolean("isLockSucceed", isSucceed);
                msg3.setData(b);
                Comm.mRWLHandler.sendMessage(msg3);
            }
        }
    };

    public String getScanCode() {
        return this.scanCode;
    }

    public void setScanCode(String scanCode) {
        this.scanCode = scanCode;
    }

    public void onCreate(Context context, String opwStr) {
        try {
            this.pm = (PowerManager)context.getSystemService("power");
            this.mContext = context;
            RFIDOperate.opwStr = opwStr;
            ReaderHelper.setContext(context);
            this.mSerialPortFinder = new SerialPortFinder();
            if (this.Connect(Comm.COM, Comm.Baudrate)) {
                m_curReaderSetting = this.mReaderHelper.getCurReaderSetting();
                m_curInventoryBuffer = this.mReaderHelper.getCurInventoryBuffer();
                m_curOperateTagBuffer = this.mReaderHelper.getCurOperateTagBuffer();
                m_curOperateTagISO18000Buffer = this.mReaderHelper.getCurOperateTagISO18000Buffer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOpw(String opwStr) {
        byte btOutputPower = 0;
        try {
            btOutputPower = (byte)Integer.parseInt(opwStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mReader.setOutputPower(RFIDOperate.m_curReaderSetting.btReadId, btOutputPower);
        RFIDOperate.m_curReaderSetting.btAryOutputPower = new byte[]{btOutputPower};
    }

    public boolean Connect(String posPort, int posBaud) {
        try {
            this.mSerialPort = new SerialPort(new File(posPort), posBaud, 0);
            Log.d((String)"TAG", (String)("Connect" + posPort));
            try {
                this.mReaderHelper = ReaderHelper.getDefaultHelper();
                this.mReaderHelper.setReader(this.mSerialPort.getInputStream(), this.mSerialPort.getOutputStream());
                mReader = this.mReaderHelper.getReader();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void startScan(int Seeeion, int btTarget, int antNo) {
        try {
            this.mReaderHelper.setReader(this.mSerialPort.getInputStream(), this.mSerialPort.getOutputStream());
            mReader = this.mReaderHelper.getReader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setOpw(opwStr);
        RFIDOperate.m_curInventoryBuffer.lAntenna.add((byte)(antNo & 0xFF));
        RFIDOperate.m_curInventoryBuffer.bLoopInventoryReal = true;
        RFIDOperate.m_curInventoryBuffer.btRepeat = 0;
        String strRepeat = "1";
        RFIDOperate.m_curInventoryBuffer.btRepeat = (byte)Integer.parseInt(strRepeat);
        RFIDOperate.m_curInventoryBuffer.bLoopCustomizedSession = true;
        RFIDOperate.m_curInventoryBuffer.btSession = (byte)(Seeeion & 0xFF);
        RFIDOperate.m_curInventoryBuffer.btTarget = (byte)(btTarget & 0xFF);
        m_curInventoryBuffer.clearInventoryRealResult();
        this.mReaderHelper.setInventoryFlag(true);
        this.mReaderHelper.clearInventoryTotal();
        byte btWorkAntenna = RFIDOperate.m_curInventoryBuffer.lAntenna.get(RFIDOperate.m_curInventoryBuffer.nIndexAntenna);
        if (btWorkAntenna < 0) {
            btWorkAntenna = 0;
        }
        mReader.setWorkAntenna(RFIDOperate.m_curReaderSetting.btReadId, btWorkAntenna);
        RFIDOperate.m_curReaderSetting.btWorkAntenna = btWorkAntenna;
        this.mLoopHandler.removeCallbacks(this.mLoopRunnable);
        this.mLoopHandler.postDelayed(this.mLoopRunnable, (long)Comm.rfidSleep);
    }

    public void stop() {
        this.mReaderHelper.setInventoryFlag(false);
        RFIDOperate.m_curInventoryBuffer.bLoopInventoryReal = false;
        this.mLoopHandler.removeCallbacks(this.mLoopRunnable);
        this.refreshText();
    }

    public void onResume(Context context) {
        if (mReader != null && !mReader.IsAlive()) {
            mReader.StartWait();
        }
    }

    public void refreshText() {
        this.mTagsCount = RFIDOperate.m_curInventoryBuffer.lsTagList.size();
        Comm.lsTagList = RFIDOperate.m_curInventoryBuffer.lsTagList;
        this.mtagstotal = this.mReaderHelper.getInventoryTotal();
        int readCount = this.mtagstotal - this.TagsTotaltext;
        Message m = Message.obtain((Handler)this.mHandler, (int)2);
        Bundle bundle = new Bundle();
        bundle.putInt("readCount", readCount);
        m.setData(bundle);
        this.mHandler.sendMessage(m);
        if (Comm.repeatSound && this.mtagstotal != this.TagsTotaltext) {
            Comm.playSound();
        } else if (!Comm.repeatSound && this.mTagsCount > this.TagsTotaltext) {
            Comm.playSound();
        }
        this.TagsTotaltext = this.mtagstotal;
        this.TagsTotaltext = this.mTagsCount;
    }

    public void getTemperature() {
        mReader.getReaderTemperature(RFIDOperate.m_curReaderSetting.btReadId);
    }

    public void onDestroy(Context context) {
        if (this.lbm != null) {
            this.lbm.unregisterReceiver(this.mRecv);
        }
        this.mLoopHandler.removeCallbacks(this.mLoopRunnable);
    }

    public static boolean setUHF5Parameters() {
        try {
            byte btOutputPower = 0;
            btOutputPower = (byte)Integer.parseInt("30");
            mReader.setOutputPower(RFIDOperate.m_curReaderSetting.btReadId, btOutputPower);
            RFIDOperate.m_curReaderSetting.btAryOutputPower = new byte[]{btOutputPower};
            Comm.session = 1;
            Comm.btTarget = 0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String[] getuhf5Fre(int SelectedItemPosition) {
        float nStart = 0.0f;
        int nloop = 0;
        String[] ssf = null;
        switch (SelectedItemPosition) {
            case 0: {
                nStart = 920.0f;
                ssf = new String[11];
                for (nloop = 0; nloop < 11; ++nloop) {
                    String strTemp;
                    ssf[nloop] = strTemp = String.format("%.2f", Float.valueOf(nStart));
                    nStart += 0.5f;
                }
                break;
            }
            case 1: {
                nStart = 902.0f;
                ssf = new String[53];
                for (nloop = 0; nloop < 53; ++nloop) {
                    String strTemp;
                    ssf[nloop] = strTemp = String.format("%.2f", Float.valueOf(nStart));
                    nStart += 0.5f;
                }
                break;
            }
            case 2: {
                nStart = 865.0f;
                ssf = new String[7];
                for (nloop = 0; nloop < 7; ++nloop) {
                    String strTemp;
                    ssf[nloop] = strTemp = String.format("%.2f", Float.valueOf(nStart));
                    nStart += 0.5f;
                }
                break;
            }
            case 3: {
                nStart = 920.0f;
                ssf[1] = String.valueOf(nStart);
            }
        }
        return ssf;
    }

    public static String uhf5readOp(int ant, int tagBank, String opCount, String startAdd, int datatype) {
        String readRet = "";
        try {
            byte btReadId = -1;
            byte btMemBank = 0;
            byte btWordAdd = 0;
            byte btWordCnt = 0;
            byte[] btAryPassWord = new byte[4];
            operadatatype = datatype;
            operaCount = Integer.parseInt(opCount);
            if (tagBank == 0) {
                btMemBank = 0;
            } else if (tagBank == 1) {
                btMemBank = 1;
            } else if (tagBank == 2) {
                btMemBank = 2;
            } else if (tagBank == 3) {
                btMemBank = 3;
            }
            String[] reslut = StringTool.stringToStringArray(Comm.strPwd.toUpperCase(), 2);
            btAryPassWord = StringTool.stringArrayToByteArray(reslut, 4);
            btWordAdd = (byte)Integer.parseInt(startAdd);
            btWordCnt = (byte)operaCount;
            m_curOperateTagBuffer.clearBuffer();
            mReader.readTag(btReadId, btMemBank, btWordAdd, btWordCnt, btAryPassWord);
            Log.d((String)"readTag", (String)(String.valueOf(btReadId) + " " + String.valueOf(btMemBank) + " " + String.valueOf(btWordAdd) + " " + String.valueOf(btWordCnt)));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            Log.d((String)"readTag", (String)e.getMessage());
            readRet = e.getMessage();
        }
        return readRet;
    }

    public static String uhf5writeOp(int ant, int tagBank, String opCount, String startAdd, int datatype, String strWriteData) {
        String writeRet = "";
        try {
            byte btMemBank = 0;
            byte btWordAdd = 0;
            byte btWordCnt = 0;
            byte[] btAryData = null;
            String[] result = null;
            if (tagBank == 0) {
                btMemBank = 0;
            } else if (tagBank == 1) {
                btMemBank = 1;
            } else if (tagBank == 2) {
                btMemBank = 2;
            } else if (tagBank == 3) {
                btMemBank = 3;
            }
            byte[] btAryPassWord = new byte[4];
            if (Comm.strPwd != null && !Comm.strPwd.equals("")) {
                result = StringTool.stringToStringArray(Comm.strPwd.toUpperCase(), 2);
                btAryPassWord = StringTool.stringArrayToByteArray(result, result.length);
            }
            if (datatype == 0) {
                btAryData = new byte[strWriteData.length() / 2];
                Comm.Str2Hex(strWriteData, strWriteData.length(), btAryData);
            } else if (datatype == 1) {
                String ascstr = strWriteData;
                if (ascstr.length() % 2 != 0) {
                    ascstr = ascstr + "0";
                }
                btAryData = ascstr.getBytes();
            } else if (datatype == 2) {
                try {
                    String ascstr = strWriteData;
                    btAryData = ascstr.getBytes("gbk");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            btWordAdd = (byte)Integer.parseInt(startAdd);
            result = StringTool.stringToStringArray(strWriteData.toUpperCase(), 2);
            btWordCnt = (byte)(result.length / 2 + result.length % 2 & 0xFF);
            m_curOperateTagBuffer.clearBuffer();
            mReader.writeTag(RFIDOperate.m_curReaderSetting.btReadId, btAryPassWord, btMemBank, btWordAdd, btWordCnt, btAryData);
        }
        catch (NumberFormatException e) {
            boolean isSucceed = false;
            Message msg = new Message();
            Bundle b = new Bundle();
            e.printStackTrace();
            Log.d((String)"UHF", (String)("NumberFormatException" + e.getMessage()));
            writeRet = e.getMessage();
            b.putBoolean("isWriteSucceed", isSucceed);
            msg.setData(b);
            Comm.mRWLHandler.sendMessage(msg);
        }
        return writeRet;
    }

    public static String uhf5lockOp(int ant, int tagBank, int LockType) {
        String lockRet = "";
        boolean isSucceed = false;
        Message msg = new Message();
        Bundle b = new Bundle();
        try {
            byte btMemBank = 0;
            byte btLockType = 0;
            byte[] btAryPassWord = null;
            if (tagBank == 0) {
                btMemBank = 4;
            } else if (tagBank == 1) {
                btMemBank = 5;
            } else if (tagBank == 2) {
                btMemBank = 3;
            } else if (tagBank == 3) {
                btMemBank = 2;
            } else if (tagBank == 4) {
                btMemBank = 1;
            }
            if (LockType == 0) {
                btLockType = 0;
            } else if (LockType == 1) {
                btLockType = 1;
            } else if (LockType == 2) {
                btLockType = 3;
            }
            if (Comm.strPwd == null || Comm.strPwd.equals("")) {
                lockRet = "\u8bbf\u95ee\u5bc6\u7801\u4e3a\u7a7a\u6216\u9519\u8bef";
                Log.d((String)"lockTag", (String)lockRet);
                b.putBoolean("isLockSucceed", isSucceed);
                msg.setData(b);
                Comm.mRWLHandler.sendMessage(msg);
                return lockRet;
            }
            String[] reslut = StringTool.stringToStringArray(Comm.strPwd.toUpperCase(), 2);
            btAryPassWord = StringTool.stringArrayToByteArray(reslut, 4);
            m_curOperateTagBuffer.clearBuffer();
            mReader.lockTag(RFIDOperate.m_curReaderSetting.btReadId, btAryPassWord, btMemBank, btLockType);
        }
        catch (Exception e) {
            e.printStackTrace();
            lockRet = e.getMessage();
            Log.d((String)"lockTag", (String)lockRet);
            b.putBoolean("isLockSucceed", isSucceed);
            msg.setData(b);
            Comm.mRWLHandler.sendMessage(msg);
        }
        return lockRet;
    }
}

