/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.uhf.UHF5;

import android.app.Activity;
import android.app.Application;
import android.bluetooth.BluetoothSocket;
import com.uhf.uhf.UHF5.CrashHandler;
import com.uhf.uhf.UHF5helper.ReaderHelper;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class UHFApplication
extends Application {
    private Socket mTcpSocket = null;
    private BluetoothSocket mBtSocket = null;
    private List<Activity> activities = new ArrayList<Activity>();

    public void onCreate() {
        super.onCreate();
        try {
            ReaderHelper.setContext(this.getApplicationContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CrashHandler crashHandler = CrashHandler.getInstance();
        crashHandler.init(this.getApplicationContext());
    }

    public void addActivity(Activity activity) {
        this.activities.add(activity);
    }

    public void onTerminate() {
        super.onTerminate();
        for (Activity activity : this.activities) {
            try {
                activity.finish();
            }
            catch (Exception exception) {}
        }
        try {
            if (this.mTcpSocket != null) {
                this.mTcpSocket.close();
            }
            if (this.mBtSocket != null) {
                this.mBtSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mTcpSocket = null;
        this.mBtSocket = null;
        System.exit(0);
    }

    public void setTcpSocket(Socket socket) {
        this.mTcpSocket = socket;
    }

    public void setBtSocket(BluetoothSocket socket) {
        this.mBtSocket = socket;
    }
}

