/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.uhf.UHF5Base;

import android.util.Log;
import com.uhf.uhf.UHF5Base.Converter;
import com.uhf.uhf.UHF5Base.MessageTran;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class ReaderBase {
    private WaitThread mWaitThread = null;
    private InputStream mInStream = null;
    private OutputStream mOutStream = null;
    private byte[] m_btAryBuffer = new byte[4096];
    private int m_nLength = 0;

    public abstract void onLostConnect();

    public abstract void analyData(MessageTran var1);

    public ReaderBase(InputStream in, OutputStream out) {
        this.mInStream = in;
        this.mOutStream = out;
        this.StartWait();
    }

    public boolean IsAlive() {
        return this.mWaitThread != null && this.mWaitThread.isAlive();
    }

    public void StartWait() {
        this.mWaitThread = new WaitThread();
        this.mWaitThread.start();
    }

    public final void signOut() {
        this.mWaitThread.signOut();
        try {
            this.mInStream.close();
            this.mOutStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void runReceiveDataCallback(byte[] btAryReceiveData) {
        try {
            this.reciveData(btAryReceiveData);
            int nCount = btAryReceiveData.length;
            byte[] btAryBuffer = new byte[nCount + this.m_nLength];
            System.arraycopy(this.m_btAryBuffer, 0, btAryBuffer, 0, this.m_nLength);
            System.arraycopy(btAryReceiveData, 0, btAryBuffer, this.m_nLength, btAryReceiveData.length);
            int nIndex = 0;
            int nMarkIndex = 0;
            for (int nLoop = 0; nLoop < btAryBuffer.length; ++nLoop) {
                if (btAryBuffer.length <= nLoop + 1) continue;
                if (btAryBuffer[nLoop] == -96) {
                    int nLen = btAryBuffer[nLoop + 1] & 0xFF;
                    if (nLoop + 1 + nLen < btAryBuffer.length) {
                        byte[] btAryAnaly = new byte[nLen + 2];
                        System.arraycopy(btAryBuffer, nLoop, btAryAnaly, 0, nLen + 2);
                        MessageTran msgTran = new MessageTran(btAryAnaly);
                        this.analyData(msgTran);
                        nIndex = (nLoop += 1 + nLen) + 1;
                        continue;
                    }
                    nLoop += 1 + nLen;
                    continue;
                }
                nMarkIndex = nLoop;
            }
            if (nIndex < nMarkIndex) {
                nIndex = nMarkIndex + 1;
            }
            if (nIndex < btAryBuffer.length) {
                this.m_nLength = btAryBuffer.length - nIndex;
                Arrays.fill(this.m_btAryBuffer, 0, 4096, (byte)0);
                System.arraycopy(btAryBuffer, nIndex, this.m_btAryBuffer, 0, btAryBuffer.length - nIndex);
            } else {
                this.m_nLength = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reciveData(byte[] btAryReceiveData) {
    }

    public void sendData(byte[] btArySendData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendMessage(byte[] btArySenderData) {
        try {
            OutputStream outputStream = this.mOutStream;
            synchronized (outputStream) {
                this.mOutStream.write(btArySenderData);
            }
        }
        catch (IOException e) {
            this.onLostConnect();
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
        this.sendData(btArySenderData);
        return 0;
    }

    private int sendMessage(byte btReadId, byte btCmd) {
        MessageTran msgTran = new MessageTran(btReadId, btCmd);
        return this.sendMessage(msgTran.getAryTranData());
    }

    private int sendMessage(byte btReadId, byte btCmd, byte[] btAryData) {
        MessageTran msgTran = new MessageTran(btReadId, btCmd, btAryData);
        return this.sendMessage(msgTran.getAryTranData());
    }

    public final int reset(byte btReadId) {
        byte btCmd = 112;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setUartBaudrate(byte btReadId, byte nIndexBaudrate) {
        byte btCmd = 113;
        byte[] btAryData = new byte[]{nIndexBaudrate};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getFirmwareVersion(byte btReadId) {
        byte btCmd = 114;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setReaderAddress(byte btReadId, byte btNewReadId) {
        byte btCmd = 115;
        byte[] btAryData = new byte[]{btNewReadId};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setWorkAntenna(byte btReadId, byte btWorkAntenna) {
        byte btCmd = 116;
        byte[] btAryData = new byte[]{btWorkAntenna};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getWorkAntenna(byte btReadId) {
        byte btCmd = 117;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setOutputPower(byte btReadId, byte btOutputPower) {
        byte btCmd = 118;
        byte[] btAryData = new byte[]{btOutputPower};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setOutputPower(byte btReadId, byte btPower1, byte btPower2, byte btPower3, byte btPower4) {
        byte btCmd = 118;
        byte[] btAryData = new byte[]{btPower1, btPower2, btPower3, btPower4};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getOutputPower(byte btReadId) {
        byte btCmd = 119;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setFrequencyRegion(byte btReadId, byte btRegion, byte btStartRegion, byte btEndRegion) {
        byte btCmd = 120;
        byte[] btAryData = new byte[]{btRegion, btStartRegion, btEndRegion};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setUserDefineFrequency(byte btReadId, byte btFreqInterval, byte btChannelQuantity, int nStartFreq) {
        byte btCmd = 120;
        byte[] btAryFreq = new byte[3];
        byte[] btAryData = new byte[6];
        btAryFreq = Converter.getBytes(nStartFreq, 1);
        btAryData[0] = 4;
        btAryData[1] = btFreqInterval;
        btAryData[2] = btChannelQuantity;
        btAryData[3] = btAryFreq[2];
        btAryData[4] = btAryFreq[1];
        btAryData[5] = btAryFreq[0];
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getFrequencyRegion(byte btReadId) {
        byte btCmd = 121;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setBeeperMode(byte btReadId, byte btMode) {
        byte btCmd = 122;
        byte[] btAryData = new byte[]{btMode};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getReaderTemperature(byte btReadId) {
        byte btCmd = 123;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int readGpioValue(byte btReadId) {
        byte btCmd = 96;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int writeGpioValue(byte btReadId, byte btChooseGpio, byte btGpioValue) {
        byte btCmd = 97;
        byte[] btAryData = new byte[]{btChooseGpio, btGpioValue};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setAntConnectionDetector(byte btReadId, byte btDetectorStatus) {
        byte btCmd = 98;
        byte[] btAryData = new byte[]{btDetectorStatus};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getAntConnectionDetector(byte btReadId) {
        byte btCmd = 99;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setTemporaryOutputPower(byte btReadId, byte btRfPower) {
        byte btCmd = 102;
        byte[] btAryData = new byte[]{btRfPower};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setReaderIdentifier(byte btReadId, byte[] btAryIdentifier) {
        byte btCmd = 103;
        int nResult = this.sendMessage(btReadId, btCmd, btAryIdentifier);
        return nResult;
    }

    public final int getReaderIdentifier(byte btReadId) {
        byte btCmd = 104;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int setRfLinkProfile(byte btReadId, byte btProfile) {
        byte btCmd = 105;
        byte[] btAryData = new byte[]{btProfile};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getRfLinkProfile(byte btReadId) {
        byte btCmd = 106;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int getRfPortReturnLoss(byte btReadId, byte btFrequency) {
        byte btCmd = 126;
        byte[] btAryData = new byte[]{btFrequency};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int inventory(byte btReadId, byte btRepeat) {
        byte btCmd = -128;
        byte[] btAryData = new byte[]{btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int readTag(byte btReadId, byte btMemBank, byte btWordAdd, byte btWordCnt, byte[] btAryPassWord) {
        byte btCmd = -127;
        byte[] btAryData = null;
        if (btAryPassWord == null || btAryPassWord.length < 4) {
            btAryPassWord = null;
            btAryData = new byte[3];
        } else {
            btAryData = new byte[7];
        }
        btAryData[0] = btMemBank;
        btAryData[1] = btWordAdd;
        btAryData[2] = btWordCnt;
        if (btAryPassWord != null) {
            System.arraycopy(btAryPassWord, 0, btAryData, 3, btAryPassWord.length);
        }
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        Log.d((String)"readTag", (String)(String.valueOf(btReadId) + " " + String.valueOf(btCmd) + " " + String.valueOf(btMemBank) + " " + String.valueOf(btWordAdd) + " " + String.valueOf(btWordCnt)));
        return nResult;
    }

    public final int writeTag(byte btReadId, byte[] btAryPassWord, byte btMemBank, byte btWordAdd, byte btWordCnt, byte[] btAryData) {
        byte btCmd = -126;
        byte[] btAryBuffer = new byte[btAryData.length + 7];
        System.arraycopy(btAryPassWord, 0, btAryBuffer, 0, btAryPassWord.length);
        btAryBuffer[4] = btMemBank;
        btAryBuffer[5] = btWordAdd;
        btAryBuffer[6] = btWordCnt;
        System.arraycopy(btAryData, 0, btAryBuffer, 7, btAryData.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryBuffer);
        return nResult;
    }

    public final int lockTag(byte btReadId, byte[] btAryPassWord, byte btMemBank, byte btLockType) {
        byte btCmd = -125;
        byte[] btAryData = new byte[6];
        System.arraycopy(btAryPassWord, 0, btAryData, 0, btAryPassWord.length);
        btAryData[4] = btMemBank;
        btAryData[5] = btLockType;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int killTag(byte btReadId, byte[] btAryPassWord) {
        byte btCmd = -124;
        byte[] btAryData = new byte[4];
        System.arraycopy(btAryPassWord, 0, btAryData, 0, btAryPassWord.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setAccessEpcMatch(byte btReadId, byte btEpcLen, byte[] btAryEpc) {
        byte btCmd = -123;
        int nLen = (btEpcLen & 0xFF) + 2;
        byte[] btAryData = new byte[nLen];
        btAryData[0] = 0;
        btAryData[1] = btEpcLen;
        System.arraycopy(btAryEpc, 0, btAryData, 2, btAryEpc.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int cancelAccessEpcMatch(byte btReadId) {
        byte btCmd = -123;
        byte[] btAryData = new byte[]{1};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getAccessEpcMatch(byte btReadId) {
        byte btCmd = -122;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int realTimeInventory(byte btReadId, byte btRepeat) {
        byte btCmd = -119;
        byte[] btAryData = new byte[]{btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int fastSwitchAntInventory(byte btReadId, byte btA, byte btStayA, byte btB, byte btStayB, byte btC, byte btStayC, byte btD, byte btStayD, byte btInterval, byte btRepeat) {
        byte btCmd = -118;
        byte[] btAryData = new byte[]{btA, btStayA, btB, btStayB, btC, btStayC, btD, btStayD, btInterval, btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int customizedSessionTargetInventory(byte btReadId, byte btSession, byte btTarget, byte btRepeat) {
        byte btCmd = -117;
        byte[] btAryData = new byte[]{btSession, btTarget, btRepeat};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int setImpinjFastTid(byte btReadId, boolean blnOpen, boolean blnSave) {
        byte btCmd = blnSave ? (byte)-115 : -116;
        byte[] btAryData = new byte[]{(byte)(blnOpen ? 141 : 0)};
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getImpinjFastTid(byte btReadId) {
        byte btCmd = -114;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int iso180006BInventory(byte btReadId) {
        byte btCmd = -80;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int iso180006BReadTag(byte btReadId, byte[] btAryUID, byte btWordAdd, byte btWordCnt) {
        byte btCmd = -79;
        int nLen = btAryUID.length + 2;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[nLen - 2] = btWordAdd;
        btAryData[nLen - 1] = btWordCnt;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int iso180006BWriteTag(byte btReadId, byte[] btAryUID, byte btWordAdd, byte btWordCnt, byte[] btAryBuffer) {
        byte btCmd = -78;
        int nLen = btAryUID.length + 2 + btAryBuffer.length;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[btAryUID.length] = btWordAdd;
        btAryData[btAryUID.length + 1] = btWordCnt;
        System.arraycopy(btAryBuffer, 0, btAryData, btAryUID.length + 2, btAryBuffer.length);
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int iso180006BLockTag(byte btReadId, byte[] btAryUID, byte btWordAdd) {
        byte btCmd = -77;
        int nLen = btAryUID.length + 1;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[nLen - 1] = btWordAdd;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int iso180006BQueryLockTag(byte btReadId, byte[] btAryUID, byte btWordAdd) {
        byte btCmd = -76;
        int nLen = btAryUID.length + 1;
        byte[] btAryData = new byte[nLen];
        System.arraycopy(btAryUID, 0, btAryData, 0, btAryUID.length);
        btAryData[nLen - 1] = btWordAdd;
        int nResult = this.sendMessage(btReadId, btCmd, btAryData);
        return nResult;
    }

    public final int getInventoryBuffer(byte btReadId) {
        byte btCmd = -112;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int getAndResetInventoryBuffer(byte btReadId) {
        byte btCmd = -111;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int getInventoryBufferTagCount(byte btReadId) {
        byte btCmd = -110;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int resetInventoryBuffer(byte btReadId) {
        byte btCmd = -109;
        int nResult = this.sendMessage(btReadId, btCmd);
        return nResult;
    }

    public final int sendBuffer(byte[] btAryBuf) {
        int nResult = this.sendMessage(btAryBuf);
        return nResult;
    }

    private class WaitThread
    extends Thread {
        private boolean mShouldRunning = true;

        @Override
        public void run() {
            byte[] btAryBuffer = new byte[4096];
            while (this.mShouldRunning) {
                try {
                    int nLenRead = ReaderBase.this.mInStream.read(btAryBuffer);
                    if (nLenRead <= 0) continue;
                    byte[] btAryReceiveData = new byte[nLenRead];
                    System.arraycopy(btAryBuffer, 0, btAryReceiveData, 0, nLenRead);
                    ReaderBase.this.runReceiveDataCallback(btAryReceiveData);
                }
                catch (IOException e) {
                    ReaderBase.this.onLostConnect();
                    return;
                }
                catch (Exception e) {
                    ReaderBase.this.onLostConnect();
                    return;
                }
            }
        }

        public void signOut() {
            this.mShouldRunning = false;
            this.interrupt();
        }
    }
}

