/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.uhf.UHF5helper;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.support.v4.content.LocalBroadcastManager;
import com.uhf.uhf.Common.InventoryBuffer;
import com.uhf.uhf.UHF5Base.CMD;
import com.uhf.uhf.UHF5Base.ERROR;
import com.uhf.uhf.UHF5Base.MessageTran;
import com.uhf.uhf.UHF5Base.ReaderBase;
import com.uhf.uhf.UHF5Base.StringTool;
import com.uhf.uhf.UHF5helper.ISO180006BOperateTagBuffer;
import com.uhf.uhf.UHF5helper.OperateTagBuffer;
import com.uhf.uhf.UHF5helper.ReaderSetting;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public class ReaderHelper {
    public static final String BROADCAST_ON_LOST_CONNECT = "com.reader.helper.onLostConnect";
    public static final String BROADCAST_WRITE_DATA = "com.reader.helper.writeData";
    public static final String BROADCAST_WRITE_LOG = "com.reader.helper.writeLog";
    public static final String BROADCAST_REFRESH_READER_SETTING = "com.reader.helper.refresh.readerSetting";
    public static final String BROADCAST_REFRESH_INVENTORY = "com.reader.helper.refresh.inventory";
    public static final String BROADCAST_REFRESH_INVENTORY_REAL = "com.reader.helper.refresh.inventoryReal";
    public static final String BROADCAST_REFRESH_FAST_SWITCH = "com.reader.helper.refresh.fastSwitch";
    public static final String BROADCAST_REFRESH_OPERATE_TAG = "com.reader.helper.refresh.operateTag";
    public static final String BROADCAST_REFRESH_ISO18000_6B = "com.reader.helper.refresh.ISO180006B";
    public static LocalBroadcastManager mLocalBroadcastManager = null;
    public static final byte INVENTORY_ERR = 0;
    public static final byte INVENTORY_ERR_END = 1;
    public static final byte INVENTORY_END = 2;
    public static final int WRITE_LOG = 16;
    public static final int REFRESH_READER_SETTING = 17;
    public static final int REFRESH_INVENTORY = 18;
    public static final int REFRESH_INVENTORY_REAL = 19;
    public static final int REFRESH_FAST_SWITCH = 20;
    public static final int REFRESH_OPERATE_TAG = 21;
    public static final int REFRESH_ISO18000_6B = 21;
    public static final int LOST_CONNECT = 32;
    private static ReaderBase mReader;
    private static Context mContext;
    private static ReaderHelper mReaderHelper;
    public static ReaderSetting m_curReaderSetting;
    public static InventoryBuffer m_curInventoryBuffer;
    public static OperateTagBuffer m_curOperateTagBuffer;
    public static ISO180006BOperateTagBuffer m_curOperateTagISO18000Buffer;
    private boolean m_bInventory = false;
    private boolean m_bISO6BContinue = false;
    private int m_nTotal = 0;

    public ReaderHelper() {
        m_curReaderSetting = new ReaderSetting();
        m_curInventoryBuffer = new InventoryBuffer();
        m_curOperateTagBuffer = new OperateTagBuffer();
        m_curOperateTagISO18000Buffer = new ISO180006BOperateTagBuffer();
    }

    public static void setContext(Context context) throws Exception {
        mContext = context;
        mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)mContext);
        mReaderHelper = new ReaderHelper();
    }

    public static ReaderHelper getDefaultHelper() throws Exception {
        if (mReaderHelper == null || mContext == null) {
            throw new NullPointerException("mReaderHelper Or mContext is Null!");
        }
        return mReaderHelper;
    }

    public void setInventoryFlag(boolean flag) {
        this.m_bInventory = flag;
    }

    public boolean getInventoryFlag() {
        return this.m_bInventory;
    }

    public void setISO6BContinue(boolean m_continue) {
        this.m_bISO6BContinue = m_continue;
    }

    public boolean getISO6BContinue() {
        return this.m_bISO6BContinue;
    }

    public int getInventoryTotal() {
        return this.m_nTotal;
    }

    public void setInventoryTotal(int num) {
        this.m_nTotal = num;
    }

    public void clearInventoryTotal() {
        this.m_nTotal = 0;
    }

    public ReaderSetting getCurReaderSetting() {
        return m_curReaderSetting;
    }

    public InventoryBuffer getCurInventoryBuffer() {
        return m_curInventoryBuffer;
    }

    public OperateTagBuffer getCurOperateTagBuffer() {
        return m_curOperateTagBuffer;
    }

    public ISO180006BOperateTagBuffer getCurOperateTagISO18000Buffer() {
        return m_curOperateTagISO18000Buffer;
    }

    private void writeLog(String strLog, int type) {
        Intent itent = new Intent(BROADCAST_WRITE_LOG);
        itent.putExtra("type", type);
        itent.putExtra("log", strLog);
        mLocalBroadcastManager.sendBroadcast(itent);
    }

    private void refreshReaderSetting(byte btCmd, ReaderSetting curReaderSetting) {
        Intent itent = new Intent(BROADCAST_REFRESH_READER_SETTING);
        itent.putExtra("cmd", btCmd);
        mLocalBroadcastManager.sendBroadcast(itent);
    }

    private void refreshInventory(byte btCmd, InventoryBuffer curInventoryBuffer) {
        Intent itent = new Intent(BROADCAST_REFRESH_INVENTORY);
        itent.putExtra("cmd", btCmd);
        mLocalBroadcastManager.sendBroadcast(itent);
    }

    private void refreshInventoryReal(byte btCmd, InventoryBuffer curInventoryBuffer) {
        Intent itent = new Intent(BROADCAST_REFRESH_INVENTORY_REAL);
        itent.putExtra("cmd", btCmd);
        mLocalBroadcastManager.sendBroadcast(itent);
    }

    private void refreshFastSwitch(byte btCmd, InventoryBuffer curInventoryBuffer) {
        Intent itent = new Intent(BROADCAST_REFRESH_FAST_SWITCH);
        itent.putExtra("cmd", btCmd);
        mLocalBroadcastManager.sendBroadcast(itent);
    }

    private void refreshOperateTag(byte btCmd, OperateTagBuffer curOperateTagBuffer) {
        Intent itent = new Intent(BROADCAST_REFRESH_OPERATE_TAG);
        itent.putExtra("cmd", btCmd);
        mLocalBroadcastManager.sendBroadcast(itent);
    }

    private void refreshISO180006B(byte btCmd, ISO180006BOperateTagBuffer curOperateTagISO18000Buffer) {
        Intent itent = new Intent(BROADCAST_REFRESH_ISO18000_6B);
        itent.putExtra("cmd", btCmd);
        mLocalBroadcastManager.sendBroadcast(itent);
        if (this.m_bISO6BContinue && (btCmd == 2 || btCmd == 1)) {
            mReader.iso180006BInventory(ReaderHelper.m_curReaderSetting.btReadId);
        }
    }

    public ReaderBase setReader(InputStream in, OutputStream out) throws Exception {
        if (in == null || out == null) {
            throw new NullPointerException("in Or out is NULL!");
        }
        if (mReader == null) {
            mReader = new ReaderBase(in, out){

                @Override
                public void onLostConnect() {
                    mLocalBroadcastManager.sendBroadcast(new Intent(ReaderHelper.BROADCAST_ON_LOST_CONNECT));
                }

                @Override
                public void analyData(MessageTran msgTran) {
                    mReaderHelper.analyData(msgTran);
                }

                @Override
                public void reciveData(byte[] btAryReceiveData) {
                    String strLog = StringTool.byteArrayToString(btAryReceiveData, 0, btAryReceiveData.length);
                    Intent itent = new Intent(ReaderHelper.BROADCAST_WRITE_DATA);
                    itent.putExtra("type", 16);
                    itent.putExtra("log", strLog);
                    mLocalBroadcastManager.sendBroadcast(itent);
                }

                @Override
                public void sendData(byte[] btArySendData) {
                    String strLog = StringTool.byteArrayToString(btArySendData, 0, btArySendData.length);
                    Intent itent = new Intent(ReaderHelper.BROADCAST_WRITE_DATA);
                    itent.putExtra("type", 17);
                    itent.putExtra("log", strLog);
                    mLocalBroadcastManager.sendBroadcast(itent);
                }
            };
        }
        return mReader;
    }

    public ReaderBase getReader() throws Exception {
        if (mReader == null) {
            throw new NullPointerException("mReader is Null!");
        }
        return mReader;
    }

    private void analyData(MessageTran msgTran) {
        if (msgTran.getPacketType() != -96) {
            return;
        }
        switch (msgTran.getCmd()) {
            case 112: {
                this.processReset(msgTran);
                break;
            }
            case 113: {
                this.processSetUartBaudrate(msgTran);
                break;
            }
            case 114: {
                this.processGetFirmwareVersion(msgTran);
                break;
            }
            case 115: {
                this.processSetReaderAddress(msgTran);
                break;
            }
            case 116: {
                this.processSetWorkAntenna(msgTran);
                break;
            }
            case 117: {
                this.processGetWorkAntenna(msgTran);
                break;
            }
            case 118: {
                this.processSetOutputPower(msgTran);
                break;
            }
            case 119: {
                this.processGetOutputPower(msgTran);
                break;
            }
            case 120: {
                this.processSetFrequencyRegion(msgTran);
                break;
            }
            case 121: {
                this.processGetFrequencyRegion(msgTran);
                break;
            }
            case 122: {
                this.processSetBeeperMode(msgTran);
                break;
            }
            case 123: {
                this.processGetReaderTemperature(msgTran);
                break;
            }
            case 96: {
                this.processReadGpioValue(msgTran);
                break;
            }
            case 97: {
                this.processWriteGpioValue(msgTran);
                break;
            }
            case 98: {
                this.processSetAntConnectionDetector(msgTran);
                break;
            }
            case 99: {
                this.processGetAntConnectionDetector(msgTran);
                break;
            }
            case 102: {
                this.processSetTemporaryOutputPower(msgTran);
                break;
            }
            case 103: {
                this.processSetReaderIdentifier(msgTran);
                break;
            }
            case 104: {
                this.processGetReaderIdentifier(msgTran);
                break;
            }
            case 105: {
                this.processSetRfLinkProfile(msgTran);
                break;
            }
            case 106: {
                this.processGetRfLinkProfile(msgTran);
                break;
            }
            case 126: {
                this.processGetRfPortReturnLoss(msgTran);
                break;
            }
            case -128: {
                this.processInventory(msgTran);
                break;
            }
            case -127: {
                this.processReadTag(msgTran);
                break;
            }
            case -126: {
                this.processWriteTag(msgTran);
                break;
            }
            case -125: {
                this.processLockTag(msgTran);
                break;
            }
            case -124: {
                this.processKillTag(msgTran);
                break;
            }
            case -123: {
                this.processSetAccessEpcMatch(msgTran);
                break;
            }
            case -122: {
                this.processGetAccessEpcMatch(msgTran);
                break;
            }
            case -119: {
                this.processRealTimeInventory(msgTran);
                break;
            }
            case -118: {
                this.processFastSwitchInventory(msgTran);
                break;
            }
            case -117: {
                this.processCustomizedSessionTargetInventory(msgTran);
                break;
            }
            case -116: {
                this.processSetImpinjFastTid(msgTran);
                break;
            }
            case -115: {
                this.processSetAndSaveImpinjFastTid(msgTran);
                break;
            }
            case -114: {
                this.processGetImpinjFastTid(msgTran);
                break;
            }
            case -80: {
                this.processISO180006BInventory(msgTran);
                break;
            }
            case -79: {
                this.processISO180006BReadTag(msgTran);
                break;
            }
            case -78: {
                this.processISO180006BWriteTag(msgTran);
                break;
            }
            case -77: {
                this.processISO180006BLockTag(msgTran);
                break;
            }
            case -76: {
                this.processISO180006BQueryLockTag(msgTran);
                break;
            }
            case -112: {
                this.processGetInventoryBuffer(msgTran);
                break;
            }
            case -111: {
                this.processGetAndResetInventoryBuffer(msgTran);
                break;
            }
            case -110: {
                this.processGetInventoryBufferTagCount(msgTran);
                break;
            }
            case -109: {
                this.processResetInventoryBuffer(msgTran);
                break;
            }
        }
    }

    private void processSet(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            if (btAryData[0] == 16) {
                ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
                this.writeLog(strCmd, 16);
                return;
            }
            strErrorCode = ERROR.format(btAryData[0]);
        } else {
            strErrorCode = "\u03b4\u05aa\ufffd\ufffd\ufffd\ufffd";
        }
        String strLog = strCmd + "\u02a7\ufffd\u0723\ufffd\u02a7\ufffd\ufffd\u052d\ufffd\ufffd " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processReset(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processSetUartBaudrate(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetFirmwareVersion(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 2) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btMajor = btAryData[0];
            ReaderHelper.m_curReaderSetting.btMinor = btAryData[1];
            String strVersion = String.valueOf(ReaderHelper.m_curReaderSetting.btMajor & 0xFF) + "." + String.valueOf(ReaderHelper.m_curReaderSetting.btMinor & 0xFF);
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + " \u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processSetReaderAddress(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processSetWorkAntenna(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strErrorCode = "";
        String strCmd = "\u8bbe\u7f6e\u5de5\u4f5c\u5929\u7ebf\u6210\u529f,\u5f53\u524d\u5de5\u4f5c\u5929\u7ebf: \u5929\u7ebf" + (ReaderHelper.m_curReaderSetting.btWorkAntenna + 1);
        if (btAryData.length == 1) {
            if (btAryData[0] == 16) {
                ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
                this.writeLog(strCmd, 16);
                if (this.m_bInventory) {
                    this.runLoopInventroy();
                }
                return;
            }
            strErrorCode = ERROR.format(btAryData[0]);
        } else {
            strErrorCode = "\u672a\u77e5\u9519\u8bef";
        }
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
        if (this.m_bInventory) {
            ReaderHelper.m_curInventoryBuffer.nCommond = 1;
            ReaderHelper.m_curInventoryBuffer.dtEndInventory = new Date();
            this.runLoopInventroy();
        }
    }

    private void processGetWorkAntenna(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            if (btAryData[0] == 0 || btAryData[0] == 1 || btAryData[0] == 2 || btAryData[0] == 3) {
                ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
                ReaderHelper.m_curReaderSetting.btWorkAntenna = btAryData[0];
                this.refreshReaderSetting(btCmd, m_curReaderSetting);
                this.writeLog(strCmd, 16);
                return;
            }
            strErrorCode = ERROR.format(btAryData[0]);
        } else {
            strErrorCode = "\u672a\u77e5\u9519\u8bef";
        }
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processSetOutputPower(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetOutputPower(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 4 || btAryData.length == 1) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btAryOutputPower = (byte[])btAryData.clone();
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processSetFrequencyRegion(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetFrequencyRegion(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 3) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btRegion = btAryData[0];
            ReaderHelper.m_curReaderSetting.btFrequencyStart = btAryData[1];
            ReaderHelper.m_curReaderSetting.btFrequencyEnd = btAryData[2];
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        if (btAryData.length == 6) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btRegion = btAryData[0];
            ReaderHelper.m_curReaderSetting.btUserDefineFrequencyInterval = btAryData[1];
            ReaderHelper.m_curReaderSetting.btUserDefineChannelQuantity = btAryData[2];
            ReaderHelper.m_curReaderSetting.nUserDefineStartFrequency = (btAryData[3] & 0xFF) * 256 * 256 + (btAryData[4] & 0xFF) * 256 + (btAryData[5] & 0xFF);
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processSetBeeperMode(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetReaderTemperature(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 2) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btPlusMinus = btAryData[0];
            ReaderHelper.m_curReaderSetting.btTemperature = btAryData[1];
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processReadGpioValue(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 2) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btGpio1Value = btAryData[0];
            ReaderHelper.m_curReaderSetting.btGpio2Value = btAryData[1];
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processWriteGpioValue(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processSetAntConnectionDetector(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetAntConnectionDetector(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btAntDetector = btAryData[0];
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processSetTemporaryOutputPower(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processSetReaderIdentifier(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetReaderIdentifier(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 12) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            Arrays.fill(ReaderHelper.m_curReaderSetting.btAryReaderIdentifier, (byte)0);
            System.arraycopy(btAryData, 0, ReaderHelper.m_curReaderSetting.btAryReaderIdentifier, 0, btAryData.length);
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processSetRfLinkProfile(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetRfLinkProfile(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            if ((btAryData[0] & 0xFF) >= 208 && (btAryData[0] & 0xFF) <= 211) {
                ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
                ReaderHelper.m_curReaderSetting.btRfLinkProfile = btAryData[0];
                this.refreshReaderSetting(btCmd, m_curReaderSetting);
                this.writeLog(strCmd, 16);
                return;
            }
            strErrorCode = ERROR.format(btAryData[0]);
        } else {
            strErrorCode = "\u672a\u77e5\u9519\u8bef";
        }
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processGetRfPortReturnLoss(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
            ReaderHelper.m_curReaderSetting.btReturnLoss = btAryData[0];
            this.refreshReaderSetting(btCmd, m_curReaderSetting);
            this.writeLog(strCmd, 16);
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processInventory(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 9) {
            int nTotalRead;
            ReaderHelper.m_curInventoryBuffer.nCurrentAnt = btAryData[0];
            ReaderHelper.m_curInventoryBuffer.nTagCount = (btAryData[1] & 0xFF) * 256 + (btAryData[2] & 0xFF);
            ReaderHelper.m_curInventoryBuffer.nReadRate = (btAryData[3] & 0xFF) * 256 + (btAryData[4] & 0xFF);
            ReaderHelper.m_curInventoryBuffer.nDataCount = nTotalRead = (btAryData[5] & 0xFF) * 256 * 256 * 256 + (btAryData[6] & 0xFF) * 256 * 256 + (btAryData[7] & 0xFF) * 256 + (btAryData[8] & 0xFF);
            ReaderHelper.m_curInventoryBuffer.nTotalRead += nTotalRead;
            ReaderHelper.m_curInventoryBuffer.dtEndInventory = new Date();
            this.refreshInventory(btCmd, m_curInventoryBuffer);
            this.writeLog(strCmd, 16);
            this.runLoopInventroy();
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
        this.refreshInventory((byte)1, m_curInventoryBuffer);
        this.runLoopInventroy();
    }

    private void processReadTag(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = CMD.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
        } else {
            int nLen = btAryData.length;
            int nDataLen = btAryData[nLen - 3] & 0xFF;
            int nEpcLen = (btAryData[2] & 0xFF) - nDataLen - 4;
            String strPC = StringTool.byteArrayToString(btAryData, 3, 2);
            String strEPC = StringTool.byteArrayToString(btAryData, 5, nEpcLen);
            String strCRC = StringTool.byteArrayToString(btAryData, 5 + nEpcLen, 2);
            String strData = StringTool.byteArrayToString(btAryData, 7 + nEpcLen, nDataLen);
            byte btTemp = btAryData[nLen - 2];
            byte btAntId = (byte)((btTemp & 3) + 1);
            int nReadCount = btAryData[nLen - 1] & 0xFF;
            OperateTagBuffer.OperateTagMap tag = new OperateTagBuffer.OperateTagMap();
            tag.strPC = strPC;
            tag.strCRC = strCRC;
            tag.strEPC = strEPC;
            tag.strData = strData;
            tag.nDataLen = nDataLen;
            tag.btAntId = btAntId;
            tag.nReadCount = nReadCount;
            ReaderHelper.m_curOperateTagBuffer.lsTagList.add(tag);
            this.refreshOperateTag(btCmd, m_curOperateTagBuffer);
            this.writeLog(strCmd, 16);
        }
    }

    private void processWriteTag(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        Message msg = new Message();
        Bundle b = new Bundle();
        if (btAryData.length == 1) {
            strErrorCode = CMD.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
            this.refreshOperateTag(btCmd, m_curOperateTagBuffer);
        } else {
            int nLen = btAryData.length;
            int nEpcLen = (btAryData[2] & 0xFF) - 4;
            if (btAryData[nLen - 3] != 16) {
                strErrorCode = CMD.format(btAryData[nLen - 3]);
                String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
                this.writeLog(strLog, 17);
                return;
            }
            String strPC = StringTool.byteArrayToString(btAryData, 3, 2);
            String strEPC = StringTool.byteArrayToString(btAryData, 5, nEpcLen);
            String strCRC = StringTool.byteArrayToString(btAryData, 5 + nEpcLen, 2);
            String strData = "";
            byte btTemp = btAryData[nLen - 2];
            byte btAntId = (byte)((btTemp & 3) + 1);
            int nReadCount = btAryData[nLen - 1] & 0xFF;
            OperateTagBuffer.OperateTagMap tag = new OperateTagBuffer.OperateTagMap();
            tag.strPC = strPC;
            tag.strCRC = strCRC;
            tag.strEPC = strEPC;
            tag.strData = strData;
            tag.nDataLen = 0;
            tag.btAntId = btAntId;
            tag.nReadCount = nReadCount;
            ReaderHelper.m_curOperateTagBuffer.lsTagList.add(tag);
            this.refreshOperateTag(btCmd, m_curOperateTagBuffer);
            this.writeLog(strCmd, 16);
        }
    }

    private void processLockTag(MessageTran msgTran) {
        this.processWriteTag(msgTran);
    }

    private void processKillTag(MessageTran msgTran) {
        this.processWriteTag(msgTran);
    }

    private void processSetAccessEpcMatch(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetAccessEpcMatch(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            if (btAryData[0] == 1) {
                this.writeLog("\u65e0\u5339\u914d\u6807\u7b7e", 17);
                return;
            }
            strErrorCode = ERROR.format(btAryData[0]);
        } else {
            if (btAryData[0] == 0) {
                ReaderHelper.m_curOperateTagBuffer.strAccessEpcMatch = StringTool.byteArrayToString(btAryData, 2, btAryData[1] & 0xFF);
                this.refreshOperateTag(btCmd, m_curOperateTagBuffer);
                this.writeLog(strCmd, 16);
                return;
            }
            strErrorCode = "\u672a\u77e5\u9519\u8bef";
        }
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processRealTimeInventory(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = ERROR.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
            this.refreshInventoryReal((byte)1, m_curInventoryBuffer);
            this.runLoopInventroy();
        } else if (btAryData.length == 7) {
            ReaderHelper.m_curInventoryBuffer.nReadRate = (btAryData[1] & 0xFF) * 256 + (btAryData[2] & 0xFF);
            ReaderHelper.m_curInventoryBuffer.nDataCount = (btAryData[3] & 0xFF) * 256 * 256 * 256 + (btAryData[4] & 0xFF) * 256 * 256 + (btAryData[5] & 0xFF) * 256 + (btAryData[6] & 0xFF);
            this.writeLog(strCmd, 16);
            this.refreshInventoryReal((byte)2, m_curInventoryBuffer);
            this.runLoopInventroy();
        } else {
            ++this.m_nTotal;
            int nLength = btAryData.length;
            int nEpcLength = nLength - 4;
            String strEPC = StringTool.byteArrayToString(btAryData, 3, nEpcLength);
            String strPC = StringTool.byteArrayToString(btAryData, 1, 2);
            String strRSSI = String.valueOf(btAryData[nLength - 1] & 0xFF);
            this.setMaxMinRSSI(btAryData[nLength - 1] & 0xFF);
            byte btTemp = btAryData[0];
            byte btAntId = (byte)((btTemp & 3) + 1);
            ReaderHelper.m_curInventoryBuffer.nCurrentAnt = btAntId & 0xFF;
            byte btFreq = (byte)((btTemp & 0xFF) >> 2);
            String strFreq = this.getFreqString(btFreq);
            InventoryBuffer.InventoryTagMap tag = null;
            Integer findIndex = ReaderHelper.m_curInventoryBuffer.dtIndexMap.get(strEPC);
            if (findIndex == null) {
                tag = new InventoryBuffer.InventoryTagMap();
                tag.strPC = strPC;
                tag.strEPC = strEPC;
                tag.strRSSI = strRSSI;
                tag.nReadCount = 1;
                tag.strFreq = strFreq;
                ReaderHelper.m_curInventoryBuffer.lsTagList.add(tag);
                ReaderHelper.m_curInventoryBuffer.dtIndexMap.put(strEPC, ReaderHelper.m_curInventoryBuffer.lsTagList.size() - 1);
            } else {
                tag = ReaderHelper.m_curInventoryBuffer.lsTagList.get(findIndex);
                tag.strRSSI = strRSSI;
                ++tag.nReadCount;
                tag.strFreq = strFreq;
            }
            ReaderHelper.m_curInventoryBuffer.dtEndInventory = new Date();
            this.refreshInventoryReal(btCmd, m_curInventoryBuffer);
        }
    }

    private void processFastSwitchInventory(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = ERROR.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
            this.refreshFastSwitch((byte)1, m_curInventoryBuffer);
            this.runLoopFastSwitch();
        } else if (btAryData.length == 2) {
            strErrorCode = ERROR.format(btAryData[1]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode + "--\u5929\u7ebf" + ((btAryData[0] & 0xFF) + 1);
            this.writeLog(strLog, 17);
        } else if (btAryData.length == 7) {
            int nSwitchTotal = (btAryData[0] & 0xFF) * 255 * 255 + (btAryData[1] & 0xFF) * 255 + (btAryData[2] & 0xFF);
            int nSwitchTime = (btAryData[3] & 0xFF) * 255 * 255 * 255 + (btAryData[4] & 0xFF) * 255 * 255 + (btAryData[5] & 0xFF) * 255 + (btAryData[6] & 0xFF);
            ReaderHelper.m_curInventoryBuffer.nDataCount = nSwitchTotal;
            ReaderHelper.m_curInventoryBuffer.nCommandDuration = nSwitchTime;
            this.writeLog(strCmd, 16);
            this.refreshFastSwitch((byte)2, m_curInventoryBuffer);
            this.runLoopFastSwitch();
        } else {
            ++this.m_nTotal;
            int nLength = btAryData.length;
            int nEpcLength = nLength - 4;
            String strEPC = StringTool.byteArrayToString(btAryData, 3, nEpcLength);
            String strPC = StringTool.byteArrayToString(btAryData, 1, 2);
            String strRSSI = String.valueOf(btAryData[nLength - 1] & 0xFF);
            this.setMaxMinRSSI(btAryData[nLength - 1] & 0xFF);
            byte btTemp = btAryData[0];
            byte btAntId = (byte)((btTemp & 3) + 1);
            ReaderHelper.m_curInventoryBuffer.nCurrentAnt = btAntId & 0xFF;
            byte btFreq = (byte)((btTemp & 0xFF) >> 2);
            String strFreq = this.getFreqString(btFreq);
            InventoryBuffer.InventoryTagMap tag = null;
            Integer findIndex = ReaderHelper.m_curInventoryBuffer.dtIndexMap.get(strEPC);
            if (findIndex == null) {
                tag = new InventoryBuffer.InventoryTagMap();
                tag.strPC = strPC;
                tag.strEPC = strEPC;
                tag.strRSSI = strRSSI;
                tag.nReadCount = 1;
                tag.strFreq = strFreq;
                tag.nAnt1 = 0;
                tag.nAnt2 = 0;
                tag.nAnt3 = 0;
                tag.nAnt4 = 0;
                switch (btAntId) {
                    case 1: {
                        tag.nAnt1 = 1;
                        break;
                    }
                    case 2: {
                        tag.nAnt2 = 1;
                        break;
                    }
                    case 3: {
                        tag.nAnt3 = 1;
                        break;
                    }
                    case 4: {
                        tag.nAnt4 = 1;
                        break;
                    }
                }
                ReaderHelper.m_curInventoryBuffer.lsTagList.add(tag);
                ReaderHelper.m_curInventoryBuffer.dtIndexMap.put(strEPC, ReaderHelper.m_curInventoryBuffer.lsTagList.size() - 1);
            } else {
                tag = ReaderHelper.m_curInventoryBuffer.lsTagList.get(findIndex);
                tag.strRSSI = strRSSI;
                ++tag.nReadCount;
                tag.strFreq = strFreq;
                switch (btAntId) {
                    case 1: {
                        ++tag.nAnt1;
                        break;
                    }
                    case 2: {
                        ++tag.nAnt2;
                        break;
                    }
                    case 3: {
                        ++tag.nAnt3;
                        break;
                    }
                    case 4: {
                        ++tag.nAnt4;
                        break;
                    }
                }
            }
            ReaderHelper.m_curInventoryBuffer.dtEndInventory = new Date();
            this.refreshFastSwitch(btCmd, m_curInventoryBuffer);
        }
    }

    private void processCustomizedSessionTargetInventory(MessageTran msgTran) {
        this.processRealTimeInventory(msgTran);
    }

    private void processSetImpinjFastTid(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processSetAndSaveImpinjFastTid(MessageTran msgTran) {
        this.processSet(msgTran);
    }

    private void processGetImpinjFastTid(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            if (btAryData[0] == 0 || (btAryData[0] & 0xFF) == 141) {
                ReaderHelper.m_curReaderSetting.btReadId = msgTran.getReadId();
                ReaderHelper.m_curReaderSetting.btMonzaStatus = btAryData[0];
                this.refreshReaderSetting(btCmd, m_curReaderSetting);
                this.writeLog(strCmd, 16);
                return;
            }
            strErrorCode = ERROR.format(btAryData[0]);
        } else {
            strErrorCode = "\u672a\u77e5\u9519\u8bef";
        }
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processISO180006BInventory(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            if ((btAryData[0] & 0xFF) != 255) {
                strErrorCode = ERROR.format(btAryData[0]);
                String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
                this.writeLog(strLog, 17);
                this.refreshISO180006B((byte)1, m_curOperateTagISO18000Buffer);
            }
        } else if (btAryData.length == 9) {
            String strUID = StringTool.byteArrayToString(btAryData, 1, 8);
            ISO180006BOperateTagBuffer.ISO180006BOperateTagMap tag = null;
            Integer findIndex = ReaderHelper.m_curOperateTagISO18000Buffer.dtIndexMap.get(strUID);
            if (findIndex == null) {
                tag = new ISO180006BOperateTagBuffer.ISO180006BOperateTagMap();
                tag.btAntId = btAryData[0];
                tag.strUID = strUID;
                tag.nTotal = 1;
                ReaderHelper.m_curOperateTagISO18000Buffer.lsTagList.add(tag);
                ReaderHelper.m_curOperateTagISO18000Buffer.dtIndexMap.put(strUID, ReaderHelper.m_curOperateTagISO18000Buffer.lsTagList.size() - 1);
            } else {
                tag = ReaderHelper.m_curOperateTagISO18000Buffer.lsTagList.get(findIndex);
                ++tag.nTotal;
            }
            this.refreshISO180006B(btCmd, m_curOperateTagISO18000Buffer);
        } else if (btAryData.length == 2) {
            ReaderHelper.m_curOperateTagISO18000Buffer.nTagCount = btAryData[1] & 0xFF;
            this.refreshISO180006B((byte)2, m_curOperateTagISO18000Buffer);
            this.writeLog(strCmd, 16);
        } else {
            strErrorCode = "\u672a\u77e5\u9519\u8bef";
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
            this.refreshISO180006B((byte)1, m_curOperateTagISO18000Buffer);
        }
    }

    private void processISO180006BReadTag(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = ERROR.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
        } else {
            String strData = StringTool.byteArrayToString(btAryData, 1, btAryData.length - 1);
            ReaderHelper.m_curOperateTagISO18000Buffer.btAntId = btAryData[0];
            ReaderHelper.m_curOperateTagISO18000Buffer.strReadData = strData;
            this.refreshISO180006B(btCmd, m_curOperateTagISO18000Buffer);
            this.writeLog(strCmd, 16);
        }
    }

    private void processISO180006BWriteTag(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = ERROR.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
        } else {
            ReaderHelper.m_curOperateTagISO18000Buffer.btAntId = btAryData[0];
            ReaderHelper.m_curOperateTagISO18000Buffer.btWriteLength = btAryData[1];
            this.refreshISO180006B(btCmd, m_curOperateTagISO18000Buffer);
            String strLog = strCmd + ": \u6210\u529f\u5199\u5165" + (btAryData[1] & 0xFF) + "\u5b57\u8282";
            this.writeLog(strLog, 16);
        }
    }

    private void processISO180006BLockTag(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = ERROR.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
        } else {
            ReaderHelper.m_curOperateTagISO18000Buffer.btAntId = btAryData[0];
            ReaderHelper.m_curOperateTagISO18000Buffer.btStatus = btAryData[1];
            this.refreshISO180006B(btCmd, m_curOperateTagISO18000Buffer);
            String strLog = "";
            switch (btAryData[1] & 0xFF) {
                case 0: {
                    strLog = strCmd + ": \u6210\u529f\u9501\u5b9a";
                    break;
                }
                case 254: {
                    strLog = strCmd + ": \u5df2\u662f\u9501\u5b9a\u72b6\u6001";
                    break;
                }
                case 255: {
                    strLog = strCmd + ": \u65e0\u6cd5\u9501\u5b9a";
                    break;
                }
            }
            this.writeLog(strLog, 16);
        }
    }

    private void processISO180006BQueryLockTag(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = ERROR.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
        } else {
            ReaderHelper.m_curOperateTagISO18000Buffer.btAntId = btAryData[0];
            ReaderHelper.m_curOperateTagISO18000Buffer.btStatus = btAryData[1];
            this.refreshISO180006B(btCmd, m_curOperateTagISO18000Buffer);
            this.writeLog(strCmd, 16);
        }
    }

    private void processGetInventoryBuffer(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            strErrorCode = ERROR.format(btAryData[0]);
            String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
            this.writeLog(strLog, 17);
        } else {
            int nDataLen = btAryData.length;
            int nEpcLen = (btAryData[2] & 0xFF) - 4;
            String strPC = StringTool.byteArrayToString(btAryData, 3, 2);
            String strEPC = StringTool.byteArrayToString(btAryData, 5, nEpcLen);
            String strCRC = StringTool.byteArrayToString(btAryData, 5 + nEpcLen, 2);
            String strRSSI = String.valueOf(btAryData[nDataLen - 3] & 0xFF);
            this.setMaxMinRSSI(btAryData[nDataLen - 3] & 0xFF);
            byte btTemp = btAryData[nDataLen - 2];
            byte btAntId = (byte)((btTemp & 3) + 1);
            int nReadCount = btAryData[nDataLen - 1] & 0xFF;
            InventoryBuffer.InventoryTagMap tag = new InventoryBuffer.InventoryTagMap();
            tag.strPC = strPC;
            tag.strCRC = strCRC;
            tag.strEPC = strEPC;
            tag.btAntId = btAntId;
            tag.strRSSI = strRSSI;
            tag.nReadCount = nReadCount;
            ReaderHelper.m_curInventoryBuffer.lsTagList.add(tag);
            ReaderHelper.m_curInventoryBuffer.dtIndexMap.put(strEPC, ReaderHelper.m_curInventoryBuffer.lsTagList.size() - 1);
            this.refreshInventory(btCmd, m_curInventoryBuffer);
            this.writeLog(strCmd, 16);
        }
    }

    private void processGetAndResetInventoryBuffer(MessageTran msgTran) {
        this.processGetInventoryBuffer(msgTran);
    }

    private void processGetInventoryBufferTagCount(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 2) {
            ReaderHelper.m_curInventoryBuffer.nTagCount = (btAryData[0] & 0xFF) * 256 + (btAryData[1] & 0xFF);
            this.refreshInventory(btCmd, m_curInventoryBuffer);
            String strLog = strCmd + "\uff1a" + String.valueOf(ReaderHelper.m_curInventoryBuffer.nTagCount);
            this.writeLog(strLog, 17);
            return;
        }
        strErrorCode = btAryData.length == 1 ? ERROR.format(btAryData[0]) : "\u672a\u77e5\u9519\u8bef";
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void processResetInventoryBuffer(MessageTran msgTran) {
        byte btCmd = msgTran.getCmd();
        byte[] btAryData = msgTran.getAryData();
        String strCmd = CMD.format(btCmd);
        String strErrorCode = "";
        if (btAryData.length == 1) {
            if (btAryData[0] == 16) {
                this.refreshInventory(btCmd, m_curInventoryBuffer);
                this.writeLog(strCmd, 16);
                return;
            }
            strErrorCode = ERROR.format(btAryData[0]);
        } else {
            strErrorCode = "\u672a\u77e5\u9519\u8bef";
        }
        String strLog = strCmd + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a " + strErrorCode;
        this.writeLog(strLog, 17);
    }

    private void setMaxMinRSSI(int nRSSI) {
        if (ReaderHelper.m_curInventoryBuffer.nMaxRSSI < nRSSI) {
            ReaderHelper.m_curInventoryBuffer.nMaxRSSI = nRSSI;
        }
        if (ReaderHelper.m_curInventoryBuffer.nMinRSSI == 0) {
            ReaderHelper.m_curInventoryBuffer.nMinRSSI = nRSSI;
        } else if (ReaderHelper.m_curInventoryBuffer.nMinRSSI > nRSSI) {
            ReaderHelper.m_curInventoryBuffer.nMinRSSI = nRSSI;
        }
    }

    private String getFreqString(byte btFreq) {
        if (ReaderHelper.m_curReaderSetting.btRegion == 4) {
            float nExtraFrequency = (float)(btFreq & 0xFF) * (float)(ReaderHelper.m_curReaderSetting.btUserDefineFrequencyInterval & 0xFF) * 10.0f;
            float nstartFrequency = (float)(ReaderHelper.m_curReaderSetting.nUserDefineStartFrequency & 0xFF) / 1000.0f;
            float nStart = nstartFrequency + nExtraFrequency / 1000.0f;
            String strTemp = String.format("%.3f", Float.valueOf(nStart));
            return strTemp;
        }
        if ((btFreq & 0xFF) < 7) {
            float nStart = 865.0f + (float)(btFreq & 0xFF) * 0.5f;
            String strTemp = String.format("%.2f", Float.valueOf(nStart));
            return strTemp;
        }
        float nStart = 902.0f + ((float)(btFreq & 0xFF) - 7.0f) * 0.5f;
        String strTemp = String.format("%.2f", Float.valueOf(nStart));
        return strTemp;
    }

    private void runLoopInventroy() {
        if (ReaderHelper.m_curInventoryBuffer.nIndexAntenna < ReaderHelper.m_curInventoryBuffer.lAntenna.size() - 1 || ReaderHelper.m_curInventoryBuffer.nCommond == 0) {
            if (ReaderHelper.m_curInventoryBuffer.nCommond == 0) {
                ReaderHelper.m_curInventoryBuffer.nCommond = 1;
                if (ReaderHelper.m_curInventoryBuffer.bLoopInventoryReal) {
                    if (ReaderHelper.m_curInventoryBuffer.bLoopCustomizedSession) {
                        mReader.customizedSessionTargetInventory(ReaderHelper.m_curReaderSetting.btReadId, ReaderHelper.m_curInventoryBuffer.btSession, ReaderHelper.m_curInventoryBuffer.btTarget, ReaderHelper.m_curInventoryBuffer.btRepeat);
                    } else {
                        mReader.realTimeInventory(ReaderHelper.m_curReaderSetting.btReadId, ReaderHelper.m_curInventoryBuffer.btRepeat);
                    }
                } else if (ReaderHelper.m_curInventoryBuffer.bLoopInventory) {
                    mReader.inventory(ReaderHelper.m_curReaderSetting.btReadId, ReaderHelper.m_curInventoryBuffer.btRepeat);
                }
            } else {
                ReaderHelper.m_curInventoryBuffer.nCommond = 0;
                ++ReaderHelper.m_curInventoryBuffer.nIndexAntenna;
                byte btWorkAntenna = ReaderHelper.m_curInventoryBuffer.lAntenna.get(ReaderHelper.m_curInventoryBuffer.nIndexAntenna);
                mReader.setWorkAntenna(ReaderHelper.m_curReaderSetting.btReadId, btWorkAntenna);
                ReaderHelper.m_curReaderSetting.btWorkAntenna = btWorkAntenna;
            }
        } else if (ReaderHelper.m_curInventoryBuffer.bLoopInventory || ReaderHelper.m_curInventoryBuffer.bLoopInventoryReal) {
            ReaderHelper.m_curInventoryBuffer.nIndexAntenna = 0;
            ReaderHelper.m_curInventoryBuffer.nCommond = 0;
            byte btWorkAntenna = ReaderHelper.m_curInventoryBuffer.lAntenna.get(ReaderHelper.m_curInventoryBuffer.nIndexAntenna);
            mReader.setWorkAntenna(ReaderHelper.m_curReaderSetting.btReadId, btWorkAntenna);
            ReaderHelper.m_curReaderSetting.btWorkAntenna = btWorkAntenna;
        }
    }

    private void runLoopFastSwitch() {
        if (ReaderHelper.m_curInventoryBuffer.bLoopInventory) {
            mReader.fastSwitchAntInventory(ReaderHelper.m_curReaderSetting.btReadId, ReaderHelper.m_curInventoryBuffer.btA, ReaderHelper.m_curInventoryBuffer.btStayA, ReaderHelper.m_curInventoryBuffer.btB, ReaderHelper.m_curInventoryBuffer.btStayB, ReaderHelper.m_curInventoryBuffer.btC, ReaderHelper.m_curInventoryBuffer.btStayC, ReaderHelper.m_curInventoryBuffer.btD, ReaderHelper.m_curInventoryBuffer.btStayD, ReaderHelper.m_curInventoryBuffer.btInterval, ReaderHelper.m_curInventoryBuffer.btFastRepeat);
        }
    }
}

