/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.uhf.UHF6;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.rscja.deviceapi.RFIDWithUHF;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.uhf.uhf.Common.Comm;
import com.uhf.uhf.Common.InventoryBuffer;
import com.uhf.uhf.UHF1.UHF001;
import com.uhf.uhf.UHF5helper.ReaderHelper;
import com.uhf.uhf.UHF6.tools.StringUtils;

public class UHF006 {
    boolean loopFlag = false;
    byte initQ;
    public static Handler UHF6handler;
    private static Runnable runnable_refreshlist;

    public void readTag(int ReadStyle) {
        try {
            UHF6handler.postDelayed(runnable_refreshlist, 0L);
            switch (ReadStyle) {
                case 0: {
                    String strUII = Comm.baseTabFragment.mReader.inventorySingleTag();
                    if (!TextUtils.isEmpty((CharSequence)strUII)) {
                        String strEPC = Comm.baseTabFragment.mReader.convertUiiToEPC(strUII);
                        InventoryBuffer.InventoryTagMap tag = null;
                        Integer findIndex = ReaderHelper.m_curInventoryBuffer.dtIndexMap.get(strEPC);
                        if (findIndex == null) {
                            tag = new InventoryBuffer.InventoryTagMap();
                            tag.strEPC = strEPC;
                            tag.nReadCount = 1;
                            ReaderHelper.m_curInventoryBuffer.lsTagList.add(tag);
                            Log.e((String)"runnable", (String)"findIndex dtIndexMap.put");
                            ReaderHelper.m_curInventoryBuffer.dtIndexMap.put(strEPC, ReaderHelper.m_curInventoryBuffer.lsTagList.size() - 1);
                            break;
                        }
                        tag = ReaderHelper.m_curInventoryBuffer.lsTagList.get(findIndex);
                        ++tag.nReadCount;
                    }
                    break;
                }
                case 1: {
                    Log.d((String)"UHFREAD", (String)"startInventoryTag");
                    if (Comm.baseTabFragment.mReader.startInventoryTag(0, 0)) {
                        Log.d((String)"UHFREAD", (String)"startInventoryTag=TRUE");
                        this.loopFlag = true;
                        new TagThread().start();
                        break;
                    }
                    Comm.baseTabFragment.mReader.stopInventory();
                    return;
                }
                case 2: {
                    if (Comm.baseTabFragment.mReader.startInventoryTag(1, Comm.Qvalue)) {
                        this.loopFlag = true;
                        new TagThread().start();
                        break;
                    }
                    Comm.baseTabFragment.mReader.stopInventory();
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"UHFREAD", (String)("Exception:" + e.getMessage()));
        }
    }

    public void UHF6Stop() {
        this.loopFlag = false;
        Comm.baseTabFragment.mReader.stopInventory();
        UHF6handler.removeCallbacks(runnable_refreshlist);
    }

    public boolean setUHF6Parameters() {
        return true;
    }

    public String uhf6readOp(int ant, int tagBank, String opCount, String startAdd, int datatype) {
        Log.d((String)"uhf6readOp", (String)"uhf6readOp:");
        String strEPC = "";
        try {
            if (startAdd.equals("")) {
                return "";
            }
            if (!TextUtils.isDigitsOnly((CharSequence)startAdd)) {
                return " ";
            }
            if (opCount.equals("")) {
                return "";
            }
            if (!TextUtils.isDigitsOnly((CharSequence)opCount)) {
                return "";
            }
            if (!TextUtils.isEmpty((CharSequence)Comm.strPwd)) {
                if (Comm.strPwd.length() != 8) {
                    return "";
                }
            } else {
                Comm.strPwd = "00000000";
            }
            String strtagBank = "UII";
            if (tagBank == 0) {
                strtagBank = "RESERVED";
            } else if (tagBank == 1) {
                strtagBank = "UII";
            } else if (tagBank == 1) {
                strtagBank = "TID";
            } else if (tagBank == 1) {
                strtagBank = "USER";
            }
            SimpleRFIDEntity entity = Comm.baseTabFragment.mReader.readData(Comm.strPwd, RFIDWithUHF.BankEnum.valueOf((String)strtagBank), Integer.parseInt(startAdd), Integer.parseInt(opCount));
            if (entity != null) {
                strEPC = entity.getData();
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("IllegalArgumentException:" + e.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("Exception:" + ex.getMessage()));
        }
        return strEPC;
    }

    public boolean uhf6writeOp(int ant, int tagBank, String opCount, String startAdd, int datatype, String strWriteData) {
        try {
            if (!StringUtils.isNotEmpty(Comm.strPwd)) {
                Comm.strPwd = "00000000";
            }
            String strtagBank = "UII";
            if (tagBank == 0) {
                strtagBank = "RESERVED";
            } else if (tagBank == 1) {
                strtagBank = "UII";
            } else if (tagBank == 1) {
                strtagBank = "TID";
            } else if (tagBank == 1) {
                strtagBank = "USER";
            }
            String strUII = Comm.baseTabFragment.mReader.inventorySingleTag();
            return Comm.baseTabFragment.mReader.writeData(Comm.strPwd, RFIDWithUHF.BankEnum.valueOf((String)strtagBank), Integer.parseInt(startAdd), Integer.valueOf(opCount).intValue(), strWriteData, strUII);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("IllegalArgumentException:" + e.getMessage()));
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("Exception:" + ex.getMessage()));
            return false;
        }
    }

    public boolean uhf6lockOp(int ant, int lbank, int ltype) {
        try {
            if (!TextUtils.isEmpty((CharSequence)Comm.strPwd)) {
                if (Comm.strPwd.length() != 8) {
                    return false;
                }
                if (!Comm.baseTabFragment.vailHexInput(Comm.strPwd)) {
                    return false;
                }
            } else {
                return false;
            }
            String lockCode = "";
            if ((lbank == 0 || lbank == 1 || lbank == 2 || lbank == 3 || lbank == 4) && ltype == 0) {
                lockCode = "000000";
            } else if (lbank == 0 && ltype == 1) {
                lockCode = "080200";
            } else if (lbank == 1 && ltype == 1) {
                lockCode = "020080";
            } else if (lbank == 2 && ltype == 1) {
                lockCode = "008020";
            } else if (lbank == 3 && ltype == 1) {
                lockCode = "002008";
            } else if (lbank == 4 && ltype == 1) {
                lockCode = "000802";
            } else if (lbank == 0 && ltype == 2) {
                lockCode = "040100";
            } else if (lbank == 1 && ltype == 2) {
                lockCode = "010040";
            } else if (lbank == 2 && ltype == 2) {
                lockCode = "004010";
            } else if (lbank == 3 && ltype == 2) {
                lockCode = "001004";
            } else if (lbank == 4 && ltype == 2) {
                lockCode = "000401";
            }
            String strUII = Comm.baseTabFragment.mReader.inventorySingleTag();
            Boolean b = Comm.baseTabFragment.mReader.lockMem(Comm.strPwd, lockCode, strUII);
            return b != false;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("Exception:" + e.getMessage()));
            return false;
        }
    }

    public String getOutputPower() {
        String strPower = "";
        try {
            int iPower = Comm.baseTabFragment.mReader.getPower();
            if (iPower > -1) {
                strPower = String.valueOf(iPower);
            }
            Log.d((String)"uhf6readOp", (String)("iPower:" + String.valueOf(iPower)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("Exception:" + e.getMessage()));
        }
        return strPower;
    }

    public Boolean setOutputPower(int power) {
        Log.d((String)"uhf6readOp", (String)("power:" + String.valueOf(power)));
        try {
            if (Comm.baseTabFragment.mReader.setPower(power)) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("Exception:" + e.getMessage()));
            return false;
        }
    }

    public int getFrequencyRegion() {
        int idx = Comm.baseTabFragment.mReader.getFrequencyMode();
        Log.d((String)"uhf6readOp", (String)("idx:" + String.valueOf(idx)));
        return idx;
    }

    public boolean setFrequencyRegion(int Region) {
        try {
            return Comm.baseTabFragment.mReader.setFrequencyMode((byte)Region);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)"uhf6readOp", (String)("Exception:" + e.getMessage()));
            return false;
        }
    }

    static {
        runnable_refreshlist = new Runnable(){

            @Override
            public void run() {
                Comm.lsTagList = ReaderHelper.m_curInventoryBuffer.lsTagList;
                Message m = Message.obtain((Handler)UHF001.mhandler, (int)3);
                Bundle bundle = new Bundle();
                m.setData(bundle);
                UHF001.mhandler.sendMessage(m);
                UHF6handler.postDelayed((Runnable)this, 0L);
            }
        };
    }

    class TagThread
    extends Thread {
        TagThread() {
        }

        @Override
        public void run() {
            Log.d((String)"UHFREAD", (String)"UHFREAD run");
            String[] res = null;
            while (UHF006.this.loopFlag) {
                res = Comm.baseTabFragment.mReader.readTagFromBuffer();
                if (res != null) {
                    InventoryBuffer.InventoryTagMap tag;
                    Log.d((String)"UHFREAD", (String)"res != null");
                    String strTid = res[0];
                    String strResult = !strTid.equals("0000000000000000") && !strTid.equals("000000000000000000000000") ? "TID:" + strTid + "\n" : "";
                    String strEPC = Comm.baseTabFragment.mReader.convertUiiToEPC(res[1]);
                    String strRSSI = res[2];
                    Integer findIndex = ReaderHelper.m_curInventoryBuffer.dtIndexMap.get(strEPC);
                    if (findIndex == null) {
                        tag = new InventoryBuffer.InventoryTagMap();
                        tag.strEPC = strEPC;
                        tag.nReadCount = 1;
                        ReaderHelper.m_curInventoryBuffer.lsTagList.add(tag);
                        ReaderHelper.m_curInventoryBuffer.dtIndexMap.put(strEPC, ReaderHelper.m_curInventoryBuffer.lsTagList.size() - 1);
                        if (!Comm.repeatSound) {
                            Comm.playSound();
                        }
                    } else {
                        tag = ReaderHelper.m_curInventoryBuffer.lsTagList.get(findIndex);
                        ++tag.nReadCount;
                        if (Comm.repeatSound) {
                            Comm.playSound();
                        }
                    }
                    Log.d((String)"UHFREAD", (String)"findIndex");
                }
                try {
                    TagThread.sleep(Comm.rfidSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

