/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.os.Build;
import android.util.Log;
import com.rscja.deviceapi.exception.ConfigurationException;
import java.lang.reflect.Method;

public class DeviceConfiguration {
    private static final String TAG = "DeviceConfiguration";
    private static String model = Build.DISPLAY.toUpperCase();
    private static final String uart_mtk = "/dev/ttyMT3";
    private static final String uart_mtk_6735 = "/dev/ttyMT2";
    private static final String uart_mtk_2 = "/dev/ttyMT1";
    private static final String uart_msm = "/dev/ttyHSL1";
    private static final String uart_Fingerprint_mtk = "/dev/ttyMT0";
    private static final String uart_Fingerprint_msm = "/dev/ttyHSL1";
    private static String uartPath = "/dev/ttyMT3";
    private static String uartPath_Fingerprint = "/dev/ttyMT0";
    public static String C6000_6735 = "C6000_6735";
    public static String H100_6735 = "H100_6735";
    public static String C70_6735 = "C70_6735";
    public static String C72_6735 = "C72_6735";
    public static String C6000_8909 = "C6000_8909";
    public static String C4050_8909 = "C4050_8909";
    public static String C4000_6582 = "C4000_6582";
    public static String C4050_6582 = "C4050_6582";
    public static String C4000_6577 = "C4000_6577";
    private String deviceName;
    private String uart;
    private int baudrate;

    static {
        String modelInfo = "";
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method get = systemProperties.getDeclaredMethod("get", String.class);
            modelInfo = (String)get.invoke(null, "ro.cw.model");
            Log.d((String)"rscja", (String)("cw.model:" + modelInfo));
        }
        catch (Exception systemProperties) {
            // empty catch block
        }
        if (modelInfo != null && !modelInfo.equals("")) {
            String[] info = null;
            info = modelInfo.split("\\.");
            model = info[2].toUpperCase();
            if (info[0].equals("mtk")) {
                if (info[1].equals("6735")) {
                    if (model.contains("C6000")) {
                        uartPath = uart_mtk_6735;
                        uartPath_Fingerprint = uart_Fingerprint_mtk;
                        model = "C6000_6735";
                    } else if (model.contains("C70")) {
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = uart_mtk;
                        model = "C70_6735";
                    } else if (model.contains("H100")) {
                        model = "H100_6735";
                    } else if (model.contains("C72")) {
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = uart_mtk;
                        model = "C72_6735";
                    }
                } else if (info[1].equals("6582")) {
                    if (model.contains("C4000")) {
                        model = "C4000_6582";
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = uart_Fingerprint_mtk;
                    } else if (model.contains("C4050")) {
                        model = "C4050_6582";
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = uart_Fingerprint_mtk;
                    }
                } else if (info[1].equals("6577")) {
                    model = "C4000_6577";
                    uartPath = uart_mtk;
                    uartPath_Fingerprint = uart_Fingerprint_mtk;
                }
            } else if (info[0].equals("qualcomm") && info[1].equals("8909")) {
                if (model.contains("C6000")) {
                    model = "C6000_8909";
                    uartPath = "/dev/ttyHSL1";
                    uartPath_Fingerprint = "/dev/ttyHSL1";
                } else if (model.contains("C4050")) {
                    model = "C4050_8909";
                    uartPath = "/dev/ttyHSL1";
                    uartPath_Fingerprint = "/dev/ttyHSL1";
                }
            }
        } else if (model.contains("C4000")) {
            model = "C4000_6577";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40006577")) {
            model = "C4000_6577";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40006582")) {
            model = "C4000_6582";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40506582")) {
            model = "C4050_6582";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40508909")) {
            model = "C4050_8909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else if (model.contains("60008909")) {
            model = "C6000_8909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else if (model.contains("6735")) {
            if (model.contains("6000")) {
                model = "C6000_6735";
                uartPath = uart_mtk_6735;
                uartPath_Fingerprint = uart_Fingerprint_mtk;
            } else if (model.contains("100")) {
                model = "H100_6735";
            } else if (model.contains("72")) {
                uartPath = uart_mtk;
                uartPath_Fingerprint = uart_mtk;
                model = "C72_6735";
            } else if (model.contains("70S") || model.contains("70E") || model.contains("70F")) {
                uartPath = uart_mtk;
                uartPath_Fingerprint = uart_mtk;
                model = "C70_6735";
            }
        } else if (model.contains("20151118")) {
            model = "C4050_8909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else {
            model = "C4000_6735";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        }
        Log.i((String)TAG, (String)("model=" + model + "  static uartPath=" + uartPath + " uartPath_Fingerprint=" + uartPath_Fingerprint));
    }

    public static String getModel() {
        if (model.equals("i760")) {
            return "C4000";
        }
        Log.i((String)TAG, (String)("getModel() model=" + model));
        return model.toUpperCase();
    }

    public static DeviceConfiguration builder1DConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builder2DConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builderRFIDConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderUHFConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderPrinterConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builderFingerprintConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath_Fingerprint, 57600);
    }

    public static DeviceConfiguration builderLFConfiguration() throws ConfigurationException {
        Log.i((String)TAG, (String)("builderLFConfiguration() DeviceName:" + DeviceConfiguration.getModel() + " Uart=" + uartPath + " Baudrate=" + 115200));
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderBDConfiguration() throws ConfigurationException {
        if (model.equals("CJ6008909")) {
            return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
        }
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uart_mtk_2, 9600);
    }

    public static DeviceConfiguration builderInfraredConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 1200);
    }

    public static DeviceConfiguration builderDefaultConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setUart(String uart) {
        this.uart = uart;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    private DeviceConfiguration(String deviceName, String uart, int baudrate) {
        this.deviceName = deviceName;
        this.uart = uart;
        this.baudrate = baudrate;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getUart() {
        return this.uart;
    }

    public int getBaudrate() {
        return this.baudrate;
    }
}

