/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.BDNavigation;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;

public class Module {
    private static final String TAG = "DeviceAPI_Module";
    private static Module single = null;
    protected DeviceConfiguration config;

    private Module() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Module getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<Module> clazz = Module.class;
        synchronized (Module.class) {
            if (single != null) return single;
            single = new Module();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public boolean powerOn(int module) {
        switch (module) {
            case 1: {
                try {
                    this.config = DeviceConfiguration.builder1DConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    this.config = DeviceConfiguration.builderUHFConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    this.config = DeviceConfiguration.builderFingerprintConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        int result = -1;
        if (this.config != null) {
            Log.i((String)TAG, (String)("config.getDeviceName()=" + this.config.getDeviceName() + "  module=" + module));
            result = this.getDeviceAPI().ModulePowerOn(this.config.getDeviceName(), module);
        }
        return result != -1;
    }

    public void ioctl_gpio(int gpio, boolean isHigh) {
        this.getDeviceAPI().ioctl_gpio(DeviceConfiguration.getModel(), gpio, isHigh ? 1 : 0);
    }

    public boolean powerOff(int module) {
        int result = -1;
        return this.config != null && (result = this.getDeviceAPI().ModulePowerOff(this.config.getDeviceName(), module)) != -1;
    }

    @Deprecated
    boolean uartSwitch(int module) {
        int result = this.getDeviceAPI().UartSwitch(this.config.getDeviceName(), module);
        return result != -1;
    }

    @Deprecated
    public synchronized boolean uartSwitch2(int module) {
        int result = -1;
        switch (module) {
            case 2: {
                try {
                    BDNavigation.getInstance().setClosePort();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                result = this.getDeviceAPI().UartSwitch(DeviceConfiguration.getModel(), module);
                break;
            }
            case 7: {
                result = this.getDeviceAPI().UartSwitch(DeviceConfiguration.getModel(), module);
                try {
                    BDNavigation.getInstance().setOpenPort();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    BDNavigation.getInstance().setClosePort();
                }
                catch (ConfigurationException e1) {
                    e1.printStackTrace();
                }
                result = this.getDeviceAPI().UartSwitch(DeviceConfiguration.getModel(), module);
            }
        }
        return result != -1;
    }

    public synchronized boolean init(int module) {
        int result = -1;
        switch (module) {
            case 1: {
                try {
                    this.config = DeviceConfiguration.builder1DConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    this.config = DeviceConfiguration.builderUHFConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    this.config = DeviceConfiguration.builderFingerprintConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return this.config != null && (result = this.getDeviceAPI().ModuleInit(this.config.getDeviceName(), this.config.getUart(), this.config.getBaudrate(), module)) > -1;
    }

    public synchronized boolean init(int module, int baudrate) {
        int result = -1;
        switch (module) {
            case 1: {
                try {
                    this.config = DeviceConfiguration.builder1DConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    this.config = DeviceConfiguration.builderUHFConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    this.config = DeviceConfiguration.builderFingerprintConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return this.config != null && (result = this.getDeviceAPI().ModuleInit(this.config.getDeviceName(), this.config.getUart(), baudrate, module)) > -1;
    }

    @Deprecated
    synchronized boolean SerailOpen(int module, int baudrate, int check) {
        int result = -1;
        switch (module) {
            case 1: {
                try {
                    this.config = DeviceConfiguration.builder1DConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    this.config = DeviceConfiguration.builderUHFConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return this.config != null && (result = this.getDeviceAPI().SerailOpen(this.config.getDeviceName(), this.config.getUart(), baudrate, module, check)) != -1;
    }

    @Deprecated
    synchronized boolean SerailClose() {
        int result = -1;
        return this.config != null && (result = this.getDeviceAPI().SerailClose(this.config.getDeviceName())) != -1;
    }

    public synchronized boolean free() {
        int result = -1;
        return this.config != null && (result = this.getDeviceAPI().ModuleFree(this.config.getDeviceName())) != -1;
    }

    public synchronized boolean send(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        int iRes = DeviceAPI.getInstance().ModuleSend(data, data.length);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("send() err:" + iRes));
        return false;
    }

    public byte[] receive() {
        return DeviceAPI.getInstance().ModuleReceive();
    }
}

