/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.PrinterLowPager;
import com.rscja.utility.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Printer
extends Device {
    private boolean mLowPager = false;
    private static final String TAG = Printer.class.getSimpleName();
    protected DeviceConfiguration config = DeviceConfiguration.builderPrinterConfiguration();
    private static Printer single = null;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;

    protected Printer() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Printer getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<Printer> clazz = Printer.class;
        synchronized (Printer.class) {
            if (single != null) return single;
            single = new Printer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean init() throws SecurityException, IOException {
        int result = DeviceAPI.getInstance().UHFInit(this.config.getDeviceName());
        if (result == 0) {
            this.initSerialPort(new File(this.config.getUart()), this.config.getBaudrate(), 0);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized boolean free() {
        int result = DeviceAPI.getInstance().UHFFree(this.config.getDeviceName());
        try {
            if (this.mFileInputStream != null) {
                this.mFileInputStream.close();
            }
            if (this.mFileOutputStream != null) {
                this.mFileOutputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (DeviceAPI.getInstance().mFd != null) {
            DeviceAPI.getInstance().spClose();
        }
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err:" + result));
        return false;
    }

    private void initSerialPort(File device, int baudrate, int flags) throws SecurityException, IOException {
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec("/system/bin/su");
                String cmd = "chmod 666 " + device.getAbsolutePath() + "\n" + "exit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException();
            }
        }
        DeviceAPI.getInstance().mFd = DeviceAPI.getInstance().spOpen(device.getAbsolutePath(), baudrate, flags);
        if (DeviceAPI.getInstance().mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        this.mFileInputStream = new FileInputStream(DeviceAPI.getInstance().mFd);
        this.mFileOutputStream = new FileOutputStream(DeviceAPI.getInstance().mFd);
    }

    public synchronized void print(String content, String charsetName) throws PrinterLowPager {
        if (this.mFileOutputStream == null) {
            Log.e((String)TAG, (String)"print() mFileOutputStream is null");
            return;
        }
        if (StringUtility.isEmpty(content)) {
            Log.e((String)TAG, (String)"print() content is null");
            return;
        }
        String cName = charsetName;
        if (StringUtility.isEmpty(cName)) {
            cName = "gbk";
        }
        try {
            this.print(content.getBytes(cName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public synchronized void print(String content) throws PrinterLowPager {
        this.print(content, null);
    }

    public synchronized void print(byte[] buffer) throws PrinterLowPager {
        if (buffer == null || buffer.length <= 0) {
            Log.e((String)TAG, (String)"print() buffer == null || buffer.length <= 0");
            return;
        }
        try {
            Log.i((String)TAG, (String)("isLowPager 111 mLowPager=" + this.mLowPager));
            if (this.isLowPager()) {
                throw new PrinterLowPager();
            }
            Log.i((String)TAG, (String)("isLowPager 222 mLowPager=" + this.mLowPager));
            this.mFileOutputStream.write(buffer);
            Log.i((String)TAG, (String)("isLowPager 333 mLowPager=" + this.mLowPager));
            if (this.isLowPager()) {
                throw new PrinterLowPager();
            }
            if (this.isLowPager()) {
                throw new PrinterLowPager();
            }
            Log.i((String)TAG, (String)("isLowPager 444 mLowPager=" + this.mLowPager));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void sendCMD(byte[] buffer) {
        if (buffer == null || buffer.length <= 0) {
            Log.e((String)TAG, (String)"print() buffer == null || buffer.length <= 0");
            return;
        }
        try {
            this.mFileOutputStream.write(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isLowPager() {
        if (this.mFileInputStream == null) {
            return false;
        }
        if (this.mFileOutputStream == null) {
            return false;
        }
        new CheckPrinterThread().start();
        return this.mLowPager;
    }

    private class CheckPrinterThread
    extends Thread {
        private CheckPrinterThread() {
        }

        @Override
        public void run() {
            super.run();
            byte[] status = new byte[1];
            int len = 0;
            do {
                Log.i((String)TAG, (String)("CheckPrinterThread run() mLowPager=" + Printer.this.mLowPager + " ThreadId=" + Thread.currentThread().getId()));
                try {
                    Printer.this.mFileOutputStream.write(StringUtility.hexString2Bytes("1B760"));
                    len = Printer.this.mFileInputStream.read(status);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if ((status[0] >> 2 & 1) == 1) {
                    Printer.this.mLowPager = true;
                    Log.i((String)TAG, (String)("CheckPrinterThread run() change mLowPager=" + Printer.this.mLowPager + " ThreadId=" + Thread.currentThread().getId()));
                    return;
                }
                Printer.this.mLowPager = false;
                Log.i((String)TAG, (String)("CheckPrinterThread run() change mLowPager=" + Printer.this.mLowPager + " ThreadId=" + Thread.currentThread().getId()));
            } while (!this.isInterrupted());
        }
    }
}

