/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.RFIDBase;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;

public class RFIDWithISO14443A4CPU
extends RFIDBase {
    private static final String TAG = "RFIDWithISO14443A4CPU";
    private static RFIDWithISO14443A4CPU single = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithISO14443A4CPU getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithISO14443A4CPU> clazz = RFIDWithISO14443A4CPU.class;
        synchronized (RFIDWithISO14443A4CPU.class) {
            if (single != null) return single;
            single = new RFIDWithISO14443A4CPU();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected RFIDWithISO14443A4CPU() throws ConfigurationException {
    }

    public String sendCommand(String cmd) {
        if (StringUtility.isEmpty(cmd)) {
            Log.e((String)TAG, (String)"sendCommand() err:cmd  is empty");
            return null;
        }
        if (!StringUtility.isHexNumberRex(cmd)) {
            Log.e((String)TAG, (String)"sendCommand() err:cmd  not hex");
            return null;
        }
        char[] c = StringUtility.hexString2Chars(cmd);
        char[] result = this.getDeviceAPI().ISO14443A_cpu_command(c, c.length);
        if (result == null || result[0] != '\u0000' || result[1] == '\u0000') {
            Log.e((String)TAG, (String)("sendCommand() err:" + (result == null ? "null" : Integer.valueOf(result[0]))));
            return null;
        }
        char[] rs = new char[result[1]];
        int i = 0;
        while (i < rs.length) {
            rs[i] = result[i + 2];
            ++i;
        }
        return StringUtility.chars2HexString(rs, rs.length);
    }

    public String reset() {
        char[] result = this.getDeviceAPI().ISO14443A_cpu_reset();
        if (result == null || result[0] != '\u0000' || result[1] == '\u0000') {
            Log.e((String)TAG, (String)("reset() err:" + (result == null ? "null" : Integer.valueOf(result[0]))));
            return null;
        }
        char[] rs = new char[result[1]];
        int i = 0;
        while (i < rs.length) {
            rs[i] = result[i + 2];
            ++i;
        }
        return StringUtility.chars2HexString(rs, rs.length);
    }

    public String rats() {
        char[] result = this.getDeviceAPI().ISO14443A_cpu_rats();
        if (result == null || result[0] != '\u0000' || result[1] == '\u0000') {
            Log.e((String)TAG, (String)("rats() err:" + (result == null ? "null" : Integer.valueOf(result[0]))));
            return null;
        }
        char[] rs = new char[result[1]];
        int i = 0;
        while (i < rs.length) {
            rs[i] = result[i + 2];
            ++i;
        }
        return StringUtility.chars2HexString(rs, rs.length);
    }

    public static /* bridge */ /* synthetic */ RFIDBase getInstance() throws ConfigurationException {
        return RFIDWithISO14443A4CPU.getInstance();
    }
}

