/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.RFIDBase;
import com.rscja.deviceapi.entity.ISO15693Entity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.RFIDNotFoundException;
import com.rscja.deviceapi.exception.RFIDReadFailureException;
import com.rscja.utility.StringUtility;

public class RFIDWithISO15693
extends RFIDBase {
    private static final String TAG = "DeviceAPI_15693";
    private static RFIDWithISO15693 single = null;

    protected RFIDWithISO15693() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithISO15693 getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithISO15693> clazz = RFIDWithISO15693.class;
        synchronized (RFIDWithISO15693.class) {
            if (single != null) return single;
            single = new RFIDWithISO15693();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized ISO15693Entity inventory() {
        char[] result = this.getDeviceAPI().ISO15693_inventory(1, 0);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("inventory() err:" + Character.digit(result[0], 10)));
            return null;
        }
        ISO15693Entity entity = null;
        char[] cUID = new char[8];
        int i = 0;
        while (i < 8) {
            cUID[i] = result[i + 4];
            ++i;
        }
        String type = "";
        if (result.length > 10) {
            switch (result[10]) {
                case '\u0004': {
                    type = TagType.ICODE2.toString();
                    break;
                }
                case '\u0007': {
                    type = TagType.TI2048.toString();
                    break;
                }
                case '\u0002': {
                    type = TagType.STLRIS64K.toString();
                    break;
                }
            }
        }
        char[] cUID2 = new char[8];
        int i2 = 0;
        while (i2 < 8) {
            cUID2[i2] = cUID[7 - i2];
            ++i2;
        }
        String hexUID = StringUtility.chars2HexString(cUID2, 8);
        entity = new ISO15693Entity(hexUID, type, cUID, StringUtility.charsTobytes(cUID2, cUID2.length));
        char[] cInfo = entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_getSystemInformation(8, cUID, 0) : this.getDeviceAPI().ISO15693_getSystemInformation(0, cUID, 0);
        if (cInfo[0] == '\u0000' && cInfo[1] > '\f') {
            entity.setAFI(StringUtility.char2HexString(cInfo[12]));
            entity.setDESFID(StringUtility.char2HexString(cInfo[11]));
        }
        return entity;
    }

    public synchronized ISO15693Entity read(int block) throws RFIDReadFailureException {
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            return null;
        }
        char[] origUID = entity.getOriginalUID();
        char[] result = entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_read_sm(0, origUID, origUID.length, block, 1) : this.getDeviceAPI().ISO15693_read_sm(0, origUID, origUID.length, block, 1);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("read() err:" + result[0]));
            throw new RFIDReadFailureException();
        }
        char[] cData = new char[result[1]];
        int i = 0;
        while (i < cData.length) {
            cData[i] = result[i + 2];
            ++i;
        }
        entity.setData(StringUtility.chars2HexString(cData, cData.length));
        return entity;
    }

    public synchronized ISO15693Entity read(int startBlock, int Blocklen) throws RFIDReadFailureException {
        char[] result;
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            return null;
        }
        char[] origUID = entity.getOriginalUID();
        if (Blocklen > 10) {
            Blocklen = 10;
        }
        if ((result = entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_read_sm_ex(0, origUID, origUID.length, startBlock, Blocklen) : this.getDeviceAPI().ISO15693_read_sm_ex(0, origUID, origUID.length, startBlock, Blocklen))[0] != '\u0000') {
            Log.e((String)TAG, (String)("read() err:" + result[0]));
            throw new RFIDReadFailureException();
        }
        char[] cData = new char[result[1]];
        int i = 0;
        while (i < cData.length) {
            cData[i] = result[i + 2];
            ++i;
        }
        entity.setData(StringUtility.chars2HexString(cData, cData.length));
        return entity;
    }

    public synchronized boolean write(int block, String hexData) throws RFIDNotFoundException {
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            throw new RFIDNotFoundException();
        }
        char[] cData = StringUtility.hexString2Chars(hexData);
        char[] pszData = new char[4];
        if (cData.length >= 4) {
            int i = 0;
            while (i < 4) {
                pszData[i] = cData[i];
                ++i;
            }
        } else {
            int Len = 4 - cData.length;
            int i = 0;
            while (i < cData.length) {
                pszData[i + Len] = cData[i];
                ++i;
            }
        }
        char[] cUID = entity.getOriginalUID();
        int iRes = -1;
        if (entity.getType().equals(TagType.ICODE2.toString())) {
            iRes = this.getDeviceAPI().ISO15693_write_sm(0, cUID, 0, block, 1, pszData, pszData.length);
        } else if (entity.getType().equals(TagType.TI2048.toString())) {
            iRes = this.getDeviceAPI().ISO15693_write_sm(4, cUID, 0, block, 1, pszData, pszData.length);
        } else if (entity.getType().equals(TagType.STLRIS64K.toString())) {
            iRes = this.getDeviceAPI().ISO15693_write_sm(0, cUID, 0, block, 1, pszData, pszData.length);
        }
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("write() err:" + iRes));
        return false;
    }

    public synchronized boolean write(int startBlock, int Blocklen, String hexData) throws RFIDNotFoundException {
        char[] pszData;
        char[] cData;
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            throw new RFIDNotFoundException();
        }
        if (Blocklen > 10) {
            Blocklen = 10;
        }
        if ((cData = StringUtility.hexString2Chars(hexData)).length >= (pszData = new char[4 * Blocklen]).length) {
            int i = 0;
            while (i < pszData.length) {
                pszData[i] = cData[i];
                ++i;
            }
        } else {
            int m = 0;
            m = cData.length % 4;
            int i = 0;
            while (i < cData.length - m) {
                pszData[i] = cData[i];
                ++i;
            }
            if (m > 0) {
                if (m == 1) {
                    pszData[cData.length - 1 + 3] = cData[cData.length - 1];
                } else if (m == 2) {
                    pszData[cData.length - 2 + 3] = cData[cData.length - 1];
                    pszData[cData.length - 2 + 2] = cData[cData.length - 2];
                } else if (m == 3) {
                    pszData[cData.length - 3 + 3] = cData[cData.length - 1];
                    pszData[cData.length - 3 + 2] = cData[cData.length - 2];
                    pszData[cData.length - 3 + 1] = cData[cData.length - 3];
                }
            }
        }
        char[] cUID = entity.getOriginalUID();
        int iRes = -1;
        if (entity.getType().equals(TagType.ICODE2.toString())) {
            iRes = this.getDeviceAPI().ISO15693_write_sm_ex(0, cUID, cUID.length, startBlock, Blocklen, pszData, pszData.length);
        } else if (entity.getType().equals(TagType.TI2048.toString())) {
            iRes = this.getDeviceAPI().ISO15693_write_sm_ex(4, cUID, cUID.length, startBlock, Blocklen, pszData, pszData.length);
        } else if (entity.getType().equals(TagType.STLRIS64K.toString())) {
            iRes = this.getDeviceAPI().ISO15693_write_sm_ex(0, cUID, cUID.length, startBlock, Blocklen, pszData, pszData.length);
        }
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("write() err:" + iRes));
        return false;
    }

    public synchronized boolean writeAFI(int iAFI) throws RFIDNotFoundException {
        char[] data = new char[1];
        int AFI = Integer.parseInt(String.valueOf(iAFI), 16);
        int res = -1;
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            throw new RFIDNotFoundException();
        }
        if (entity.getType().equals(TagType.ICODE2.toString())) {
            res = this.getDeviceAPI().ISO15693_writeAFI(0, data, 0, AFI);
        } else if (entity.getType().equals(TagType.TI2048.toString())) {
            res = this.getDeviceAPI().ISO15693_writeAFI(4, data, 0, AFI);
        } else if (entity.getType().equals(TagType.STLRIS64K.toString())) {
            res = this.getDeviceAPI().ISO15693_writeAFI(0, data, 0, AFI);
        }
        if (res == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeAFI() err:" + res));
        return false;
    }

    public synchronized boolean lockAFI() throws RFIDNotFoundException {
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            throw new RFIDNotFoundException();
        }
        char[] data = new char[1];
        int res = -1;
        res = this.getDeviceAPI().ISO15693_lockAFI(0, data, 0);
        if (res == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("LockAFI() err:" + res));
        return false;
    }

    public synchronized boolean writeDSFID(int iDSFID) throws RFIDNotFoundException {
        char[] data = new char[1];
        int DSFID = Integer.parseInt(String.valueOf(iDSFID), 16);
        int res = -1;
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            throw new RFIDNotFoundException();
        }
        if (entity.getType().equals(TagType.ICODE2.toString())) {
            res = this.getDeviceAPI().ISO15693_writeDSFID(0, data, 0, DSFID);
        } else if (entity.getType().equals(TagType.TI2048.toString())) {
            res = this.getDeviceAPI().ISO15693_writeDSFID(4, data, 0, DSFID);
        } else if (entity.getType().equals(TagType.STLRIS64K.toString())) {
            res = this.getDeviceAPI().ISO15693_writeDSFID(0, data, 0, DSFID);
        }
        if (res == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeDSFID() err:" + res));
        return false;
    }

    public synchronized boolean lockDSFID() throws RFIDNotFoundException {
        char[] data = new char[1];
        int res = -1;
        ISO15693Entity entity = this.inventory();
        if (entity == null) {
            throw new RFIDNotFoundException();
        }
        res = entity.getType().equals(TagType.STLRIS64K.toString()) ? this.getDeviceAPI().ISO15693_lockDSFID(0, data, 0) : this.getDeviceAPI().ISO15693_lockDSFID(0, data, 0);
        if (res == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("LockDSFID() err:" + res));
        return false;
    }

    public char[] genericFunction(char command, char[] databuf, char datalen) {
        return this.getDeviceAPI().ISO15693_GenericFunction(command, databuf, datalen);
    }

    public static /* bridge */ /* synthetic */ RFIDBase getInstance() throws ConfigurationException {
        return RFIDWithISO15693.getInstance();
    }

    public static enum TagType {
        ICODE2(0),
        TI2048(4),
        STLRIS64K(8),
        NUll_(100);

        private final int value;

        public int getValue() {
            return this.value;
        }

        private TagType(int value) {
            this.value = value;
        }
    }
}

