/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.entity.AnimalEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class RFIDWithLF
extends Device {
    private static final String TAG = "RFIDWithLF";
    protected DeviceConfiguration config_LF = DeviceConfiguration.builderLFConfiguration();
    private static RFIDWithLF single = null;

    private RFIDWithLF() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithLF getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithLF> clazz = RFIDWithLF.class;
        synchronized (RFIDWithLF.class) {
            if (single != null) return single;
            single = new RFIDWithLF();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public synchronized boolean init() {
        Log.i((String)TAG, (String)("init() DeviceName:" + this.config_LF.getDeviceName() + " Uart=" + this.config_LF.getUart() + " Baudrate=" + this.config_LF.getBaudrate()));
        int result = this.getDeviceAPI().EM125k_init(this.config_LF.getDeviceName(), this.config_LF.getUart(), this.config_LF.getBaudrate());
        if (result > -1) {
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized boolean free() {
        int result = this.getDeviceAPI().EM125k_free(this.config_LF.getDeviceName());
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err:" + result));
        return false;
    }

    public synchronized String getHardwareVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        char[] cs = this.getDeviceAPI().HardwareVersion_125k();
        String str = null;
        if (cs[0] != '\u0000') {
            Log.e((String)TAG, (String)("getHardwareVersion() err:" + Integer.valueOf(cs[0])));
            return null;
        }
        str = new String(cs).trim();
        return str;
    }

    public synchronized String readDataWithIDCard(int iMode) {
        char[] result = this.read(iMode);
        if (result == null) {
            return null;
        }
        return StringUtility.chars2HexString(result, result.length);
    }

    private char[] read(int iMode) {
        if (iMode > 2 || iMode < 0) {
            return null;
        }
        char[] cs = this.getDeviceAPI().EM125k_read(iMode);
        if (cs[0] != '\u0000') {
            Log.e((String)TAG, (String)("read() err:" + Integer.valueOf(cs[0])));
            return null;
        }
        char[] nc = Arrays.copyOfRange(cs, 2, cs[1] + 2);
        return nc;
    }

    public synchronized AnimalEntity readAnimalTags(int iMode) {
        char[] result = this.read(iMode);
        if (result == null) {
            return null;
        }
        AnimalEntity entity = new AnimalEntity();
        char[] National_temp = new char[8];
        int i = 0;
        while (i < 8) {
            National_temp[i] = result[7 - i];
            ++i;
        }
        char[] Country_temp = new char[]{result[9], result[8]};
        char[] Reserved_temp = new char[]{result[11], result[10]};
        entity.setNationalID(StringUtility.charArrayTolong(National_temp));
        entity.setCountryID(StringUtility.charArrayTolong(Country_temp));
        entity.setReserved(StringUtility.charArrayTolong(Reserved_temp));
        char[] resultRaw = new char[result.length - 8];
        int i2 = 0;
        while (i2 < result.length - 8) {
            resultRaw[i2] = result[i2];
            ++i2;
        }
        char[] resultID = new char[8];
        int i3 = 0;
        while (i3 < 8) {
            resultID[i3] = result[resultRaw.length + i3];
            ++i3;
        }
        entity.setRawData(StringUtility.chars2HexString(resultRaw, resultRaw.length));
        entity.setIdData(StringUtility.chars2HexString(resultID, resultID.length));
        return entity;
    }

    public synchronized String readDataWithHitagS(int nPage) {
        char[] cs = this.getDeviceAPI().EM125k_ReadHitag(nPage);
        if (cs[0] != '\u0000') {
            Log.e((String)TAG, (String)("readWithHitagS() err:" + Integer.valueOf(cs[0])));
            return null;
        }
        char[] nc = Arrays.copyOfRange(cs, 2, cs[1] + 2);
        return StringUtility.chars2HexString(nc, nc.length);
    }

    public synchronized boolean writeDataWithHitagS(int nPage, String hexData) {
        if (StringUtility.isEmpty(hexData) || !StringUtility.isHexNumberRex(hexData)) {
            return false;
        }
        char[] pszData = StringUtility.hexString2Chars(hexData);
        int iResult = this.getDeviceAPI().EM125k_WriteHitagPage(nPage, pszData);
        if (iResult == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeDataWithHitagS() err:" + iResult));
        return false;
    }

    public synchronized String readDataWith4305Card(int nPage) {
        char[] cs = this.getDeviceAPI().EM125k_Read4305(nPage);
        if (cs[0] != '\u0000') {
            Log.e((String)TAG, (String)("readDataWith4305Card() err:" + Integer.valueOf(cs[0])));
            return null;
        }
        char[] nc = Arrays.copyOfRange(cs, 2, cs[1] + 2);
        return StringUtility.chars2HexString(nc, nc.length);
    }

    public synchronized boolean writeDataWith4305Card(int nPage, String hexData) {
        if (StringUtility.isEmpty(hexData) || !StringUtility.isHexNumberRex(hexData)) {
            return false;
        }
        char[] pszData = StringUtility.hexString2Chars(hexData);
        int iResult = this.getDeviceAPI().EM125k_Write4305(nPage, pszData);
        if (iResult == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeDataWith4305Card() err:" + iResult));
        return false;
    }

    public synchronized int getUIDWithHID() {
        return this.getDeviceAPI().HID_GetUid();
    }

    public synchronized String getUIDWithHitagS() {
        char[] cs = this.getDeviceAPI().EM125k_UID_REQ();
        if (cs[0] != '\u0000') {
            Log.e((String)TAG, (String)("getUIDWithHitagS() err:" + Integer.valueOf(cs[0])));
            return null;
        }
        char[] nc = Arrays.copyOfRange(cs, 2, cs[1] + 2);
        return StringUtility.chars2HexString(nc, nc.length);
    }

    public synchronized String getUIDWith4450Card() {
        char[] cs = this.getDeviceAPI().EM125K_GetEm4450UID();
        if (cs[0] != '\u0000') {
            Log.e((String)TAG, (String)("getUIDWith4450Card() err:" + Integer.valueOf(cs[0])));
            return null;
        }
        char[] nc = Arrays.copyOfRange(cs, 2, cs[1] + 2);
        return StringUtility.chars2HexString(nc, nc.length);
    }

    public synchronized boolean initWithNeedleTag() {
        int result = this.getDeviceAPI().EM125k_init_Ex(this.config_LF.getDeviceName(), this.config_LF.getUart(), this.config_LF.getBaudrate());
        if (result == 0) {
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized String readWithNeedleTag() {
        char[] cs = this.getDeviceAPI().EM125k_read_Ex();
        if (cs[0] != '\u0000') {
            Log.e((String)TAG, (String)("readWithNeedleTag() err:" + Integer.valueOf(cs[0])));
            return null;
        }
        char[] nc = Arrays.copyOfRange(cs, 2, cs[1] + 2);
        return new String(nc);
    }

    public synchronized int configFDXTag(char[] cidbuf, char[] nidbuf) {
        return this.getDeviceAPI().ConfigFDXTag(cidbuf, nidbuf);
    }

    public synchronized String EM125k_ReadHitag1() {
        char[] data = this.getDeviceAPI().EM125k_ReadHitag1();
        if (data[0] != '\u0000') {
            Log.e((String)TAG, (String)("EM125k_ReadHitag1() err:" + Integer.valueOf(data[0])));
            return null;
        }
        char[] nc = Arrays.copyOfRange(data, 2, data[1] + 2);
        return StringUtility.chars2HexString(nc, nc.length);
    }
}

