/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;

public class RFIDWithUHF706
extends Device {
    private static final String TAG = "RFIDWithUHF706";
    private static RFIDWithUHF706 single = null;
    protected DeviceConfiguration config = DeviceConfiguration.builderUHFConfiguration();

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHF706 getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithUHF706> clazz = RFIDWithUHF706.class;
        synchronized (RFIDWithUHF706.class) {
            if (single != null) return single;
            single = new RFIDWithUHF706();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    private RFIDWithUHF706() throws ConfigurationException {
    }

    public synchronized boolean init() {
        int result = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
        if (result > -1) {
            result = this.getDeviceAPI().UHF706_OpenAndConnect(this.config.getUart());
            if (result > -1) {
                this.setPowerOn(true);
                return true;
            }
            Log.e((String)TAG, (String)("init() err UHF706_OpenAndConnect result:" + result));
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + result));
        }
        return false;
    }

    public synchronized boolean free() {
        this.getDeviceAPI().UHF706_CloseAndDisconnect();
        int result = this.getDeviceAPI().UHFFree(this.config.getDeviceName());
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err UHFFree result:" + result));
        return false;
    }

    public int setRTC(long time) {
        return this.getDeviceAPI().Config_SetRTC(StringUtility.long2Bytes(time));
    }

    public long getRTC() {
        byte[] result = this.getDeviceAPI().Config_ReadRTC();
        if (result[0] != 0) {
            Log.e((String)TAG, (String)("getRTC() err result[0]:" + result[0]));
            return -1L;
        }
        byte[] time = new byte[8];
        int i = 0;
        while (i < 8) {
            time[i] = result[8 - i];
            ++i;
        }
        return StringUtility.byteArrayTolong(time);
    }

    public int setPara(int type, byte[] data) {
        return this.getDeviceAPI().Config_SetPara(type, (byte)data.length, data);
    }

    public byte[] getPara(int type) {
        return this.getDeviceAPI().Config_GetPara(type);
    }

    public byte[] getAccess() {
        return this.getDeviceAPI().Config_GetAccess();
    }

    public int setWorkMode(int nums, byte[] modebuf) {
        return this.getDeviceAPI().Config_SetWorkMode((byte)nums, modebuf);
    }

    public int SetTestMode() {
        return this.getDeviceAPI().SetTestMode();
    }

    public byte[] requestRandom() {
        byte[] result = this.getDeviceAPI().Auth_RequestRandom();
        if (result[0] == 0) {
            byte[] ras = new byte[8];
            int i = 0;
            while (i < 8) {
                ras[i] = result[i + 1];
                ++i;
            }
            return ras;
        }
        Log.e((String)TAG, (String)("requestRandom() result = " + result[0]));
        return null;
    }

    public int sendAuthData(byte[] hrandom, byte[] srandom, byte[] devid, byte[] reserve, byte[] signature, byte[] certbuf) {
        return this.getDeviceAPI().Auth_SendData(hrandom, srandom, devid, reserve, signature, certbuf.length, certbuf);
    }

    public byte[] sendUserInfo(byte[] province, byte[] city, byte[] jw, byte[] usage, byte[] type1, byte[] com_name, byte[] people, byte[] tel1, byte[] tel2, byte[] email, byte[] data, byte[] ps) {
        return this.getDeviceAPI().Auth_UserInfo(province, city, jw, usage, type1, com_name, people, tel1, tel2, email, data, ps);
    }

    public int sendActiveFile(byte transmode, byte[] deviceid, byte[] reverse, byte[] transbuf) {
        return this.getDeviceAPI().Auth_ActiveFile(transmode, deviceid, reverse, transbuf);
    }

    public byte[] readInfo() {
        return this.getDeviceAPI().Update_ReadInfo();
    }

    public int requsetReadPart(byte speed, byte des, byte flag, byte partnum, byte ptr, byte len) {
        return this.getDeviceAPI().Requset_ReadPart(speed, des, flag, partnum, ptr, len);
    }

    public int requsetWritePart(byte[] tid, byte num, byte startaddr, byte[] buf) {
        return this.getDeviceAPI().Requset_WritePart(tid, num, startaddr, (byte)buf.length, buf);
    }

    public int writeSpecialPart(byte[] buf) {
        return this.getDeviceAPI().Request_WriteSpecialPart(buf.length, buf);
    }

    public byte[] TransBuf(byte oper, byte[] buf) {
        return this.getDeviceAPI().TransBuf(oper, buf.length, buf);
    }

    public int setPower(byte[] buf) {
        if (buf.length < 2) {
            return -2;
        }
        return this.getDeviceAPI().SetConfig(buf);
    }

    public int SetInventorySper(int flag) {
        return this.getDeviceAPI().SetInventorySper(flag);
    }

    public int EventReport() {
        return this.getDeviceAPI().EventReport();
    }

    public int setFrequency(int freq) {
        return this.getDeviceAPI().SetInventoryFixed(freq);
    }

    public int Auth_CertificationChain(byte jlevel, byte jlevels, int jlen, byte[] jbuf) {
        return this.getDeviceAPI().Auth_CertificationChain(jlevel, jlevels, jlen, jbuf);
    }

    public byte[] TransData(byte[] tbuf, int tlen, byte flag) {
        byte[] result = this.getDeviceAPI().TransData(tbuf, tlen, flag);
        return result;
    }
}

