/*
 * Decompiled with CFR 0.152.
 */
package com.invengo.lib.system;

import com.invengo.lib.diagnostics.InvengoLog;
import com.invengo.lib.system.device.DeviceConfigManager;
import com.invengo.lib.system.device.DeviceManager;
import com.invengo.lib.system.device.type.DeviceType;

public class ModuleControl {
    private static final String TAG = ModuleControl.class.getSimpleName();
    private static final String VERSION = "1.0";
    private static final String XCRF1003 = "XCRF";

    static {
        System.loadLibrary("system_control");
    }

    public static void power1dBarcodeDevice(boolean enabled) {
        DeviceType type = DeviceManager.getDeviceType();
        int platform = type.getCode();
        InvengoLog.i((String)TAG, (String)"INFO. Type [%s:%d] Power Control 1D Barcode (%s)", (Object[])new Object[]{type, platform, enabled});
        switch (type) {
            case AT911: 
            case AT911_HILTI_US: 
            case AT911_HILTI_EU: {
                ModuleControl.enable2dScanner(false);
                if (enabled) {
                    ModuleControl.enableScanTrigger(enabled);
                    ModuleControl.enableScanAim(enabled);
                    ModuleControl.powerScan(enabled);
                    break;
                }
                ModuleControl.powerScan(enabled);
                ModuleControl.enableScanTrigger(enabled);
                ModuleControl.enableScanAim(enabled);
                break;
            }
            case AT911N: 
            case AT511: 
            case AT911N_HILTI_US: 
            case AT911N_HILTI_EU: 
            case AT870A: 
            case XC2910: {
                if (enabled) {
                    ModuleControl.enableScanTriggerEx(enabled, platform);
                    ModuleControl.enableScanAimEx(enabled, platform);
                    ModuleControl.powerScanEx(enabled, platform);
                    ModuleControl.enable2dScannerEx(false, platform);
                    break;
                }
                ModuleControl.powerScanEx(enabled, platform);
                ModuleControl.enable2dScannerEx(true, platform);
                ModuleControl.enableScanTriggerEx(enabled, platform);
                ModuleControl.enableScanAimEx(enabled, platform);
                break;
            }
            case AT311: 
            case AT312: 
            case XCRF1003: {
                ModuleControl.powerExt99Device(enabled);
                break;
            }
        }
    }

    public static void power2dBarcodeDevice(boolean enabled) {
        DeviceType type = DeviceManager.getDeviceType();
        int platform = type.getCode();
        InvengoLog.i((String)TAG, (String)"INFO. Power Control 2D Barcode (%s)", (Object[])new Object[]{enabled});
        switch (type) {
            case AT911: 
            case AT911_HILTI_US: 
            case AT911_HILTI_EU: {
                ModuleControl.enable2dScanner(true);
                if (enabled) {
                    ModuleControl.enableScanTrigger(enabled);
                    ModuleControl.enableScanAim(enabled);
                    ModuleControl.powerScan(enabled);
                    break;
                }
                ModuleControl.powerScan(enabled);
                ModuleControl.enableScanTrigger(enabled);
                ModuleControl.enableScanAim(enabled);
                break;
            }
            case AT911N: 
            case AT511: 
            case AT911N_HILTI_US: 
            case AT911N_HILTI_EU: 
            case AT870A: 
            case XC2910: {
                if (enabled) {
                    ModuleControl.powerScanEx(enabled, platform);
                    ModuleControl.enableScanTriggerEx(enabled, platform);
                    ModuleControl.enableScanAimEx(enabled, platform);
                    ModuleControl.enable2dScannerEx(false, platform);
                    break;
                }
                ModuleControl.powerScanEx(enabled, platform);
                ModuleControl.enable2dScannerEx(true, platform);
                ModuleControl.enableScanTriggerEx(enabled, platform);
                ModuleControl.enableScanAimEx(enabled, platform);
                break;
            }
            case AT311: 
            case AT312: 
            case XCRF1003: {
                ModuleControl.powerExt99Device(enabled);
                break;
            }
        }
    }

    public static void enableBarcodeFirmwareUpdate(boolean enabled) {
        DeviceType type = DeviceManager.getDeviceType();
        int platform = type.getCode();
        InvengoLog.i((String)TAG, (String)"INFO. Barcode firmware update (%s)", (Object[])new Object[]{enabled});
        switch (type) {
            case AT911: 
            case AT911_HILTI_US: 
            case AT911_HILTI_EU: {
                InvengoLog.e((String)TAG, (String)"Not supported!");
                break;
            }
            case AT911N: 
            case AT511: 
            case AT911N_HILTI_US: 
            case AT911N_HILTI_EU: 
            case AT870A: 
            case XC2910: {
                ModuleControl.enable2dScannerEx(enabled, platform);
                break;
            }
            case AT311: 
            case AT312: 
            case XCRF1003: {
                InvengoLog.e((String)TAG, (String)"Not supported!");
                break;
            }
        }
    }

    public static void powerRfidModule(boolean enabled) {
        DeviceType type = DeviceManager.getDeviceType();
        int platform = type.getCode();
        int moduleType = DeviceConfigManager.getInstance().getRfidType().getCode();
        InvengoLog.i((String)TAG, (String)"INFO. powerRfidModule(%s) - {%s, %d, %d}", (Object[])new Object[]{enabled, type, platform, moduleType});
        switch (type) {
            case AT911: 
            case AT911_HILTI_US: 
            case AT911_HILTI_EU: {
                ModuleControl.powerRfid(enabled);
                break;
            }
            case AT911N: 
            case AT511: 
            case AT911N_HILTI_US: 
            case AT911N_HILTI_EU: 
            case AT870A: 
            case XC2910: {
                ModuleControl.powerRfidEx(enabled, platform, moduleType);
                break;
            }
            case AT311: 
            case AT312: 
            case XCRF1003: {
                ModuleControl.powerExt99Device(enabled);
                break;
            }
        }
    }

    public static void powerRfidDevice(boolean enabled) {
        DeviceType type = DeviceManager.getDeviceType();
        int platform = type.getCode();
        int moduleType = DeviceConfigManager.getInstance().getRfidType().getCode();
        InvengoLog.i((String)TAG, (String)"INFO. powerRfidDevice(%s) - {%s, %d, %d}", (Object[])new Object[]{enabled, type, platform, moduleType});
        switch (type) {
            case AT911: 
            case AT911_HILTI_US: 
            case AT911_HILTI_EU: {
                ModuleControl.powerRfid(enabled);
                break;
            }
            case AT911N: 
            case AT511: 
            case AT911N_HILTI_US: 
            case AT911N_HILTI_EU: 
            case AT870A: 
            case XC2910: {
                ModuleControl.powerRfidEx(enabled, platform, moduleType);
                break;
            }
            case AT311: 
            case AT312: 
            case XCRF1003: {
                ModuleControl.powerExt99Device(enabled);
                break;
            }
        }
    }

    public static void resetRfidDevice() {
        DeviceType type = DeviceManager.getDeviceType();
        int platform = type.getCode();
        InvengoLog.i((String)TAG, (String)"INFO. resetRfidDevice() - {%s, %d}", (Object[])new Object[]{type, platform});
        switch (type) {
            case AT911: 
            case AT911_HILTI_US: 
            case AT911_HILTI_EU: {
                ModuleControl.resetRfid();
                break;
            }
            case AT911N: 
            case AT511: 
            case AT911N_HILTI_US: 
            case AT911N_HILTI_EU: 
            case AT870A: 
            case XC2910: {
                ModuleControl.resetRfidEx(platform);
                break;
            }
            case AT311: 
            case AT312: 
            case XCRF1003: {
                break;
            }
        }
    }

    private static native void resetRfid();

    private static native void powerRfid(boolean var0);

    private static native void powerScan(boolean var0);

    private static native void enable2dScanner(boolean var0);

    private static native void enableScanTrigger(boolean var0);

    private static native void enableScanAim(boolean var0);

    private static native void powerExtDevice(boolean var0);

    private static native void powerExt97Device(boolean var0);

    private static native void powerExt99Device(boolean var0);

    private static native void resetRfidEx(int var0);

    private static native void powerRfidEx(boolean var0, int var1, int var2);

    private static native void powerScanEx(boolean var0, int var1);

    private static native void enable2dScannerEx(boolean var0, int var1);

    private static native void enableScanTriggerEx(boolean var0, int var1);

    private static native void enableScanAimEx(boolean var0, int var1);

    public static native String getLibVersion();

    public static native int getHwVersion();

    public static String getVersion() {
        return VERSION;
    }
}

