/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.dao.impl;

import android.content.ContentValues;
import android.database.Cursor;
import cn.trinea.android.common.dao.HttpCacheDao;
import cn.trinea.android.common.entity.HttpResponse;
import cn.trinea.android.common.util.SqliteUtils;
import cn.trinea.android.common.util.StringUtils;
import cn.trinea.android.common.util.TimeUtils;
import java.util.HashMap;
import java.util.Map;

public class HttpCacheDaoImpl
implements HttpCacheDao {
    private SqliteUtils sqliteUtils;

    public HttpCacheDaoImpl(SqliteUtils sqliteUtils) {
        this.sqliteUtils = sqliteUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertHttpResponse(HttpResponse httpResponse) {
        ContentValues contentValues = HttpCacheDaoImpl.httpResponseToCV(httpResponse);
        if (contentValues == null) {
            return -1L;
        }
        Class<HttpCacheDaoImpl> clazz = HttpCacheDaoImpl.class;
        synchronized (HttpCacheDaoImpl.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.sqliteUtils.getWDb().replace("http_cache", null, contentValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse getHttpResponse(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        StringBuilder appWhere = new StringBuilder();
        appWhere.append("url").append("=?");
        String[] appWhereArgs = new String[]{url};
        Class<HttpCacheDaoImpl> clazz = HttpCacheDaoImpl.class;
        synchronized (HttpCacheDaoImpl.class) {
            Cursor cursor;
            block7: {
                cursor = this.sqliteUtils.getRDb().query("http_cache", null, appWhere.toString(), appWhereArgs, null, null, null);
                if (cursor != null) break block7;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
            HttpResponse httpResponse = null;
            if (cursor.moveToFirst()) {
                httpResponse = this.cursorToHttpResponse(cursor, url);
            }
            if (!cursor.isClosed()) {
                cursor.close();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return httpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, HttpResponse> getHttpResponsesByType(int type) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("type").append("=?");
        String[] whereClauseArgs = new String[]{Integer.toString(type)};
        Class<HttpCacheDaoImpl> clazz = HttpCacheDaoImpl.class;
        synchronized (HttpCacheDaoImpl.class) {
            Cursor cursor;
            block8: {
                cursor = this.sqliteUtils.getRDb().query("http_cache", null, whereClause.toString(), whereClauseArgs, null, null, null);
                if (cursor != null) break block8;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
            HashMap<String, HttpResponse> httpResponseMap = new HashMap<String, HttpResponse>();
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    HttpResponse httpResponse;
                    String url = cursor.getString(1);
                    if (!StringUtils.isEmpty(url) && (httpResponse = this.cursorToHttpResponse(cursor, url)) != null) {
                        httpResponseMap.put(url, httpResponse);
                    }
                    cursor.moveToNext();
                }
            }
            if (!cursor.isClosed()) {
                cursor.close();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return httpResponseMap;
        }
    }

    @Override
    public int deleteAllHttpResponse() {
        return this.sqliteUtils.getWDb().delete("type", null, null);
    }

    private HttpResponse cursorToHttpResponse(Cursor cursor, String url) {
        if (cursor == null) {
            return null;
        }
        if (url == null) {
            url = cursor.getString(1);
        }
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        HttpResponse httpResponse = new HttpResponse(url);
        httpResponse.setResponseBody(cursor.getString(2));
        httpResponse.setExpiredTime(cursor.getLong(3));
        httpResponse.setType(cursor.getInt(5));
        return httpResponse;
    }

    private static ContentValues httpResponseToCV(HttpResponse httpResponse) {
        if (httpResponse == null || StringUtils.isEmpty(httpResponse.getUrl())) {
            return null;
        }
        ContentValues values = new ContentValues();
        values.put("url", httpResponse.getUrl());
        values.put("response", httpResponse.getResponseBody());
        values.put("expires", Long.valueOf(httpResponse.getExpiredTime()));
        values.put("gmt_create", TimeUtils.getCurrentTimeInString());
        values.put("type", Integer.valueOf(httpResponse.getType()));
        return values;
    }
}

