/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.dao.impl;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import cn.trinea.android.common.dao.ImageSDCardCacheDao;
import cn.trinea.android.common.entity.CacheObject;
import cn.trinea.android.common.service.impl.ImageSDCardCache;
import cn.trinea.android.common.util.SqliteUtils;
import cn.trinea.android.common.util.StringUtils;
import java.util.Map;

public class ImageSDCardCacheDaoImpl
implements ImageSDCardCacheDao {
    private SqliteUtils sqliteUtils;

    public ImageSDCardCacheDaoImpl(SqliteUtils sqliteUtils) {
        this.sqliteUtils = sqliteUtils;
    }

    @Override
    public boolean putIntoImageSDCardCache(ImageSDCardCache imageSDCardCache, String tag) {
        if (imageSDCardCache == null || StringUtils.isEmpty(tag)) {
            return false;
        }
        StringBuilder selection = new StringBuilder();
        selection.append("tag").append("=?");
        String[] selectionArgs = new String[]{tag};
        Cursor cursor = this.sqliteUtils.getRDb().query("image_sdcard_cache", null, selection.toString(), selectionArgs, null, null, null);
        if (cursor == null) {
            return true;
        }
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                CacheObject<String> value = new CacheObject<String>();
                String imageUrl = cursor.getString(2);
                value.setData(cursor.getString(3));
                value.setUsedCount(cursor.getInt(6));
                value.setPriority(cursor.getInt(7));
                value.setExpired(cursor.getInt(8) == 1);
                value.setForever(cursor.getInt(9) == 1);
                imageSDCardCache.put(imageUrl, value);
                cursor.moveToNext();
            }
        }
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
        return true;
    }

    @Override
    public boolean deleteAndInsertImageSDCardCache(ImageSDCardCache imageSDCardCache, String tag) {
        if (imageSDCardCache == null || StringUtils.isEmpty(tag)) {
            return false;
        }
        SQLiteDatabase db = this.sqliteUtils.getWDb();
        db.beginTransaction();
        try {
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("tag").append("=?");
            String[] whereArgs = new String[]{tag};
            db.delete("image_sdcard_cache", whereClause.toString(), whereArgs);
            for (Map.Entry entry : imageSDCardCache.entrySet()) {
                CacheObject<String> value;
                String key;
                if (entry == null || (key = (String)entry.getKey()) == null || (value = entry.getValue()) == null) continue;
                db.insert("image_sdcard_cache", null, ImageSDCardCacheDaoImpl.cacheObjectToCV(tag, key, value));
            }
            db.setTransactionSuccessful();
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            db.endTransaction();
        }
    }

    private static ContentValues cacheObjectToCV(String tag, String url, CacheObject<String> value) {
        ContentValues values = new ContentValues();
        values.put("tag", tag);
        values.put("url", url);
        values.put("path", value.getData());
        values.put("enter_time", Long.valueOf(value.getEnterTime()));
        values.put("last_used_time", Long.valueOf(value.getLastUsedTime()));
        values.put("used_count", Long.valueOf(value.getUsedCount()));
        values.put("priority", Integer.valueOf(value.getPriority()));
        values.put("is_expired", Integer.valueOf(value.isExpired() ? 1 : 0));
        values.put("is_forever", Integer.valueOf(value.isForever() ? 1 : 0));
        return values;
    }
}

