/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.entity;

import cn.trinea.android.common.util.HttpUtils;
import cn.trinea.android.common.util.StringUtils;
import cn.trinea.android.common.util.TimeUtils;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    private String url;
    private String responseBody;
    private Map<String, Object> responseHeaders;
    private int type;
    private long expiredTime;
    private boolean isInCache;
    private boolean isInitExpiredTime;
    private int responseCode = -1;

    public HttpResponse(String url) {
        this.url = url;
        this.type = 0;
        this.isInCache = false;
        this.isInitExpiredTime = false;
        this.responseHeaders = new HashMap<String, Object>();
    }

    public HttpResponse() {
        this.responseHeaders = new HashMap<String, Object>();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    private Map<String, Object> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type < 0) {
            throw new IllegalArgumentException("The type of HttpResponse cannot be smaller than 0.");
        }
        this.type = type;
    }

    public void setExpiredTime(long expiredTime) {
        this.isInitExpiredTime = true;
        this.expiredTime = expiredTime;
    }

    public long getExpiredTime() {
        if (this.isInitExpiredTime) {
            return this.expiredTime;
        }
        this.isInitExpiredTime = true;
        this.expiredTime = this.getExpiresInMillis();
        return this.expiredTime;
    }

    public boolean isExpired() {
        return TimeUtils.getCurrentTimeInLong() > this.expiredTime;
    }

    public boolean isInCache() {
        return this.isInCache;
    }

    public HttpResponse setInCache(boolean isInCache) {
        this.isInCache = isInCache;
        return this;
    }

    public String getExpiresHeader() {
        try {
            return this.responseHeaders == null ? null : (String)this.responseHeaders.get("expires");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int getCacheControlMaxAge() {
        try {
            int start;
            String cacheControl = (String)this.responseHeaders.get("cache-control");
            if (!StringUtils.isEmpty(cacheControl) && (start = cacheControl.indexOf("max-age=")) != -1) {
                int end = cacheControl.indexOf(",", start);
                String maxAge = end != -1 ? cacheControl.substring(start + "max-age=".length(), end) : cacheControl.substring(start + "max-age=".length());
                return Integer.parseInt(maxAge);
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private long getExpiresInMillis() {
        int maxAge = this.getCacheControlMaxAge();
        if (maxAge != -1) {
            return System.currentTimeMillis() + (long)(maxAge * 1000);
        }
        String expire = this.getExpiresHeader();
        if (!StringUtils.isEmpty(expire)) {
            return HttpUtils.parseGmtTime(this.getExpiresHeader());
        }
        return -1L;
    }

    public void setResponseHeader(String field, String newValue) {
        if (this.responseHeaders != null) {
            this.responseHeaders.put(field, newValue);
        }
    }

    private Object getResponseHeader(String field) {
        return this.responseHeaders == null ? null : this.responseHeaders.get(field);
    }
}

