/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import cn.trinea.android.common.dao.HttpCacheDao;
import cn.trinea.android.common.dao.impl.HttpCacheDaoImpl;
import cn.trinea.android.common.entity.HttpRequest;
import cn.trinea.android.common.entity.HttpResponse;
import cn.trinea.android.common.util.ArrayUtils;
import cn.trinea.android.common.util.HttpUtils;
import cn.trinea.android.common.util.SqliteUtils;
import cn.trinea.android.common.util.StringUtils;
import cn.trinea.android.common.util.SystemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class HttpCache {
    private Context context;
    private Map<String, HttpResponse> cache;
    private HttpCacheDao httpCacheDao;
    private int type = -1;
    public static final Executor THREAD_POOL_EXECUTOR = Executors.newFixedThreadPool(SystemUtils.DEFAULT_THREAD_POOL_SIZE);

    public HttpCache(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("The context can not be null.");
        }
        this.context = context;
        this.cache = new ConcurrentHashMap<String, HttpResponse>();
        this.httpCacheDao = new HttpCacheDaoImpl(SqliteUtils.getInstance(context));
    }

    private HttpCache(Context context, int type) {
        this(context);
        this.type = type;
        this.initData(type);
    }

    private void initData(int type) {
        this.cache = this.httpCacheDao.getHttpResponsesByType(type);
        if (this.cache == null) {
            this.cache = new HashMap<String, HttpResponse>();
        }
    }

    public HttpResponse httpGet(HttpRequest request) {
        String[] requestCacheControls;
        String url;
        if (request == null || StringUtils.isEmpty(url = request.getUrl())) {
            return null;
        }
        HttpResponse cacheResponse = null;
        boolean isNoCache = false;
        boolean isNoStore = false;
        String requestCacheControl = request.getRequestProperty("cache-control");
        if (!StringUtils.isEmpty(requestCacheControl) && !ArrayUtils.isEmpty(requestCacheControls = requestCacheControl.split(","))) {
            ArrayList<String> requestCacheControlList = new ArrayList<String>();
            String[] stringArray = requestCacheControls;
            int n = requestCacheControls.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null) {
                    requestCacheControlList.add(s.trim());
                }
                ++n2;
            }
            if (requestCacheControlList.contains("no-cache")) {
                isNoCache = true;
            }
            if (requestCacheControlList.contains("no-store")) {
                isNoStore = true;
            }
        }
        if (!isNoCache) {
            cacheResponse = this.getFromCache(url);
        }
        return cacheResponse == null ? (isNoStore ? HttpUtils.httpGet(url) : this.putIntoCache(HttpUtils.httpGet(url))) : cacheResponse;
    }

    public void httpGet(String url, HttpCacheListener listener) {
        if (Build.VERSION.SDK_INT >= 14) {
            new HttpCacheStringAsyncTask(listener).executeOnExecutor(THREAD_POOL_EXECUTOR, new String[]{url});
        } else {
            new HttpCacheStringAsyncTask(listener).execute(new String[]{url});
        }
    }

    public void httpGet(HttpRequest request, HttpCacheListener listener) {
        new HttpCacheRequestAsyncTask(listener).executeOnExecutor(THREAD_POOL_EXECUTOR, new HttpRequest[]{request});
    }

    public HttpResponse httpGet(String url) {
        return this.httpGet(new HttpRequest(url));
    }

    public String httpGetString(String url) {
        HttpResponse cacheResponse = this.httpGet(new HttpRequest(url));
        return cacheResponse == null ? null : cacheResponse.getResponseBody();
    }

    public HttpResponse httpGetString(HttpRequest httpRequest) {
        return this.httpGet(httpRequest);
    }

    public boolean containsKey(String url) {
        return this.getFromCache(url) != null;
    }

    protected boolean isExpired(String url) {
        return this.getFromCache(url) == null;
    }

    public void clear() {
        this.cache.clear();
        this.httpCacheDao.deleteAllHttpResponse();
    }

    private int getType() {
        return this.type;
    }

    private HttpResponse putIntoCache(HttpResponse httpResponse) {
        String url;
        if (httpResponse == null || (url = httpResponse.getUrl()) == null) {
            return null;
        }
        if (this.type != -1 && this.type == httpResponse.getType()) {
            this.cache.put(url, httpResponse);
        }
        return this.httpCacheDao.insertHttpResponse(httpResponse) == -1L ? null : httpResponse;
    }

    public HttpResponse getFromCache(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        HttpResponse cacheResponse = this.cache.get(url);
        if (cacheResponse == null) {
            cacheResponse = this.httpCacheDao.getHttpResponse(url);
        }
        return cacheResponse == null || cacheResponse.isExpired() ? null : cacheResponse.setInCache(true);
    }

    public static abstract class HttpCacheListener {
        protected void onPreGet() {
        }

        protected void onPostGet(HttpResponse httpResponse, boolean isInCache) {
        }
    }

    private class HttpCacheRequestAsyncTask
    extends AsyncTask<HttpRequest, Void, HttpResponse> {
        private HttpCacheListener listener;

        public HttpCacheRequestAsyncTask(HttpCacheListener listener) {
            this.listener = listener;
        }

        protected HttpResponse doInBackground(HttpRequest ... httpRequest) {
            if (ArrayUtils.isEmpty(httpRequest)) {
                return null;
            }
            return HttpCache.this.httpGet(httpRequest[0]);
        }

        protected void onPreExecute() {
            if (this.listener != null) {
                this.listener.onPreGet();
            }
        }

        protected void onPostExecute(HttpResponse httpResponse) {
            if (this.listener != null) {
                this.listener.onPostGet(httpResponse, httpResponse == null ? false : httpResponse.isInCache());
            }
        }
    }

    private class HttpCacheStringAsyncTask
    extends AsyncTask<String, Void, HttpResponse> {
        private HttpCacheListener listener;

        public HttpCacheStringAsyncTask(HttpCacheListener listener) {
            this.listener = listener;
        }

        protected HttpResponse doInBackground(String ... url) {
            if (ArrayUtils.isEmpty(url)) {
                return null;
            }
            return HttpCache.this.httpGet(url[0]);
        }

        protected void onPreExecute() {
            if (this.listener != null) {
                this.listener.onPreGet();
            }
        }

        protected void onPostExecute(HttpResponse httpResponse) {
            if (this.listener != null) {
                this.listener.onPostGet(httpResponse, httpResponse == null ? false : httpResponse.isInCache());
            }
        }
    }
}

