/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service.impl;

import cn.trinea.android.common.service.FileNameRule;
import cn.trinea.android.common.util.FileUtils;
import cn.trinea.android.common.util.StringUtils;
import java.util.Calendar;

public class FileNameRuleCurrentTime
implements FileNameRule {
    private static final long serialVersionUID = 1L;
    private TimeRule timeRule;

    public FileNameRuleCurrentTime(TimeRule timeRule) {
        this.timeRule = timeRule;
    }

    @Override
    public String getFileName(String imageUrl) {
        long time;
        Calendar now = Calendar.getInstance();
        switch (this.timeRule) {
            case TO_MILLIS: {
                time = now.getTimeInMillis();
                break;
            }
            case YEAR: {
                time = now.get(1);
                break;
            }
            case DAY_OF_MONTH: {
                time = now.get(5);
                break;
            }
            case MILLISECOND: {
                time = now.get(14);
                break;
            }
            case HOUR_OF_DAY_TO_MILLIS: {
                time = ((now.get(11) * 60 + now.get(12)) * 60 + now.get(13)) * 1000 + now.get(14);
                break;
            }
            case HOUR_OF_DAY_TO_SECONDS: {
                time = (now.get(11) * 60 + now.get(12)) * 60 + now.get(13);
                break;
            }
            case HOUR_OF_DAY_TO_MINUTES: {
                time = now.get(11) * 60 + now.get(12);
                break;
            }
            case HOUR_TO_MILLIS: {
                time = ((now.get(10) * 60 + now.get(12)) * 60 + now.get(13)) * 1000 + now.get(14);
                break;
            }
            case MINUTE_TO_SECONDS: {
                time = now.get(12) * 60 + now.get(13);
                break;
            }
            case TO_SECONDS: {
                time = now.getTimeInMillis() / 1000L;
                break;
            }
            default: {
                time = now.getTimeInMillis();
            }
        }
        String ext = FileUtils.getFileExtension(imageUrl);
        return StringUtils.isEmpty(ext) ? Long.toString(time) : String.valueOf(Long.toString(time)) + "." + ext;
    }

    public static enum TimeRule {
        YEAR,
        DAY_OF_MONTH,
        MILLISECOND,
        HOUR_OF_DAY_TO_MILLIS,
        HOUR_OF_DAY_TO_SECONDS,
        HOUR_OF_DAY_TO_MINUTES,
        HOUR_TO_MILLIS,
        MINUTE_TO_SECONDS,
        TO_MILLIS,
        TO_SECONDS;

    }
}

